/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.controls;

import javax.naming.ldap.Control;
import oracle.ldap.util.ber.BEREncoder;
import oracle.ldap.util.ber.EncodeException;

public class ExecContextRequestControl
implements Control {
    private String controlID = "2.16.840.1.113894.1.8.31";
    private boolean criticality = false;
    private String controlVal = null;
    private int sequenceTag = 48;

    public String getID() {
        return this.controlID;
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public ExecContextRequestControl(boolean critVal, String ctlVal) {
        this.criticality = critVal;
        this.controlVal = ctlVal;
    }

    public byte[] getEncodedValue() {
        boolean encodeUTF8 = true;
        byte[] bytes = null;
        try {
            BEREncoder berElement = new BEREncoder();
            berElement.beginSeq(this.sequenceTag);
            berElement.encodeString(this.controlVal, encodeUTF8);
            berElement.endSeq();
            bytes = berElement.getTrimmedBuf();
            return bytes;
        }
        catch (EncodeException e) {
            return null;
        }
    }
}

