/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.ber;

import java.io.UnsupportedEncodingException;
import oracle.ldap.util.ber.BER;
import oracle.ldap.util.ber.EncodeException;

public final class BEREncoder
extends BER {
    private int curSeqIndex;
    private int[] seqOffset;
    private static final int INITIAL_SEQUENCES = 16;
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final int BUF_GROWTH_FACTOR = 8;

    public BEREncoder() {
        this(1024);
    }

    public BEREncoder(int bufsize) {
        this.buf = new byte[bufsize];
        this.bufsize = bufsize;
        this.offset = 0;
        this.seqOffset = new int[16];
        this.curSeqIndex = 0;
    }

    public void reset() {
        while (this.offset > 0) {
            this.buf[--this.offset] = 0;
        }
        while (this.curSeqIndex > 0) {
            this.seqOffset[--this.curSeqIndex] = 0;
        }
    }

    public int getDataLen() {
        return this.offset;
    }

    public byte[] getBuf() {
        if (this.curSeqIndex != 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        return this.buf;
    }

    public byte[] getTrimmedBuf() {
        int len = this.getDataLen();
        byte[] trimBuf = new byte[len];
        System.arraycopy(this.getBuf(), 0, trimBuf, 0, len);
        return trimBuf;
    }

    public void beginSeq(int tag) {
        if (this.curSeqIndex >= this.seqOffset.length) {
            int[] seqOffsetTmp = new int[this.seqOffset.length * 2];
            for (int i = 0; i < this.seqOffset.length; ++i) {
                seqOffsetTmp[i] = this.seqOffset[i];
            }
            this.seqOffset = seqOffsetTmp;
        }
        this.encodeByte(tag);
        this.seqOffset[this.curSeqIndex] = this.offset;
        this.ensureFreeBytes(3);
        this.offset += 3;
        ++this.curSeqIndex;
    }

    public void endSeq() throws EncodeException {
        --this.curSeqIndex;
        if (this.curSeqIndex < 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        int start = this.seqOffset[this.curSeqIndex] + 3;
        int len = this.offset - start;
        if (len <= 127) {
            this.shiftSeqData(start, len, -2);
            this.buf[this.seqOffset[this.curSeqIndex]] = (byte)len;
        } else if (len <= 255) {
            this.shiftSeqData(start, len, -1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -127;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)len;
        } else if (len <= 65535) {
            this.buf[this.seqOffset[this.curSeqIndex]] = -126;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(len >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)len;
        } else if (len <= 0xFFFFFF) {
            this.shiftSeqData(start, len, 1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -125;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(len >> 16);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)(len >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 3] = (byte)len;
        } else {
            throw new EncodeException("SEQUENCE too long");
        }
    }

    private void shiftSeqData(int start, int len, int shift) {
        if (shift > 0) {
            this.ensureFreeBytes(shift);
        }
        System.arraycopy(this.buf, start, this.buf, start + shift, len);
        this.offset += shift;
    }

    public void encodeByte(int b) {
        this.ensureFreeBytes(1);
        this.buf[this.offset++] = (byte)b;
    }

    public void encodeInt(int i) {
        this.encodeInt(i, 2);
    }

    public void encodeInt(int i, int tag) {
        int mask = -8388608;
        int intsize = 4;
        while (((i & mask) == 0 || (i & mask) == mask) && intsize > 1) {
            --intsize;
            i <<= 8;
        }
        this.encodeInt(i, tag, intsize);
    }

    private void encodeInt(int i, int tag, int intsize) {
        if (intsize > 4) {
            throw new IllegalArgumentException("BER encode error: INTEGER too long.");
        }
        this.ensureFreeBytes(2 + intsize);
        this.buf[this.offset++] = (byte)tag;
        this.buf[this.offset++] = (byte)intsize;
        int mask = -16777216;
        while (intsize-- > 0) {
            this.buf[this.offset++] = (byte)((i & mask) >> 24);
            i <<= 8;
        }
    }

    public void encodeBoolean(boolean b) {
        this.encodeBoolean(b, 1);
    }

    public void encodeBoolean(boolean b, int tag) {
        this.ensureFreeBytes(3);
        this.buf[this.offset++] = (byte)tag;
        this.buf[this.offset++] = 1;
        this.buf[this.offset++] = b ? -1 : 0;
    }

    public void encodeString(String str, boolean encodeUTF8) throws EncodeException {
        this.encodeString(str, 4, encodeUTF8);
    }

    public void encodeString(String str, int tag, boolean encodeUTF8) throws EncodeException {
        int count;
        this.encodeByte(tag);
        int i = 0;
        byte[] bytes = null;
        if (str == null) {
            count = 0;
        } else {
            if (encodeUTF8) {
                try {
                    bytes = str.getBytes("UTF8");
                    count = bytes.length;
                }
                catch (UnsupportedEncodingException e) {
                    throw new EncodeException("UTF8 not available on platform");
                }
            }
            try {
                bytes = str.getBytes("8859_1");
                count = bytes.length;
            }
            catch (UnsupportedEncodingException e) {
                throw new EncodeException("8859_1 not available on platform");
            }
        }
        this.encodeLength(count);
        this.ensureFreeBytes(count);
        while (i < count) {
            this.buf[this.offset++] = bytes[i++];
        }
    }

    public void encodeOctetString(byte[] tb, int tag, int tboffset, int length) throws EncodeException {
        this.encodeByte(tag);
        this.encodeLength(length);
        if (length > 0) {
            this.ensureFreeBytes(length);
            System.arraycopy(tb, tboffset, this.buf, this.offset, length);
            this.offset += length;
        }
    }

    public void encodeOctetString(byte[] tb, int tag) throws EncodeException {
        this.encodeOctetString(tb, tag, 0, tb.length);
    }

    private void encodeLength(int len) throws EncodeException {
        this.ensureFreeBytes(4);
        if (len < 128) {
            this.buf[this.offset++] = (byte)len;
        } else if (len <= 255) {
            this.buf[this.offset++] = -127;
            this.buf[this.offset++] = (byte)len;
        } else if (len <= 65535) {
            this.buf[this.offset++] = -126;
            this.buf[this.offset++] = (byte)(len >> 8);
            this.buf[this.offset++] = (byte)(len & 0xFF);
        } else if (len <= 0xFFFFFF) {
            this.buf[this.offset++] = -125;
            this.buf[this.offset++] = (byte)(len >> 16);
            this.buf[this.offset++] = (byte)(len >> 8);
            this.buf[this.offset++] = (byte)(len & 0xFF);
        } else {
            throw new EncodeException("string too long");
        }
    }

    public void encodeStringArray(String[] strs, boolean encodeUTF8) throws EncodeException {
        if (strs == null) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            this.encodeString(strs[i], encodeUTF8);
        }
    }

    private void ensureFreeBytes(int len) {
        if (this.bufsize - this.offset < len) {
            int newsize = this.bufsize * 8;
            if (newsize - this.offset < len) {
                newsize += len;
            }
            byte[] newbuf = new byte[newsize];
            System.arraycopy(this.buf, 0, newbuf, 0, this.offset);
            this.buf = newbuf;
            this.bufsize = newsize;
        }
    }
}

