/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ldap.util.QClosedException;

public class WorkQueue {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static final int DEFAULT_MAX_PRIORITY = 1;
    private int m_nMaxPriority = 1;
    private LinkedList m_queue = null;
    private boolean m_qClosed = false;
    private int m_nThrEnQWaitCnt = 0;
    private int m_nThrDeQWaitCnt = 0;
    private int m_nMaxElements = -1;
    private int m_nElemCnt = 0;

    public WorkQueue() {
        this.initQ(-1, 1);
    }

    public WorkQueue(int nMaxPriority) {
        this.initQ(-1, nMaxPriority);
    }

    public WorkQueue(int nMaxElements, int nMaxPriority) {
        this.initQ(nMaxElements, nMaxPriority);
    }

    private void initQ(int nMaxElements, int nMaxPriority) {
        Object subQ = null;
        if (0 >= nMaxElements && nMaxElements != -1) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (0 >= nMaxPriority) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        this.m_nMaxElements = nMaxElements;
        this.m_nMaxPriority = nMaxPriority;
        this.m_queue = new LinkedList();
        this.m_qClosed = false;
        for (int i = 0; i < nMaxPriority; ++i) {
            this.m_queue.addLast(subQ);
        }
    }

    private void addToQ(Object obj, int priority) {
        LinkedList<Object> subQ = (LinkedList<Object>)this.m_queue.get(priority - 1);
        if (null == subQ) {
            subQ = new LinkedList<Object>();
            this.m_queue.add(priority - 1, subQ);
        }
        subQ.addLast(obj);
        ++this.m_nElemCnt;
    }

    private Object removeFromQ() {
        Object retObj = null;
        for (int iCnt = this.m_nMaxPriority - 1; iCnt >= 0; --iCnt) {
            LinkedList subQ = (LinkedList)this.m_queue.get(iCnt);
            if (null == subQ || subQ.isEmpty()) continue;
            retObj = subQ.removeFirst();
            --this.m_nElemCnt;
            break;
        }
        return retObj;
    }

    public void enqueue(Object obj, int priority, Logger lgr) throws QClosedException {
        m_logger = lgr;
        this.enqueue(obj, priority);
    }

    public synchronized void enqueue(Object obj, int priority) throws QClosedException {
        if (null == obj) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        if (priority <= 0 || priority > this.m_nMaxPriority) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (this.m_qClosed) {
            throw new QClosedException("Q_CLOSED");
        }
        while (this.isFull()) {
            try {
                ++this.m_nThrEnQWaitCnt;
                this.wait();
                --this.m_nThrEnQWaitCnt;
            }
            catch (InterruptedException ie) {
                m_logger.log(Level.SEVERE, "Exception occurred", ie);
            }
            if (!this.m_qClosed) continue;
            throw new QClosedException("Q_CLOSED");
        }
        this.addToQ(obj, priority);
        this.notifyAll();
    }

    public void enqueue(Object obj) throws QClosedException {
        this.enqueue(obj, 1);
    }

    public synchronized boolean enqueueNoWait(Object obj, int priority) throws QClosedException {
        boolean retBool = false;
        if (null == obj) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        if (priority <= 0 || priority > this.m_nMaxPriority) {
            throw new IllegalArgumentException("VALUE_NOT_IN_RANGE");
        }
        if (this.m_qClosed) {
            throw new QClosedException("Q_CLOSED");
        }
        if (!this.isFull()) {
            this.addToQ(obj, priority);
            this.notifyAll();
            retBool = true;
        }
        return retBool;
    }

    public void enqueueNoWait(Object obj) throws QClosedException {
        this.enqueueNoWait(obj, 1);
    }

    public Object dequeue(Logger lgr) throws QClosedException {
        m_logger = lgr;
        return this.dequeue();
    }

    public synchronized Object dequeue() throws QClosedException {
        Object retObj = null;
        while (this.isEmpty()) {
            if (this.m_qClosed) {
                throw new QClosedException("Q_EMPTY_AND_CLOSED");
            }
            try {
                ++this.m_nThrDeQWaitCnt;
                this.wait();
                --this.m_nThrDeQWaitCnt;
            }
            catch (InterruptedException ie) {
                m_logger.log(Level.SEVERE, "Exception occurred", ie);
            }
        }
        retObj = this.removeFromQ();
        this.notifyAll();
        return retObj;
    }

    public synchronized Object dequeueNoWait() throws QClosedException {
        Object retObj = null;
        if (this.isEmpty() && this.m_qClosed) {
            throw new QClosedException("Q_EMPTY_AND_CLOSED");
        }
        retObj = this.removeFromQ();
        return retObj;
    }

    public synchronized void close() {
        this.m_qClosed = true;
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return 0 == this.m_nElemCnt;
    }

    public synchronized boolean isFull() {
        return this.m_nMaxElements == this.m_nElemCnt;
    }

    public synchronized int getSize() {
        return this.m_nElemCnt;
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        String NL = System.getProperty("line.separator");
        sbuf.append(NL).append("Queue Statistics").append(NL).append("----------------").append(NL).append("# max elements  : ").append(this.m_nMaxElements).append(NL).append("# elements in Q : ").append(this.m_nElemCnt).append(NL).append("# of EnQ wait T : ").append(this.m_nThrEnQWaitCnt).append(NL).append("# of DeQ wait T : ").append(this.m_nThrDeQWaitCnt).append(NL).append(NL);
        return sbuf.toString();
    }

    public static void main(String[] args) {
        int i;
        int nProducers = 1;
        int nConsumers = 1;
        int nBufSize = -1;
        if (args.length < 2) {
            System.out.println("Usage: java oracle.ldap.util.WorkQueue <#Producers> <#Consumers> [Buffer Size]");
            System.exit(0);
        }
        nProducers = Integer.parseInt(args[0]);
        nConsumers = Integer.parseInt(args[1]);
        if (args.length >= 3) {
            nBufSize = Integer.parseInt(args[2]);
        }
        System.out.println("Number of Producers: " + nProducers);
        System.out.println("number of Consumers: " + nConsumers);
        System.out.println("Buffer size: " + nBufSize);
        WorkQueue buffer = new WorkQueue(nBufSize, 1);
        for (i = 1; i <= nProducers; ++i) {
            class Producer
            extends Thread {
                private WorkQueue buffer;
                private int number;

                Producer(String name, WorkQueue buf) {
                    super(name);
                    this.buffer = buf;
                    this.number = 1;
                }

                public void run() {
                    while (true) {
                        System.out.println(this.getName() + " - Produced " + this.number);
                        try {
                            this.buffer.enqueue(this.number + " from " + this.getName(), 1);
                            ++this.number;
                        }
                        catch (QClosedException qce) {
                            qce.printStackTrace();
                            System.out.println("Seizing to produce .....");
                            break;
                        }
                        try {
                            Random r = new Random();
                            Producer.sleep((int)(-1.0 * Math.log(r.nextDouble())));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            Producer p = new Producer("Producer - " + i, buffer);
            p.start();
        }
        for (i = 1; i < 5; ++i) {
            System.out.println(buffer);
        }
        for (i = 1; i <= nConsumers; ++i) {
            class Consumer
            extends Thread {
                private WorkQueue buffer;

                Consumer(String name, WorkQueue buf) {
                    super(name);
                    this.buffer = buf;
                }

                public void run() {
                    while (true) {
                        String s = null;
                        try {
                            s = (String)this.buffer.dequeue();
                            System.out.println(this.getName() + " - Consumed " + s);
                        }
                        catch (QClosedException qce) {
                            qce.printStackTrace();
                            System.out.println("Seizing to consume.....");
                            break;
                        }
                        try {
                            Random r = new Random();
                            Consumer.sleep((int)(-1.0 * Math.log(r.nextDouble())));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            Consumer c = new Consumer("Consumer - " + i, buffer);
            c.start();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        buffer.close();
    }
}

