/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.LogFormatter;
import oracle.ldap.util.LogHandler;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;

public class UtilDebug {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    public static final int MODE_ALL = 127;
    public static final int MODE_LDAP_OPERATIONS = 2;
    public static final int MODE_LDAP_CONNECTION = 4;
    public static final int MODE_SUBSCRIBER_CLASS = 8;
    public static final int MODE_USER_CLASS = 16;
    public static final int MODE_PROVISIONING_API = 32;
    public static final int MODE_JAVA_API = 64;
    private static final Level loggingOnLevel = Level.FINE;
    private static final String parentLogger = "oracle.ldap.util";
    private static final String ldapOperationLogger = "oracle.ldap.util.ldap.operation";
    private static final String ldapConnectionLogger = "oracle.ldap.util.ldap.connection";
    private static final String subscriberLogger = "oracle.ldap.util.subscriber";
    private static final String userLogger = "oracle.ldap.util.user";
    private static final String provisioningLogger = "oracle.ldap.util.provisioning";
    private static final String jarUtilLogger = "oracle.ldap.util.jarUtil";
    private static Handler thisHandler = null;
    public static final int ERROR = -1;
    private static InheritableThreadLocal threadDebugMode;
    private static PrintStream pStream;
    private static InheritableThreadLocal threadPrintStream;

    private static Logger getDebugLogger(int debugMode) {
        switch (debugMode) {
            case 2: {
                return Logger.getLogger(ldapOperationLogger);
            }
            case 4: {
                return Logger.getLogger(ldapConnectionLogger);
            }
            case 8: {
                return Logger.getLogger(subscriberLogger);
            }
            case 16: {
                return Logger.getLogger(userLogger);
            }
            case 32: {
                return Logger.getLogger(provisioningLogger);
            }
            case 64: {
                return Logger.getLogger(jarUtilLogger);
            }
        }
        return null;
    }

    public static synchronized void setPrintStream(PrintStream ps) {
        if (ps != null) {
            ((LogHandler)thisHandler).setOutputStream(ps);
        }
    }

    public static synchronized void setDebugMode(int mode) {
        Logger.getLogger(ldapOperationLogger).setLevel((2 & mode) > 0 ? Level.FINE : Level.OFF);
        Logger.getLogger(ldapConnectionLogger).setLevel((4 & mode) > 0 ? Level.FINE : Level.OFF);
        Logger.getLogger(subscriberLogger).setLevel((8 & mode) > 0 ? Level.FINE : Level.OFF);
        Logger.getLogger(userLogger).setLevel((0x10 & mode) > 0 ? Level.FINE : Level.OFF);
        Logger.getLogger(provisioningLogger).setLevel((0x20 & mode) > 0 ? Level.FINE : Level.OFF);
        Logger.getLogger(jarUtilLogger).setLevel((0x40 & mode) > 0 ? Level.FINE : Level.OFF);
    }

    public static synchronized int getDebugMode() {
        int debugMode = 0;
        if (UtilDebug.getDebugLogger(2).isLoggable(loggingOnLevel)) {
            debugMode += 2;
        }
        if (UtilDebug.getDebugLogger(4).isLoggable(loggingOnLevel)) {
            debugMode += 4;
        }
        if (UtilDebug.getDebugLogger(8).isLoggable(loggingOnLevel)) {
            debugMode += 8;
        }
        if (UtilDebug.getDebugLogger(16).isLoggable(loggingOnLevel)) {
            debugMode += 16;
        }
        if (UtilDebug.getDebugLogger(32).isLoggable(loggingOnLevel)) {
            debugMode += 32;
        }
        if (UtilDebug.getDebugLogger(64).isLoggable(loggingOnLevel)) {
            debugMode += 64;
        }
        return debugMode;
    }

    public static synchronized void logNewLine(int debugMode) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        logger.log(loggingOnLevel, "\n");
    }

    public static synchronized void log(int debugMode, String header, String debugString) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        logger.log(loggingOnLevel, header + debugString);
    }

    public static synchronized void log(int debugMode, String header, Exception ex) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        logger.log(loggingOnLevel, header + ex.toString());
    }

    public static synchronized void log(int debugMode, String header, String[] debugStringArr) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel)) {
            if (debugStringArr == null) {
                logger.log(loggingOnLevel, " null");
            } else {
                for (int i = 0; i < debugStringArr.length; ++i) {
                    logger.log(loggingOnLevel, header + "  " + debugStringArr[i]);
                }
            }
            logger.log(loggingOnLevel, "\n");
        }
    }

    public static synchronized void log(int debugMode, String header, PropertySetCollection resultSet) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel)) {
            try {
                if (resultSet == null) {
                    return;
                }
                for (int i = 0; i < resultSet.size(); ++i) {
                    PropertySet curEntry = resultSet.getPropertySet(i);
                    Object obj = null;
                    logger.log(loggingOnLevel, "dn: " + curEntry.getDN());
                    for (int j = 0; j < curEntry.size(); ++j) {
                        Property curAttr = curEntry.getProperty(j);
                        for (int k = 0; k < curAttr.size(); ++k) {
                            obj = curAttr.getValue(k);
                            if (obj instanceof String) {
                                logger.log(loggingOnLevel, header + curAttr.getName() + ": " + (String)obj);
                                continue;
                            }
                            if (!(obj instanceof byte[])) continue;
                            logger.log(loggingOnLevel, header + curAttr.getName() + ": NON ASCII");
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.log(loggingOnLevel, "\n");
        }
    }

    public static synchronized void log(int debugMode, String header, ModPropertySet mps) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel)) {
            if (mps == null) {
                return;
            }
            logger.log(loggingOnLevel, header + "ModPropertySet: ");
            logger.log(loggingOnLevel, mps.getModProperty().toString());
        }
    }

    public static synchronized void log(int debugMode, String header, ModificationItem[] modItem) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel) && modItem != null) {
            if (modItem == null) {
                return;
            }
            for (int i = 0; i < modItem.length; ++i) {
                logger.log(loggingOnLevel, header + "Modification Item " + i + ": " + modItem[i].toString());
            }
        }
    }

    public static synchronized void log(int debugMode, String header, Context ctx) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel)) {
            try {
                logger.log(loggingOnLevel, header + "Display JNDI Context information: ");
                logger.log(loggingOnLevel, header + "Provider URL: " + (String)ctx.getEnvironment().get("java.naming.provider.url"));
                logger.log(loggingOnLevel, header + "Security Principal: " + (String)ctx.getEnvironment().get("java.naming.security.principal"));
            }
            catch (Exception e) {
                logger.log(loggingOnLevel, "Cannot display Conext info: " + ctx);
            }
        }
    }

    public static synchronized void log(int debugMode, String header, Object obj) {
        Logger logger = UtilDebug.getDebugLogger(debugMode);
        if (logger.isLoggable(loggingOnLevel)) {
            if (obj instanceof String) {
                UtilDebug.log(debugMode, header, (String)obj);
            } else if (obj instanceof Exception) {
                UtilDebug.log(debugMode, header, (Exception)obj);
            } else if (obj instanceof ModPropertySet) {
                UtilDebug.log(debugMode, header, (ModPropertySet)obj);
            } else if (obj instanceof PropertySetCollection) {
                UtilDebug.log(debugMode, header, (PropertySetCollection)obj);
            } else if (obj instanceof String[]) {
                UtilDebug.log(debugMode, header, (String[])obj);
            } else if (obj instanceof ModificationItem[]) {
                UtilDebug.log(debugMode, header, (ModificationItem[])obj);
            }
        }
    }

    static {
        Logger logger = Logger.getLogger(parentLogger);
        thisHandler = new LogHandler(new LogFormatter());
        try {
            thisHandler.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException use) {
            m_logger.log(Level.SEVERE, "UTF 8 not supported:", use);
        }
        logger.addHandler(thisHandler);
        threadDebugMode = new InheritableThreadLocal(){

            protected synchronized Object initialValue() {
                Integer mode = Integer.valueOf("0");
                try {
                    mode = Integer.valueOf(System.getProperty("oracle.ldap.util.debug"));
                }
                catch (Exception e) {
                    mode = Integer.valueOf("0");
                }
                return mode;
            }
        };
        pStream = System.out;
        threadPrintStream = new InheritableThreadLocal(){

            protected synchronized Object initialValue() {
                return pStream;
            }
        };
    }
}

