/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ldap.util.ParameterException;

public class TemplateFileInstantiator {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static final String LDAP_ODI_CONF_DIR = "/ldap/odi/conf/";
    private static final String LDAP_LOG_DIR = "/ldap/log/";
    protected String m_fileTemplate = null;
    protected String m_fileToCreate = null;
    protected Hashtable m_replaceMapping = null;

    public TemplateFileInstantiator(String directoryRootPath, String templatefileRelativePath, String templateMapfileName, String fileToCreateRelativePath, String fileNameToCreate, Hashtable replaceMapping) {
        if (null != directoryRootPath && null != templatefileRelativePath && null != templateMapfileName && null != fileToCreateRelativePath && null != fileNameToCreate && null != replaceMapping) {
            this.m_fileTemplate = directoryRootPath + templatefileRelativePath + templateMapfileName;
            this.m_fileToCreate = directoryRootPath + fileToCreateRelativePath + fileNameToCreate;
            this.m_replaceMapping = replaceMapping;
        } else {
            m_logger.log(Level.INFO, "Cannot locate master map file template");
        }
    }

    public TemplateFileInstantiator(String directoryRootPath, String templatefileRelativePath, String templateMapfileName, String fileToCreateRelativePath, String fileNameToCreate, Hashtable replaceMapping, Logger lgr) {
        m_logger = lgr;
        if (null != directoryRootPath && null != templatefileRelativePath && null != templateMapfileName && null != fileToCreateRelativePath && null != fileNameToCreate && null != replaceMapping) {
            this.m_fileTemplate = directoryRootPath + templatefileRelativePath + templateMapfileName;
            this.m_fileToCreate = directoryRootPath + fileToCreateRelativePath + fileNameToCreate;
            this.m_replaceMapping = replaceMapping;
        } else {
            m_logger.log(Level.INFO, "Cannot locate master map file template");
        }
    }

    public String getInstantiatedfileCreated() {
        return this.m_fileToCreate;
    }

    public void CreateInstantiatedfileBasedOnTemplate() throws IOException, FileNotFoundException, ParameterException {
        try {
            int numberPatterns = this.m_replaceMapping.size();
            if (numberPatterns > 0) {
                int i = 0;
                String[] regex = new String[numberPatterns];
                String[] replace = new String[numberPatterns];
                Pattern[] patterns = new Pattern[numberPatterns];
                Enumeration e = this.m_replaceMapping.keys();
                while (e.hasMoreElements()) {
                    regex[i] = (String)e.nextElement();
                    replace[i] = (String)this.m_replaceMapping.get(regex[i]);
                    patterns[i] = Pattern.compile(regex[i]);
                    ++i;
                }
                File fin = new File(this.m_fileTemplate);
                if (!fin.canRead()) {
                    throw new FileNotFoundException(this.m_fileTemplate);
                }
                File fout = new File(this.m_fileToCreate);
                FileInputStream fis = new FileInputStream(fin);
                FileOutputStream fos = new FileOutputStream(fout);
                BufferedReader in_templatFile = new BufferedReader(new InputStreamReader(fis));
                BufferedWriter out_fileToCreate = new BufferedWriter(new OutputStreamWriter(fos));
                String oneLine = null;
                Matcher m = null;
                while ((oneLine = in_templatFile.readLine()) != null) {
                    for (i = 0; i < numberPatterns; ++i) {
                        m = patterns[i].matcher(oneLine);
                        oneLine = m.replaceAll(replace[i]);
                    }
                    out_fileToCreate.write(oneLine);
                    out_fileToCreate.newLine();
                }
                in_templatFile.close();
                out_fileToCreate.close();
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new ParameterException(e.toString());
        }
    }
}

