/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import com.sun.jndi.ldap.LdapName;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ldap.das.util.UILabelsNLS;
import oracle.ldap.util.AccessDeniedException;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.DistinguishedName;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.Group;
import oracle.ldap.util.InvalidSubscriberOrclctxException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.NoSuchGroupException;
import oracle.ldap.util.NoSuchUserException;
import oracle.ldap.util.OracleContext;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.ServiceReference;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

public class Subscriber
extends LDAPEntry
implements Serializable {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String inSubId = null;
    private int subIdType = -1;
    private PropertySetCollection rootOracleContextCommonPsc = null;
    private OracleContext oracleContext = null;
    private String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private String defaultUserGUID = "8da1c26fca6e10cae0340800208d6360";
    private String[] attrList = new String[0];
    private String ohome = null;
    private String[] userSearchBase = null;
    private String userNickNameAttr = null;
    private String userPrincipalAttr = null;
    private String userNameWinAttr = null;
    private boolean autoRegEnabled = false;
    private String[] userCreateBase = null;
    private String userNamingAttr = null;
    private LDIFAttribute userObjCls = null;
    private PropertySetCollection userMandatoryAttrPsc = null;
    private String[] groupSearchBase = null;
    private String[] mGroupCreateBase = null;
    private LDIFAttribute mGroupObjCls = null;
    static final String mGroupNickNameAttr = "cn";
    private boolean validated = false;
    private boolean dnValidated = false;
    private boolean oracleContextValidated = false;
    private String subCreateCommonFilePrefix = "oidSubscriberCreateCommon";
    public static int EXTPROPTYPE_COMMON = 0;
    public static int EXTPROPTYPE_RESOURCE_ACCESS_TYPE = 1;
    public static int EXTPROPTYPE_DEFAULT_RAD = 2;
    static String SIMPLE_PRINCIPAL_ATTR = "orclcommonnicknameattribute";
    static String KERB_PRINCIPAL_ATTR = "orclcommonkrbprincipalattribute";
    static String WIN_PRINCIPAL_ATTR = "orclcommonwindowsprincipalattribute";
    public static final String USER_NAMING_ATTR_SIMPLE = "orclcommonnicknameattribute";
    public static final String USER_NAMING_ATTR_WINDOWS = "orclcommonwindowsprincipalattribute";
    public static final String USER_NAMING_ATTR_KERBEROS = "orclcommonkrbprincipalattribute";
    public static final int ENTRY_PROPERTIES = 0;
    public static final int DETACHED_PROPERTIES = 1;
    public static final int COMMON_PROPERTIES = 2;
    public static final int USER_NAMING_PROPERTIES = 3;
    protected static final int PROPERTY_USER_SEARCH_BASE = 2;
    static final int ATTRLIST_SEARCHBASE_MARK = 4;

    protected Subscriber(DirContext ctx, String inSubDN, Logger lgr) {
        this(ctx, inSubDN);
        m_logger = lgr;
    }

    protected Subscriber(DirContext ctx, String inSubDN) {
        super(ctx, inSubDN);
        this.dnValidated = true;
    }

    protected Subscriber(DirContext ctx, String inSubDN, PropertySet inDnPs, Logger lgr) {
        this(ctx, inSubDN, inDnPs);
        m_logger = lgr;
    }

    protected Subscriber(DirContext ctx, String inSubDN, PropertySet inDnPs) {
        super(ctx, inSubDN, inDnPs);
        this.dnValidated = true;
    }

    public Subscriber(DirContext ctx, int inSubIdType, String inSubIdName, boolean validate, Logger lgr) throws UtilException {
        this(ctx, inSubIdType, inSubIdName, validate);
        m_logger = lgr;
    }

    public Subscriber(DirContext ctx, int inSubIdType, String inSubIdName, boolean validate) throws UtilException {
        this(ctx, inSubIdType, inSubIdName, null, null, new String[0]);
    }

    protected Subscriber(DirContext ctx, int inSubIdType, String inSubIdName, String inOhome, PropertySetCollection rootPsc, String[] inAttrList, Logger lgr) throws UtilException {
        this(ctx, inSubIdType, inSubIdName, inOhome, rootPsc, inAttrList);
        m_logger = lgr;
    }

    protected Subscriber(DirContext ctx, int inSubIdType, String inSubIdName, String inOhome, PropertySetCollection rootPsc, String[] inAttrList) throws UtilException {
        super(ctx, inSubIdName);
        if (ctx == null) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ": DirContext");
        }
        if (inSubIdName == null && inSubIdType == Util.IDTYPE_DN) {
            inSubIdType = Util.IDTYPE_DEFAULT;
        }
        if (inSubIdName == null && inSubIdType != Util.IDTYPE_DEFAULT) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inSubIdName");
        }
        if (inSubIdType != Util.IDTYPE_DN && inSubIdType != Util.IDTYPE_SIMPLE && inSubIdType != Util.IDTYPE_GUID && inSubIdType != Util.IDTYPE_DEFAULT) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inSubIdType");
        }
        if (inSubIdType == Util.IDTYPE_DN && inSubIdName == null) {
            inSubIdType = Util.IDTYPE_DEFAULT;
        }
        this.subIdType = inSubIdType;
        this.inSubId = inSubIdName;
        this.ohome = inOhome;
        this.rootOracleContextCommonPsc = rootPsc;
        this.attrList = inAttrList;
        this.resolve(ctx);
    }

    public PropertySetCollection getProperties(DirContext ctx, String[] attrList) throws UtilException {
        return super.getProperties(ctx, attrList, true);
    }

    public void setProperties(DirContext ctx, ModPropertySet ps) throws UtilException {
        super.setProperties(ctx, ps);
    }

    public void setExtendedProperties(DirContext ctx, int propType, ModPropertySet ps) throws UtilException {
        if (propType == EXTPROPTYPE_COMMON) {
            Util.setEntryDetails(ctx, "cn=common,cn=products,cn=oraclecontext," + this.entryDN, ps);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext ctx, int propType, String[] attrList, String filter) throws UtilException {
        if (!this.oracleContextValidated) {
            this.resolve(ctx);
        }
        try {
            if (propType == EXTPROPTYPE_COMMON) {
                return this.oracleContext.getCommonProperties(ctx, attrList);
            }
            if (propType == EXTPROPTYPE_RESOURCE_ACCESS_TYPE) {
                return Util.getEntryDetails(ctx, "cn=Resource Access Type," + this.commonDN + "," + this.entryDN, filter, 2, attrList);
            }
            if (propType == EXTPROPTYPE_DEFAULT_RAD) {
                PropertySetCollection psc = Util.getEntryDetails(ctx, "cn=Resource Access Descriptor, orclownerguid=" + this.defaultUserGUID + ",cn=Extended Properties,cn=OracleContext," + this.entryDN, filter, 1, attrList);
                if (psc == null) {
                    throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ": Unable to get Default RAD");
                }
                if (psc.isEmpty()) {
                    throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ": Unable to get Default RAD");
                }
                return psc;
            }
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + ":  getExtendedProperties", e);
        }
    }

    public void resolve(DirContext ctx) throws UtilException {
        UtilDebug.log(8, "Subscriber: ", "in Subscriber.resolve(): ");
        if (!this.validated) {
            if (!this.dnValidated) {
                block44: {
                    if ((this.subIdType == Util.IDTYPE_DEFAULT || this.subIdType == Util.IDTYPE_SIMPLE) && this.rootOracleContextCommonPsc == null) {
                        String[] commonAttrList = new String[]{"orclSubscriberSearchBase", "orclSubscriberNickNameAttribute", "orclDefaultSubscriber"};
                        RootOracleContext roc = new RootOracleContext(ctx, m_logger, this.ohome);
                        this.rootOracleContextCommonPsc = roc.getCommonProperties(ctx, commonAttrList);
                    }
                    UtilDebug.log(8, "Subscriber: ", "Root Oracle Context common properties:  ");
                    UtilDebug.log(8, "Subscriber: ", this.rootOracleContextCommonPsc);
                    if (this.subIdType == Util.IDTYPE_DEFAULT) {
                        UtilDebug.log(8, "Subscriber: ", "id type: ID_TYPE_DEFAULT");
                        try {
                            this.entryDN = (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclDefaultSubscriber").getValue(0);
                        }
                        catch (Exception e) {
                            throw new UtilException("Subscriber configuration not found");
                        }
                        try {
                            this.entryPsc = Util.getEntryDetails(ctx, this.entryDN, "objectclass=orclSubscriber", 0, this.attrList);
                            if (this.entryPsc.size() < 1) {
                                throw new UtilException("Subscriber does not exist - DEFAULT = " + this.entryDN);
                            }
                            break block44;
                        }
                        catch (NamingException ne) {
                            UtilDebug.log(8, "Subscriber: ", "NamingException encountered when searching for Default Subscriber DN: " + ne.toString());
                            if (ne instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - DEFAULT = " + this.entryDN);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_SIMPLE) {
                        UtilDebug.log(8, "Subscriber: ", "idtype: IDTYPE_SIMPLE");
                        UtilDebug.log(8, "Subscriber: ", "SIMPLE NAME: " + this.inSubId);
                        String subSearchBase = null;
                        String subNickNameAttribute = null;
                        try {
                            subSearchBase = this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberSearchBase") == null ? "" : (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberSearchBase").getValue(0);
                            UtilDebug.log(8, "Subscriber: ", "Subscriber Search Base=" + subSearchBase);
                            subNickNameAttribute = (String)this.rootOracleContextCommonPsc.getPropertySet(0).getProperty("orclSubscriberNickNameAttribute").getValue(0);
                            UtilDebug.log(8, "Subscriber: ", "Subscriber Nickname Attribute=" + subNickNameAttribute);
                        }
                        catch (Exception e) {
                            throw new UtilException("Subscriber Configuration not found");
                        }
                        try {
                            this.entryPsc = Util.getEntryDetails(ctx, subSearchBase, "(&(objectclass=orclSubscriber)(" + subNickNameAttribute + "=" + this.inSubId + "))", 2, this.attrList);
                            if (this.entryPsc.size() > 1) {
                                throw new UtilException("Multiple Subscribers found with Simple Name = " + this.inSubId);
                            }
                            if (this.entryPsc.size() < 1) {
                                throw new UtilException("Subscriber does not exist - SIMPLE NAME = " + this.inSubId);
                            }
                            this.entryDN = this.entryPsc.getPropertySet(0).getDN();
                            UtilDebug.log(8, "Subscriber: ", "Subscriber DN =" + this.inSubId);
                        }
                        catch (NamingException ne) {
                            UtilDebug.log(8, "Subscriber: ", "NamingException encountered when searching for Subscriber DN: " + ne.toString());
                            if (ne instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - SIMPLE NAME = " + this.inSubId);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_GUID) {
                        UtilDebug.log(8, "Subscriber: ", "idtype: IDTYPE_GUID");
                        UtilDebug.log(8, "Subscriber: ", "GUID: " + this.inSubId);
                        try {
                            this.entryPsc = Util.getEntryDetails(ctx, "", "(&(objectclass=orclSubscriber)(orclGuid=" + this.inSubId + "))", 2, this.attrList);
                            if (this.entryPsc.size() <= 0) {
                                throw new UtilException("Subscriber does not exist - GUID = " + this.entryDN);
                            }
                            this.entryDN = this.entryPsc.getPropertySet(0).getDN();
                        }
                        catch (NamingException ne) {
                            UtilDebug.log(8, "Subscriber: ", "NamingException encountered when searching for Subscriber DN: " + ne.toString());
                            if (ne instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - GUID = " + this.entryDN);
                        }
                    }
                    if (this.subIdType == Util.IDTYPE_DN) {
                        UtilDebug.log(8, "Subscriber: ", "idtype: IDTYPE_DN");
                        UtilDebug.log(8, "Subscriber: ", "DN: " + this.inSubId);
                        this.entryDN = this.inSubId;
                        try {
                            this.entryPsc = Util.getEntryDetails(ctx, this.entryDN, "objectclass=*", 0, this.attrList);
                            if (this.entryPsc.size() < 0) {
                                throw new UtilException("Subscriber does not exist - DN = " + this.entryDN);
                            }
                        }
                        catch (NamingException ne) {
                            if (ne instanceof CommunicationException) {
                                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                            }
                            throw new UtilException("NamingException encountered when resolving subscriber - DN =" + this.entryDN);
                        }
                    }
                }
                this.dnValidated = true;
            }
            UtilDebug.log(8, "Subscriber: ", "Subscriber DN resolved: " + this.entryDN);
            if (!this.oracleContextValidated) {
                this.oracleContext = new OracleContext(ctx, m_logger, this.ohome, "cn=oraclecontext," + this.entryDN);
                String[] attrList = new String[]{"orclcommonusersearchbase", USER_NAMING_ATTR_SIMPLE, "orclcommonnamingattribute", "orclcommongroupsearchbase", "orclcommonautoregenabled", USER_NAMING_ATTR_KERBEROS, USER_NAMING_ATTR_WINDOWS};
                PropertySet ps = null;
                try {
                    ps = this.oracleContext.getCommonProperties(ctx, attrList).getPropertySet(0);
                }
                catch (NullPointerException e) {
                    throw new UtilException("Subscriber's naming is not configured");
                }
                Property sbP = ps.getProperty("orclcommonusersearchbase");
                String[] sbArr = new String[sbP.size()];
                for (int i = 0; i < sbP.size(); ++i) {
                    sbArr[i] = (String)sbP.getValue(i);
                }
                this.userSearchBase = sbArr;
                UtilDebug.log(8, "Subscriber: ", "orclcommonusersearchbase");
                UtilDebug.log(8, "Subscriber: ", this.userSearchBase);
                sbP = ps.getProperty("orclcommongroupsearchbase");
                String[] sbArr1 = new String[sbP.size()];
                for (int i = 0; i < sbP.size(); ++i) {
                    sbArr1[i] = (String)sbP.getValue(i);
                }
                this.groupSearchBase = sbArr1;
                UtilDebug.log(8, "Subscriber: ", "orclcommongroupsearchbase");
                UtilDebug.log(8, "Subscriber: ", this.groupSearchBase);
                try {
                    String autoRegEnabledValue;
                    Property autoRegEnabledProperty = ps.getProperty("orclcommonautoregenabled");
                    this.autoRegEnabled = autoRegEnabledProperty == null ? false : (autoRegEnabledValue = (String)autoRegEnabledProperty.getValue(0)).equals("1");
                    UtilDebug.log(8, "Subscriber: ", "autoRegEnabled: " + this.autoRegEnabled);
                }
                catch (Exception e) {
                    throw new InvalidSubscriberOrclctxException("orclcommonautoregenabled is missing");
                }
                try {
                    this.userNickNameAttr = (String)ps.getProperty(USER_NAMING_ATTR_SIMPLE).getValue(0);
                    UtilDebug.log(8, "Subscriber: ", "orclcommonnicknameattribute: " + this.userNickNameAttr);
                }
                catch (Exception e) {
                    throw new InvalidSubscriberOrclctxException("orclcommonnicknameattribute is missing");
                }
                try {
                    this.userNamingAttr = (String)ps.getProperty("orclcommonnamingattribute").getValue(0);
                    UtilDebug.log(8, "Subscriber: ", "orclcommonnamingattribute: " + this.userNamingAttr);
                }
                catch (Exception e) {
                    int currentVersion = Integer.valueOf(this.oracleContext.getVersion(ctx));
                    if (currentVersion >= 90400) {
                        throw new InvalidSubscriberOrclctxException("orclcommonnamingattribute is missing");
                    }
                    UtilDebug.log(8, "Subscriber: ", "orclcommonnamingattribute=orclcommonnicknameattribute: " + this.userNamingAttr);
                    this.userNamingAttr = this.userNickNameAttr;
                }
                try {
                    this.userPrincipalAttr = (String)ps.getProperty(USER_NAMING_ATTR_KERBEROS).getValue(0);
                }
                catch (Exception e) {
                    this.userPrincipalAttr = this.userNickNameAttr;
                }
                UtilDebug.log(8, "Subscriber: ", "kerbprincipal: " + this.userPrincipalAttr);
                try {
                    this.userNameWinAttr = (String)ps.getProperty(USER_NAMING_ATTR_WINDOWS).getValue(0);
                }
                catch (Exception e) {
                    this.userNameWinAttr = "orclSAMAccountName";
                }
                UtilDebug.log(8, "Subscriber: ", "Windows Naming Attribute: " + this.userNameWinAttr);
                this.oracleContextValidated = true;
            }
        }
        UtilDebug.log(8, "Subscriber: ", "end Subscriber.resolve()");
    }

    public void refresh(DirContext ctx) throws UtilException {
        this.validated = false;
        this.dnValidated = false;
        this.oracleContextValidated = false;
        this.resolve(ctx);
    }

    public String getDN(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        return this.entryDN;
    }

    public String getDn(DirContext ctx) throws UtilException {
        return this.getDN(ctx);
    }

    public User getUser(DirContext ctx, int userIdType, String userIdName, String userSpecifiedSearchBase, String[] attrList, boolean autoProvisioningEnabled) throws UtilException {
        try {
            return this.getUser(ctx, userIdType, userIdName, userSpecifiedSearchBase, attrList);
        }
        catch (UtilException ue) {
            if (autoProvisioningEnabled && this.autoRegEnabled && ue instanceof NoSuchUserException) {
                String newUserDN = null;
                if (userIdType == Util.IDTYPE_DN) {
                    newUserDN = userIdName;
                } else if (userIdType == Util.IDTYPE_SIMPLE) {
                    this.getUserCreationInfo(ctx);
                    newUserDN = this.userNickNameAttr + "=" + userIdName + "," + this.userCreateBase[0];
                }
                User phantomUser = new User(ctx, Util.IDTYPE_DN, newUserDN, 0, null, null, null, null, null, new String[0], true, false);
                return phantomUser;
            }
            throw ue;
        }
    }

    public User getUser(DirContext ctx, int userIdType, String userIdName, String[] attrList) throws UtilException {
        return this.getUser(ctx, userIdType, userIdName, null, attrList);
    }

    public User getUser(DirContext ctx, int userIdType, String userIdName, String userSpecifiedSearchBase, String[] attrList) throws UtilException {
        this.resolve(ctx);
        if (userIdType == Util.IDTYPE_SIMPLE || userIdType == Util.IDTYPE_FILTER || userIdType == Util.IDTYPE_WINDOWS || userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
            String[] newAttrList = null;
            if (attrList != null) {
                int arrSize = attrList.length + 4;
                newAttrList = new String[arrSize];
                for (int i = 0; i < attrList.length; ++i) {
                    newAttrList[i] = attrList[i];
                }
                newAttrList[attrList.length] = "orclguid";
                newAttrList[attrList.length + 1] = this.userNickNameAttr;
                newAttrList[attrList.length + 2] = this.userPrincipalAttr;
                newAttrList[attrList.length + 3] = this.userNameWinAttr;
            }
            return (User)this.getUser_NICKNAME(ctx, userIdType, userIdName, userSpecifiedSearchBase, newAttrList, true, null);
        }
        if (userIdType == Util.IDTYPE_DN) {
            return this.getUser_DN(ctx, userIdName, attrList);
        }
        if (userIdType == Util.IDTYPE_GUID) {
            return this.getUser_GUID(ctx, userIdName, attrList);
        }
        throw new UtilException("Invalid Parameters");
    }

    public User[] getUsers(DirContext ctx, int filterIdType, String filter, String userSpecifiedSearchBase, String[] attrList) throws UtilException {
        return this.getUsers(ctx, filterIdType, filter, userSpecifiedSearchBase, attrList, null);
    }

    public User[] getUsers(DirContext ctx, int filterIdType, String filter, String userSpecifiedSearchBase, String[] attrList, SearchControls inSctrl) throws UtilException {
        this.resolve(ctx);
        SearchControls sctrl = null;
        if (inSctrl != null) {
            sctrl = new SearchControls();
            sctrl.setSearchScope(2);
            sctrl.setCountLimit(inSctrl.getCountLimit());
            sctrl.setTimeLimit(inSctrl.getTimeLimit());
        }
        String[] newAttrList = null;
        if (attrList != null) {
            int arrSize = attrList.length + 4;
            newAttrList = new String[arrSize];
            for (int i = 0; i < attrList.length; ++i) {
                newAttrList[i] = attrList[i];
            }
            newAttrList[attrList.length] = "orclguid";
            newAttrList[attrList.length + 1] = this.userNickNameAttr;
            newAttrList[attrList.length + 2] = this.userPrincipalAttr;
            newAttrList[attrList.length + 3] = this.userNameWinAttr;
        }
        if (sctrl != null) {
            sctrl.setReturningAttributes(newAttrList);
        }
        if (filterIdType == Util.IDTYPE_SIMPLE || filterIdType == Util.IDTYPE_FILTER) {
            return (User[])this.getUser_NICKNAME(ctx, filterIdType, filter, userSpecifiedSearchBase, newAttrList, false, sctrl);
        }
        throw new ParameterException("Invalid userIdType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getUser_NICKNAME(DirContext ctx, int userIdType, String userIdName, String userSpecifiedSearchBase, String[] attrList, boolean returnONE, SearchControls ctrls) throws UtilException {
        if (userSpecifiedSearchBase != null) {
            boolean found = false;
            for (int i = 0; i < this.userSearchBase.length; ++i) {
                String curSearchBase = Util.normalizeDN(this.userSearchBase[i]);
                if (!curSearchBase.equals(Util.normalizeDN(userSpecifiedSearchBase))) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new UtilException("Invalid user search base");
            }
            this.userSearchBase = new String[1];
            this.userSearchBase[0] = userSpecifiedSearchBase;
        }
        String filter = null;
        if (userIdType == Util.IDTYPE_SIMPLE) {
            filter = returnONE ? "(" + this.userNickNameAttr + "=" + Util.handleSpecialFilterChars(userIdName) + ")" : "(" + this.userNickNameAttr + "=" + userIdName + ")";
        } else if (userIdType == Util.IDTYPE_FILTER) {
            filter = "(&(" + userIdName + ")(objectclass=organizationalperson))";
        } else if (userIdType == Util.IDTYPE_WINDOWS) {
            if (this.userNameWinAttr == null) throw new UtilException("orclcommonwindowsprincipalattribute is not defined in this realm");
            filter = "(" + this.userNameWinAttr + "=" + Util.handleSpecialFilterChars(userIdName) + ")";
        } else if (userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
            if (this.userPrincipalAttr == null) throw new UtilException("orclcommonkrbprincipalattribute is not defined in this realm");
            filter = "(" + this.userPrincipalAttr + "=" + Util.handleSpecialFilterChars(userIdName) + ")";
        }
        boolean oneFound = false;
        Vector<User> userVector = null;
        if (!returnONE) {
            userVector = new Vector<User>();
        }
        User onlyOneUser = null;
        boolean doingSecondSearchForNT = false;
        do {
            for (int i = 0; i < this.userSearchBase.length; ++i) {
                try {
                    String baseDN = this.userSearchBase[i];
                    NamingEnumeration curEnum = (NamingEnumeration)(ctrls == null ? Util.getEntryDetails(ctx, baseDN, filter, 2, attrList, false) : Util.getEntryDetails(ctx, baseDN, filter, ctrls));
                    boolean hasMore = curEnum.hasMore();
                    if (!hasMore && i == this.userSearchBase.length - 1 && returnONE && !oneFound) {
                        if (userIdType != Util.IDTYPE_WINDOWS || doingSecondSearchForNT) throw new NoSuchUserException("User does not exist - SIMPLE NAME = " + userIdName);
                        doingSecondSearchForNT = true;
                        continue;
                    }
                    while (hasMore) {
                        if (returnONE && oneFound) {
                            throw new UtilException("Multiple Users found with Simple Name = " + userIdName);
                        }
                        SearchResult sr = (SearchResult)curEnum.nextElement();
                        String entryDN = null;
                        String entryGUID = null;
                        entryDN = new String(sr.getNameInNamespace());
                        if (attrList != null) {
                            entryGUID = (String)sr.getAttributes().get("orclguid").get(0);
                        }
                        onlyOneUser = new User(ctx, entryDN, entryGUID, this.userSearchBase[i], this, sr);
                        if (!returnONE) {
                            userVector.addElement(onlyOneUser);
                        } else {
                            oneFound = true;
                            doingSecondSearchForNT = false;
                        }
                        hasMore = curEnum.hasMore();
                    }
                    continue;
                }
                catch (NamingException ne) {
                    if (!(ne instanceof CommunicationException)) throw new UtilException("NamingException encountered when resolving user - SIMPLE NAME = " + userIdName, ne);
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                }
            }
        } while (doingSecondSearchForNT);
        if (returnONE) {
            return onlyOneUser;
        }
        int arrSize = userVector.size();
        User[] userArr = new User[arrSize];
        for (int i = 0; i < arrSize; ++i) {
            userArr[i] = (User)userVector.elementAt(i);
        }
        return userArr;
    }

    private User getUser_GUID(DirContext ctx, String userIdName, String[] attrList) throws UtilException {
        try {
            NamingEnumeration curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "", "(orclguid=" + userIdName + ")", 2, attrList, false);
            if (!curEnum.hasMoreElements()) {
                throw new NoSuchUserException("User does not exist - GUID = " + userIdName);
            }
            SearchResult sr = (SearchResult)curEnum.nextElement();
            String entryDN = new String(sr.getName());
            String entryGUID = userIdName;
            return new User(ctx, entryDN, entryGUID, "", this, sr);
        }
        catch (NameNotFoundException nfe) {
            throw new NoSuchUserException("User does not exist - GUID = " + userIdName, nfe);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered when resolving user - GUID = " + userIdName, ne);
        }
    }

    private User getUser_DN(DirContext ctx, String userIdName, String[] attrList) throws UtilException {
        String[] newAttrList = null;
        if (attrList != null) {
            int arrSize = attrList.length + 4;
            newAttrList = new String[arrSize];
            for (int i = 0; i < attrList.length; ++i) {
                newAttrList[i] = attrList[i];
            }
            newAttrList[attrList.length] = "orclguid";
            newAttrList[attrList.length + 1] = this.userNickNameAttr;
            newAttrList[attrList.length + 2] = this.userPrincipalAttr;
            newAttrList[attrList.length + 3] = this.userNameWinAttr;
        }
        try {
            NamingEnumeration curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, userIdName, "(objectclass=*)", 0, newAttrList, false);
            if (!curEnum.hasMoreElements()) {
                throw new NoSuchUserException("User does not exist - DN = " + userIdName);
            }
            SearchResult sr = (SearchResult)curEnum.nextElement();
            String entryGUID = null;
            String entryDN = userIdName;
            NamingEnumeration curEnum1 = null;
            try {
                entryGUID = (String)sr.getAttributes().get("orclguid").get(0);
            }
            catch (Exception e) {
                curEnum1 = (NamingEnumeration)Util.getEntryDetails(ctx, userIdName, "(objectclass=*)", 0, new String[]{"orclguid"}, false);
                SearchResult sr1 = (SearchResult)curEnum1.nextElement();
                entryGUID = (String)sr1.getAttributes().get("orclguid").get(0);
            }
            return new User(ctx, entryDN, entryGUID, entryDN, this, sr);
        }
        catch (NameNotFoundException nfe) {
            throw new NoSuchUserException("User does not exist - DN = " + userIdName, nfe);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered when resolving user - DN = " + userIdName, ne);
        }
    }

    public ServiceReference[] getAllServiceReferences(DirContext ctx) throws UtilException {
        return this.getAllServiceReferences(ctx, new String[]{"dn"});
    }

    public ServiceReference[] getAllServiceReferences(DirContext ctx, String[] attrList) throws UtilException {
        try {
            this.resolve(ctx);
            PropertySetCollection psc = Util.getEntryDetails(ctx, "cn=Services,cn=OracleContext," + this.entryDN, "(objectclass=orclServiceInstanceReference)", 2, attrList);
            ServiceReference[] svcArr = new ServiceReference[psc.size()];
            for (int i = 0; i < svcArr.length; ++i) {
                PropertySet curPropSet = psc.getPropertySet(i);
                svcArr[i] = new ServiceReference(ctx, curPropSet.getDN(), curPropSet);
            }
            return svcArr;
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException(ne.toString());
        }
    }

    public User createUser(DirContext ctx, ModPropertySet ps, boolean useMandatoryObjectclasses) throws UtilException {
        this.resolve(ctx);
        this.getUserCreationInfo(ctx);
        if (this.userCreateBase.length > 1) {
            throw new UtilException("multiple create user base");
        }
        return this.createUser(ctx, this.userCreateBase[0], ps, useMandatoryObjectclasses);
    }

    public User createUser(DirContext ctx, String createUserBase, ModPropertySet ps, boolean useMandatoryObjectclasses) throws UtilException {
        return this.createUser(ctx, createUserBase, null, ps, useMandatoryObjectclasses, false);
    }

    public User createUser(DirContext ctx, String newUserDN, ModPropertySet ps, boolean useMandatoryObjectclasses, boolean validateDN) throws UtilException {
        return this.createUser(ctx, null, newUserDN, ps, useMandatoryObjectclasses, validateDN);
    }

    private User createUser(DirContext ctx, String createUserBase, String newUserDN, ModPropertySet ps, boolean useMandatoryObjectclasses, boolean validateDN) throws UtilException {
        if (ps == null) {
            throw new ParameterException("Invalid Parameters");
        }
        this.resolve(ctx);
        this.getUserCreationInfo(ctx);
        boolean useDN = newUserDN != null;
        boolean found = false;
        if (!useDN) {
            if (createUserBase != null) {
                for (int i = 0; i < this.userCreateBase.length; ++i) {
                    String curCreateBase = Util.normalizeDN(this.userCreateBase[i]);
                    if (!curCreateBase.equals(Util.normalizeDN(createUserBase))) continue;
                    found = true;
                    break;
                }
            } else {
                if (this.userCreateBase.length > 1) {
                    throw new UtilException("More than one user create base.  A create base must be specified");
                }
                createUserBase = this.userCreateBase[0];
                found = true;
            }
            if (!found) {
                throw new UtilException("Invalid create user base");
            }
        }
        String userDN = null;
        if (useDN) {
            userDN = newUserDN;
            if (validateDN) {
                boolean foundMatchingSearchBase = false;
                DistinguishedName userDistinguishedName = null;
                try {
                    userDistinguishedName = new DistinguishedName(userDN);
                }
                catch (InvalidNameException ie) {
                    throw new UtilException("Cannot create user due to invalid user DN: " + userDN);
                }
                for (int i = 0; i < this.userSearchBase.length; ++i) {
                    DistinguishedName curSearchBaseDN = null;
                    try {
                        curSearchBaseDN = new DistinguishedName(this.userSearchBase[i]);
                    }
                    catch (InvalidNameException ie) {
                        throw new UtilException("Cannot create user due to invalid user search base: " + this.userSearchBase[i]);
                    }
                    if (!userDistinguishedName.startsWith(curSearchBaseDN)) continue;
                    foundMatchingSearchBase = true;
                    break;
                }
                if (!foundMatchingSearchBase) {
                    throw new UtilException("New userdDN does not fall within any search base: " + userDN);
                }
            }
        } else {
            LDIFRecord lrec = ps.getModProperty();
            String namingValue = lrec.getAttribute(this.userNamingAttr).getValue();
            String escapedNamingValue = LdapName.escapeAttributeValue(namingValue);
            userDN = new String(this.userNamingAttr + "=" + escapedNamingValue + "," + createUserBase);
        }
        if (useMandatoryObjectclasses) {
            String[] objectclassVals = ps.getModPropertyValues("objectclass");
            if (objectclassVals == null) {
                ps.addProperty(5, this.userObjCls);
            } else {
                ArrayList<String> valueList = new ArrayList<String>(objectclassVals.length);
                for (int i = 0; i < objectclassVals.length; ++i) {
                    valueList.add(objectclassVals[i].toLowerCase());
                }
                String[] dasObjectclassesArr = this.userObjCls.getStringValueArray();
                for (int i = 0; i < dasObjectclassesArr.length; ++i) {
                    String curObjectClass = dasObjectclassesArr[i].toLowerCase();
                    if (valueList.contains(curObjectClass)) continue;
                    valueList.add(curObjectClass);
                }
                ps.deleteProperty("objectclass");
                ps.addProperty(5, "objectclass", valueList.toArray(new String[0]));
            }
        }
        Util.ldapAdd(ctx, userDN, ps);
        User newUser = this.getUser(ctx, Util.IDTYPE_DN, userDN, null, new String[0]);
        String newUserGUID = newUser.getGUID(ctx);
        String curDN = new String("orclownerguid=" + newUserGUID + ",cn=Extended Properties,cn=OracleContext," + this.entryDN);
        ModPropertySet mp = new ModPropertySet();
        String[] refObjList = new String[]{"top", "orclreferenceobject"};
        mp.addProperty(0, "objectclass", refObjList);
        mp.addProperty(0, "orclownerguid", newUserGUID);
        mp.addProperty(0, "seealso", userDN);
        Util.ldapAdd(ctx, curDN, mp);
        curDN = "cn=Resource Access Descriptor," + curDN;
        mp = new ModPropertySet();
        String[] radObjList = new String[]{"top", "orclcontainer", "orclauxiliaryguid"};
        mp.addProperty(0, "objectclass", radObjList);
        mp.addProperty(0, mGroupNickNameAttr, "Resource Access Descriptor");
        mp.addProperty(0, "orclownerguid", newUserGUID);
        Util.ldapAdd(ctx, curDN, mp);
        return newUser;
    }

    private void userAttrCheck(ModPropertySet ps) throws UtilException {
        LDIFRecord lrec = ps.getModProperty();
        for (int i = 0; i < this.userMandatoryAttrPsc.size(); ++i) {
            String curAttr;
            Property curP;
            PropertySet curPs = this.userMandatoryAttrPsc.getPropertySet(i);
            if (curPs.size() == 0 || (curP = curPs.getProperty("orcldasismandatory")) == null || !((String)curP.getValue(0)).equals("1") || lrec.contains(curAttr = Util.getAttrValueOfRDN(Util.getRDN(curPs.getDN())))) continue;
            throw new UtilException("Mandatory Attribute missing for User Creation:  " + curAttr);
        }
        if (!lrec.contains(this.userNamingAttr)) {
            throw new UtilException("User Naming Attribute missing for User Creation:  " + this.userNamingAttr);
        }
        if (!lrec.contains(this.userNickNameAttr)) {
            throw new UtilException("User NickName Attribute missing for User Creation:  " + this.userNickNameAttr);
        }
    }

    private void getUserCreationInfo(DirContext ctx) throws UtilException {
        String[] tmpAttrList;
        if (this.userMandatoryAttrPsc == null) {
            tmpAttrList = new String[]{"orcldasismandatory"};
            this.userMandatoryAttrPsc = Util.ldapSearch(ctx, "cn=Attributes,cn=User Configuration,cn=Attribute Configuration, cn=DAS,cn=Products,cn=OracleContext," + this.entryDN, "(objectclass=*)", 1, tmpAttrList);
        }
        if (this.userCreateBase == null) {
            tmpAttrList = new String[]{"orclcommonusercreatebase", "orclcommonnamingattribute", "orcluserobjectclasses"};
            PropertySet ps = this.oracleContext.getCommonProperties(ctx, tmpAttrList).getPropertySet(0);
            int currentVersion = Integer.valueOf(this.oracleContext.getVersion(ctx));
            if (currentVersion >= 90400) {
                Property cbP = ps.getProperty("orclcommonusercreatebase");
                String[] cbArr = new String[cbP.size()];
                for (int i = 0; i < cbP.size(); ++i) {
                    cbArr[i] = (String)cbP.getValue(i);
                }
                this.userCreateBase = cbArr;
                this.userNamingAttr = (String)ps.getProperty("orclcommonnamingattribute").getValue(0);
            } else {
                this.userCreateBase = this.userSearchBase;
                this.userNamingAttr = this.userNickNameAttr;
            }
            this.userObjCls = new LDIFAttribute("objectclass");
            Property ocP = ps.getProperty("orcluserobjectclasses");
            for (int i = 0; i < ocP.size(); ++i) {
                this.userObjCls.addValue((String)ocP.getValue(i));
            }
        }
    }

    public void deleteUser(DirContext ctx, User inUser) throws UtilException {
        block3: {
            this.resolve(ctx);
            String userGuid = inUser.getGUID(ctx);
            String extPrefsDN = "orclownerguid=" + userGuid + ",cn=Extended Properties,cn=oracleContext," + this.entryDN;
            try {
                Util.bulkDelete(ctx, extPrefsDN, true);
            }
            catch (NamingException ne) {
                if (ne instanceof CommunicationException) {
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                }
                if (!(ne instanceof NoPermissionException)) break block3;
                throw new AccessDeniedException("Access Denied while removing extended preference of this user.", ne);
            }
        }
        Group[] grps = inUser.getGroupMembership(ctx, new String[0], false);
        Util.removeUniquemember(ctx, grps, inUser.getDN(ctx));
        Util.ldapDelete(ctx, inUser.getDN(ctx));
    }

    public void deleteGroup(DirContext ctx, Group inGroup) throws UtilException {
        this.resolve(ctx);
        Util.ldapDelete(ctx, inGroup.getDN(ctx));
    }

    public Group createGroup(DirContext ctx, String createGroupBase, ModPropertySet ps, boolean useMandatoryObjectclasses) throws UtilException {
        return this.createGroup(ctx, createGroupBase, null, ps, useMandatoryObjectclasses, false);
    }

    private Group createGroup(DirContext ctx, String createGroupBase, String newGroupDN, ModPropertySet ps, boolean useMandatoryObjectclasses, boolean validateDN) throws UtilException {
        String[] uniqueMembers;
        UtilDebug.log(8, "Subscriber:", "start createGroup");
        if (ps == null) {
            throw new ParameterException("Invalid Parameters");
        }
        this.resolve(ctx);
        this.getGroupCreationInfo(ctx);
        boolean useDN = newGroupDN != null;
        boolean found = false;
        if (!useDN) {
            if (createGroupBase != null) {
                for (int i = 0; i < this.mGroupCreateBase.length; ++i) {
                    String curCreateBase = Util.normalizeDN(this.mGroupCreateBase[i]);
                    if (!curCreateBase.equals(Util.normalizeDN(createGroupBase))) continue;
                    found = true;
                    break;
                }
            } else {
                if (this.mGroupCreateBase.length > 1) {
                    throw new UtilException("More than one group create base.A create base must be specified");
                }
                createGroupBase = this.mGroupCreateBase[0];
                found = true;
            }
            if (!found) {
                throw new UtilException("Invalid create group base");
            }
        }
        String groupDN = null;
        if (useDN) {
            groupDN = newGroupDN;
            if (validateDN) {
                boolean foundMatchingSearchBase = false;
                DistinguishedName groupDistinguishedName = null;
                try {
                    groupDistinguishedName = new DistinguishedName(groupDN);
                }
                catch (InvalidNameException ie) {
                    throw new UtilException("Cannot create group due to invalidgroup DN: " + groupDN);
                }
                for (int i = 0; i < this.groupSearchBase.length; ++i) {
                    DistinguishedName curSearchBaseDN = null;
                    try {
                        curSearchBaseDN = new DistinguishedName(this.groupSearchBase[i]);
                    }
                    catch (InvalidNameException ie) {
                        throw new UtilException("Cannot create group due to invalid group search base: " + this.groupSearchBase[i]);
                    }
                    if (!groupDistinguishedName.startsWith(curSearchBaseDN)) continue;
                    foundMatchingSearchBase = true;
                    break;
                }
                if (!foundMatchingSearchBase) {
                    throw new UtilException("New groupdDN does not fall within any search base: " + groupDN);
                }
            }
        } else {
            LDIFRecord lrec = ps.getModProperty();
            String namingValue = lrec.getAttribute(mGroupNickNameAttr).getValue();
            if (namingValue == null) {
                throw new UtilException("Value of Mandatory attributecn is missing");
            }
            String escapedNamingValue = LdapName.escapeAttributeValue(namingValue);
            groupDN = new String("cn=" + escapedNamingValue + "," + createGroupBase);
            UtilDebug.log(8, "Subscriber:", "group dn: " + groupDN);
        }
        if (useMandatoryObjectclasses) {
            String[] objectclassVals = ps.getModPropertyValues("objectclass");
            if (objectclassVals == null) {
                ps.addProperty(5, this.mGroupObjCls);
            } else {
                ArrayList<String> valueList = new ArrayList<String>(objectclassVals.length);
                for (int i = 0; i < objectclassVals.length; ++i) {
                    valueList.add(objectclassVals[i].toLowerCase());
                }
                String[] manObjectclassesArr = this.mGroupObjCls.getStringValueArray();
                for (int i = 0; i < manObjectclassesArr.length; ++i) {
                    String curObjectClass = manObjectclassesArr[i].toLowerCase();
                    if (valueList.contains(curObjectClass)) continue;
                    valueList.add(curObjectClass);
                }
                ps.deleteProperty("objectclass");
                ps.addProperty(5, "objectclass", valueList.toArray(new String[0]));
            }
        }
        if ((uniqueMembers = ps.getModPropertyValues("uniquemember")) != null) {
            ArrayList<String> newMembers = new ArrayList<String>();
            for (int i = 0; i < uniqueMembers.length; ++i) {
                if (Util.dnExists(ctx, uniqueMembers[i])) {
                    newMembers.add(uniqueMembers[i]);
                    continue;
                }
                UtilDebug.log(8, "Subscriber:", "ignoring invalid member " + uniqueMembers[i]);
            }
            ps.deleteProperty("uniquemember");
            if (!newMembers.isEmpty()) {
                ps.addProperty(5, "uniquemember", newMembers.toArray(new String[0]));
            }
        }
        Util.ldapAdd(ctx, groupDN, ps);
        UtilDebug.log(8, "Subscriber:", "successfully created group with dn: " + groupDN);
        Group newGroup = this.getGroup(ctx, Util.IDTYPE_DN, groupDN, null, new String[0]);
        return newGroup;
    }

    private void getGroupCreationInfo(DirContext ctx) throws UtilException {
        if (this.mGroupCreateBase == null) {
            String[] tmpAttrList = new String[]{"orclcommongroupcreatebase"};
            PropertySet ps = this.oracleContext.getCommonProperties(ctx, tmpAttrList).getPropertySet(0);
            int currentVersion = Integer.valueOf(this.oracleContext.getVersion(ctx));
            if (currentVersion >= 90400) {
                Property cbP = ps.getProperty("orclcommongroupcreatebase");
                String[] cbArr = new String[cbP.size()];
                for (int i = 0; i < cbP.size(); ++i) {
                    cbArr[i] = (String)cbP.getValue(i);
                }
                this.mGroupCreateBase = cbArr;
            } else {
                this.mGroupCreateBase = this.groupSearchBase;
            }
            this.mGroupObjCls = new LDIFAttribute("objectclass");
            this.mGroupObjCls.addValue("top");
            this.mGroupObjCls.addValue("groupOfUniqueNames");
            this.mGroupObjCls.addValue("orclGroup");
        }
    }

    public Group getGroup(DirContext ctx, int groupIdType, String groupIdName, String[] attrList) throws UtilException {
        return this.getGroup(ctx, groupIdType, groupIdName, null, attrList);
    }

    public Group getGroup(DirContext ctx, int groupIdType, String groupIdName, String specifiedSearchBase, String[] attrList) throws UtilException {
        PropertySetCollection psc;
        String[] newAttrList = null;
        if (groupIdType == Util.IDTYPE_DN || groupIdType == Util.IDTYPE_SIMPLE) {
            if (attrList != null) {
                int i;
                boolean addGuid = true;
                for (i = 0; i < attrList.length; ++i) {
                    if (!attrList[i].equalsIgnoreCase("orclguid")) continue;
                    addGuid = false;
                }
                if (addGuid) {
                    newAttrList = new String[attrList.length + 1];
                    for (i = 0; i < attrList.length; ++i) {
                        newAttrList[i] = attrList[i];
                    }
                    newAttrList[attrList.length] = "orclguid";
                } else {
                    newAttrList = attrList;
                }
            } else {
                newAttrList = new String[]{"*", "orclguid"};
            }
        }
        this.resolve(ctx);
        if (groupIdType == Util.IDTYPE_DN) {
            psc = Util.dnExists(ctx, groupIdName, newAttrList);
            if (psc != null) {
                String grpGuid = psc.getPropertySet(0).getProperty("orclguid").getValue(0).toString();
                Group grp = new Group(ctx, groupIdName, grpGuid, psc.getPropertySet(0));
                return grp;
            }
        } else if (groupIdType == Util.IDTYPE_GUID) {
            psc = Util.ldapSearch(ctx, "", "(orclGUID=" + groupIdName + ")", 2, attrList);
            if (psc != null && !psc.isEmpty()) {
                Group grp = new Group(ctx, psc.getPropertySet(0).getDN(), groupIdName, psc.getPropertySet(0));
                return grp;
            }
        } else if (groupIdType == Util.IDTYPE_SIMPLE) {
            psc = Util.multiSearchBaseSearch(ctx, specifiedSearchBase, this.groupSearchBase, "(cn=" + Util.handleSpecialChars(groupIdName) + ")", newAttrList, true);
            if (psc != null && !psc.isEmpty()) {
                String grpGuid = psc.getPropertySet(0).getProperty("orclguid").getValue(0).toString();
                Group grp = new Group(ctx, psc.getPropertySet(0).getDN(), grpGuid, psc.getPropertySet(0));
                return grp;
            }
        } else {
            throw new ParameterException("Invalid groupIdType");
        }
        String attrName = groupIdType == Util.IDTYPE_DN ? "DN" : "GUID";
        throw new NoSuchGroupException("There is no group with " + attrName + ":" + groupIdName);
    }

    public Group[] getGroups(DirContext ctx, int filterIdType, String filter, String specifiedSearchBase, String[] attrList) throws UtilException {
        PropertySetCollection psc = null;
        if (filterIdType == Util.IDTYPE_SIMPLE) {
            psc = Util.multiSearchBaseSearch(ctx, specifiedSearchBase, this.groupSearchBase, "(cn=" + filter + ")", attrList, false);
        } else if (filterIdType == Util.IDTYPE_FILTER) {
            psc = Util.multiSearchBaseSearch(ctx, null, this.groupSearchBase, filter, attrList, false);
        } else {
            throw new ParameterException("Invalid groupIdType");
        }
        if (psc != null) {
            int numGrps = psc.size();
            Group[] grpArr = new Group[numGrps];
            for (int i = 0; i < numGrps; ++i) {
                grpArr[i] = new Group(ctx, psc.getPropertySet(i).getDN(), psc.getPropertySet(i));
            }
            return grpArr;
        }
        return null;
    }

    public String getPwdVerifierAttributeName(DirContext ctx, int verifierType) throws UtilException {
        if (verifierType == Util.PWD_VERIFIERTYPE_COMMON) {
            return "orclpasswordverifier;orclcommongroupverifier";
        }
        throw new ParameterException("Invalid verifierType");
    }

    public String getPwdVerifierAttributeName(DirContext ctx, String appID) throws UtilException {
        PropertySetCollection psc = Util.ldapSearch(ctx, "cn=common,cn=products,cn=oraclecontext", "objectclass=orclcommonverifierprofile", 2, new String[]{"orclappid"});
        boolean found = false;
        for (int i = 0; i < psc.size(); ++i) {
            try {
                String curAppID = (String)psc.getPropertySet(i).getProperty("orclappid").getValue(0);
                if (!curAppID.equalsIgnoreCase(appID)) continue;
                return "orclpasswordverifier;" + appID;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public void upgrade(DirContext ctx, String oHome, PrintStream pStream) throws Exception {
        this.ohome = oHome;
        String subOracleContextDN = "cn=OracleContext," + this.entryDN;
        OracleContext orclctx = new OracleContext(ctx, m_logger, oHome, subOracleContextDN, pStream);
        orclctx.upgrade(ctx);
        String fileSeparator = System.getProperty("file.separator");
        while (!this.isUpToDate(ctx, pStream)) {
            String curVersion = this.getVersion(ctx);
            m_logger.log(Level.INFO, "Realm curVersion: " + curVersion);
            String curUpgradeFromLst = this.ohome + fileSeparator + "ldap" + fileSeparator + "schema" + fileSeparator + "oid" + fileSeparator + this.subCreateCommonFilePrefix + "UpgradeFrom" + curVersion + ".lst";
            Vector subVector = this.getSubstitutionVector();
            Util.ldapModify(ctx, m_logger, curUpgradeFromLst, subVector, false, pStream);
        }
        UILabelsNLS.upgradeNLSLabels(ctx, this.entryDN);
    }

    private Vector getSubstitutionVector() {
        Vector<String> subVector = new Vector<String>(10);
        subVector.insertElementAt("s_SubscriberParentDN", 0);
        subVector.insertElementAt(Util.getParentDN(this.entryDN), 1);
        subVector.insertElementAt("s_SubscriberDN", 2);
        subVector.insertElementAt(this.entryDN, 3);
        subVector.insertElementAt("s_RootOracleContextDN", 4);
        subVector.insertElementAt("cn=OracleContext", 5);
        subVector.insertElementAt("s_OracleContextDN", 6);
        subVector.insertElementAt("cn=OracleContext," + this.entryDN, 7);
        subVector.insertElementAt("s_OracleContextParentDN", 8);
        subVector.insertElementAt(this.entryDN, 9);
        return subVector;
    }

    public String getVersion(DirContext ctx) throws UtilException {
        String curVersion = null;
        PropertySetCollection psc = this.getProperties(ctx, new String[]{"orclversion"});
        try {
            curVersion = ((String)psc.getPropertySet(0).getProperty("orclversion").getValue(0)).trim();
        }
        catch (NullPointerException ne) {
            if (!Util.dnExists(ctx, "cn=Calendar Server," + this.entryDN)) {
                return "90100";
            }
            return "90110";
        }
        return curVersion;
    }

    public boolean isUpToDate(DirContext ctx, PrintStream pStream) {
        try {
            String fileSeparator = System.getProperty("file.separator");
            String version = this.getVersion(ctx).trim();
            String versionFileName = this.ohome + fileSeparator + "ldap" + fileSeparator + "schema" + fileSeparator + "versions.txt";
            m_logger.log(Level.INFO, versionFileName);
            String upToDateVersion = Util.getParameterFromFile("RealmVersion", versionFileName).trim();
            m_logger.log(Level.INFO, "Realm version: " + version + " up_version: " + upToDateVersion);
            int upToDateVersionInt = Integer.valueOf(upToDateVersion);
            int versionInt = Integer.valueOf(version);
            return versionInt >= upToDateVersionInt;
        }
        catch (Exception ie) {
            m_logger.log(Level.SEVERE, "Exception occurred", ie);
            return true;
        }
    }

    public PropertySetCollection getProperties(DirContext ctx, int propType, String[] attrList) throws UtilException {
        this.resolve(ctx);
        switch (propType) {
            case 3: {
                String[] newAttrList = attrList == null ? new String[]{USER_NAMING_ATTR_SIMPLE, USER_NAMING_ATTR_WINDOWS, USER_NAMING_ATTR_KERBEROS} : attrList;
                PropertySetCollection psc = this.oracleContext.getCommonProperties(ctx, newAttrList);
                return psc;
            }
            case 2: {
                return this.oracleContext.getCommonProperties(ctx, attrList);
            }
            case 0: {
                return this.getProperties(ctx, attrList);
            }
        }
        throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + propType);
    }

    protected String[] getCommonAttrs(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        String[] commonAttrs = new String[4 + this.userSearchBase.length];
        commonAttrs[0] = this.userNickNameAttr;
        commonAttrs[1] = this.userNamingAttr;
        commonAttrs[2] = this.userPrincipalAttr;
        commonAttrs[3] = this.userNameWinAttr;
        int j = 4;
        for (int i = 0; i < this.userSearchBase.length; ++i) {
            commonAttrs[j++] = this.userSearchBase[i];
        }
        return commonAttrs;
    }

    public String[] getUserSearchBase() {
        return this.userSearchBase;
    }

    public String[] getGroupSearchBase() {
        if (this.groupSearchBase != null) {
            return this.groupSearchBase;
        }
        return new String[0];
    }
}

