/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import oracle.ldap.util.Guid;

public final class OrclGuid
implements Cloneable {
    private Guid _guid = null;

    public static OrclGuid newInstance() {
        return new OrclGuid();
    }

    public OrclGuid() {
        this._guid = new Guid();
    }

    public OrclGuid(String string_guid) {
        if (string_guid.length() == 35) {
            this._guid = new Guid(string_guid);
        } else if (string_guid.length() == 32) {
            this._guid = new Guid(OrclGuid.expandGuidString(string_guid));
        }
    }

    public OrclGuid(byte[] byte_array) {
        this._guid = new Guid(byte_array);
    }

    public byte[] getBytes() {
        if (this._guid != null) {
            return this._guid.getBytes();
        }
        return null;
    }

    public final String toString() {
        if (this._guid != null) {
            return OrclGuid.compactGuidString(this._guid.toString());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this._guid != null) {
            return this._guid.hashCode();
        }
        return 0;
    }

    public Object clone() {
        OrclGuid new_guid = new OrclGuid(this.getBytes());
        return new_guid;
    }

    public static String compactGuidString(String s) {
        if (s != null && s.length() == 35) {
            return s.substring(0, 12) + s.substring(13, 17) + s.substring(18, 22) + s.substring(23, 35);
        }
        if (s != null && s.length() == 32) {
            return s;
        }
        return "oracle.ldap.util.OrclGuid: Invalid GUID String";
    }

    public static String expandGuidString(String s) {
        if (s != null && s.length() == 32) {
            return s.substring(0, 12) + "-" + s.substring(12, 16) + "-" + s.substring(16, 20) + "-" + s.substring(20, 32);
        }
        if (s != null && s.length() == 35) {
            return s;
        }
        return "oracle.ldap.util.OrclGuid: Invalid GUID String";
    }

    public static void main(String[] argv) {
        int loop_count = 1;
        if (argv.length >= 1) {
            loop_count = Integer.parseInt(argv[0]);
        }
        for (int i = 0; i < loop_count; ++i) {
            OrclGuid my_guid = new OrclGuid();
            System.out.println(my_guid);
        }
    }
}

