/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class OracleSchema {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static final String OracleSchemaVersionRDN = "cn=OracleSchemaVersion";
    private static final String oracleSchemaVersionObjectClass = "orclSchemaVersion";
    private static final String oracleProductVersionAttribute = "orclProductVersion";
    private static final String adConfigurationRDN = "cn=Configuration";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    private static final String listFileExt = ".lst";
    private DirContext ctx = null;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;
    private String orclSchemaFilePrefix = "oidSchema";
    protected String ohome = null;
    protected PrintStream pStream = null;
    protected String orclSchemaVersion = null;
    private String fileSeparator = null;

    public OracleSchema(DirContext ctx, Logger lgr, String ohome) {
        this(ctx, ohome);
        m_logger = lgr;
    }

    public OracleSchema(DirContext ctx, String ohome) {
        this(ctx, ohome, System.out);
    }

    public OracleSchema(DirContext ctx, Logger lgr, String ohome, PrintStream pStream) {
        this(ctx, ohome, pStream);
        m_logger = lgr;
    }

    public OracleSchema(DirContext ctx, String ohome, PrintStream pStream) {
        this.ohome = ohome;
        this.ctx = ctx;
        this.pStream = pStream;
        this.fileSeparator = System.getProperty("file.separator");
    }

    public void create() throws UtilException {
        String schemaDir = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator;
        String curFile = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "admin" + this.fileSeparator + "odi.ldif";
        Util.ldapModify(this.ctx, m_logger, curFile, null, true, this.pStream);
        curFile = schemaDir + this.orclSchemaFilePrefix + "CreateAux.lst";
        Util.ldapModify(this.ctx, m_logger, curFile, null, true, this.pStream);
        curFile = schemaDir + this.orclSchemaFilePrefix + "Create.lst";
        Util.ldapModify(this.ctx, m_logger, curFile, null, true, this.pStream);
        if (!this.exists()) {
            throw new UtilException("Oracle Schema creation failed");
        }
    }

    public void create(String product, String schemaLoc) throws UtilException {
        if (!this.exists()) {
            throw new UtilException("Please create the Base OracleSchema");
        }
        if (this.isUpToDate(this.ctx, product, schemaLoc)) {
            return;
        }
        String curFile = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclSchemaFilePrefix + "Create.lst";
        Util.ldapModify(this.ctx, m_logger, curFile, null, true, this.pStream);
    }

    public boolean isUpToDate(DirContext ctx) {
        try {
            String version = this.getVersionFor(ctx, "BASE").trim();
            String versionFileName = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "versions.txt";
            m_logger.log(Level.INFO, versionFileName);
            String upToDateVersion = Util.getParameterFromFile("SchemaVersion", versionFileName).trim();
            m_logger.log(Level.INFO, "version: " + version + " up_version: " + upToDateVersion);
            int upToDateVersionInt = Integer.valueOf(upToDateVersion);
            int versionInt = Integer.valueOf(version);
            return versionInt >= upToDateVersionInt;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean isUpToDate(DirContext ctx, String product, String schemaLoc) {
        try {
            String version = this.getVersionFor(ctx, product).trim();
            String versionFileName = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + "versions.txt";
            m_logger.log(Level.INFO, versionFileName);
            String upToDateVersion = Util.getParameterFromFile("SchemaVersion", versionFileName).trim();
            m_logger.log(Level.INFO, "Schema version: " + version + " up_version: " + upToDateVersion);
            int upToDateVersionInt = Integer.valueOf(upToDateVersion);
            int versionInt = Integer.valueOf(version);
            return versionInt >= upToDateVersionInt;
        }
        catch (Exception e) {
            m_logger.log(Level.SEVERE, "Exception occurred", e);
            return true;
        }
    }

    public String getVersionFor(DirContext ctx, String product) throws UtilException {
        try {
            String baseDN = "cn=" + product + ",cn=OracleSchemaVersion";
            if (Util.dnExists(ctx, baseDN)) {
                PropertySetCollection psc = Util.ldapSearch(ctx, baseDN, "objectclass=*", 0, new String[]{"orclproductversion"});
                return ((String)psc.getPropertySet(0).getProperty(0).getValue(0)).trim();
            }
            return "0";
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), e);
        }
    }

    public String[][] getVersions() {
        return null;
    }

    public void upgrade(DirContext ctx) throws Exception {
        while (!this.isUpToDate(ctx)) {
            String curVersion = this.getVersionFor(ctx, "BASE");
            m_logger.log(Level.INFO, "curVersion: " + curVersion + "\n");
            String curUpgradeFromLst = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclSchemaFilePrefix + "UpgradeFrom" + curVersion + listFileExt;
            m_logger.log(Level.INFO, "Loading: " + curUpgradeFromLst);
            Util.ldapModify(ctx, m_logger, curUpgradeFromLst, null, true, this.pStream);
        }
    }

    public void upgrade(DirContext ctx, String product, String schemaLoc) throws Exception {
        while (!this.isUpToDate(ctx, product, schemaLoc)) {
            String curVersion = this.getVersionFor(ctx, product);
            m_logger.log(Level.INFO, "Schema curVersion: " + curVersion + "\n");
            String curUpgradeFromLst = curVersion.compareTo("0") != 0 ? this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclSchemaFilePrefix + "UpgradeFrom" + curVersion + listFileExt : this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclSchemaFilePrefix + "Create.lst";
            m_logger.log(Level.INFO, "Loading: " + curUpgradeFromLst);
            Util.ldapModify(ctx, m_logger, curUpgradeFromLst, null, true, this.pStream);
        }
    }

    public boolean exists() throws UtilException {
        return Util.getObjectClass(this.ctx, "orclContext") != null;
    }
}

