/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeGuid
implements Cloneable {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    public static final int GUID_BYTE_SIZE = 16;
    public static final int GUID_STRING_SIZE = 35;
    public static final int GUID_STRING_SIZE_NEW = 32;
    private static byte[] _npd_global;
    private byte[] _guid_bytes;
    private String _guid_string;

    private static synchronized native int init_npd();

    private native int getNLUID();

    private native int getNLUIBinaryVersion();

    private native int getNLUIStringVersion();

    private native int getNLUIHashCode();

    public static String compactGuidString(String s) {
        if (s != null && s.length() == 35) {
            return s.substring(0, 12) + s.substring(13, 17) + s.substring(18, 22) + s.substring(23, 35);
        }
        if (s != null && s.length() == 32) {
            return s;
        }
        return "oracle.ldap.util.NativeGuid: Invalid GUID String";
    }

    public static String expandGuidString(String s) {
        if (s != null && s.length() == 32) {
            return s.substring(0, 12) + "-" + s.substring(12, 16) + "-" + s.substring(16, 20) + "-" + s.substring(20, 32);
        }
        if (s != null && s.length() == 35) {
            return s;
        }
        return "oracle.ldap.util.NativeGuid: Invalid GUID String";
    }

    public static NativeGuid newInstance() {
        return new NativeGuid();
    }

    public NativeGuid() {
        if (_npd_global == null) {
            int n = NativeGuid.init_npd();
        }
        int ret_code = this.getNLUID();
    }

    public NativeGuid(String guid) {
        String int_guid;
        if (_npd_global == null) {
            int n = NativeGuid.init_npd();
        }
        if ((int_guid = NativeGuid.expandGuidString(guid)).length() == 35) {
            this._guid_string = int_guid.toUpperCase();
            int ret_code = this.getNLUIBinaryVersion();
            if (ret_code != 0) {
                this._guid_string = null;
                this._guid_bytes = null;
            }
        }
    }

    public NativeGuid(byte[] byte_array) {
        if (_npd_global == null) {
            int n = NativeGuid.init_npd();
        }
        if (byte_array.length == 16) {
            this._guid_bytes = byte_array;
            int ret_code = this.getNLUIStringVersion();
            if (ret_code != 0) {
                this._guid_string = null;
                this._guid_bytes = null;
            }
        }
    }

    public byte[] getBytes() {
        return this._guid_bytes;
    }

    public final String toString() {
        return NativeGuid.compactGuidString(this._guid_string);
    }

    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this._guid_bytes != null) {
            return this.getNLUIHashCode();
        }
        return 0;
    }

    public Object clone() {
        NativeGuid guid = new NativeGuid(this._guid_string);
        return guid;
    }

    public static void main(String[] argv) {
        int loop_count = 1;
        if (argv.length >= 1) {
            loop_count = Integer.parseInt(argv[0]);
        }
        for (int i = 0; i < loop_count; ++i) {
            NativeGuid my_guid = new NativeGuid();
            System.out.println(my_guid);
        }
    }

    static {
        try {
            Class.forName("oracle.ldap.util.LibldapjclntLoader");
        }
        catch (ClassNotFoundException cnfe) {
            m_logger.log(Level.SEVERE, "Exception occcurred", cnfe);
        }
    }
}

