/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LogHandler
extends Handler {
    private static InheritableThreadLocal threadOutputStream = new InheritableThreadLocal(){

        protected synchronized Object initialValue() {
            return System.err;
        }
    };

    public LogHandler(Formatter formatter) {
        this.setFormatter(formatter);
    }

    public void close() {
        this.flush();
    }

    public void flush() {
        this.getOutputStream().flush();
    }

    public void publish(LogRecord record) {
        PrintStream ps = this.getOutputStream();
        if (this.isLoggable(record)) {
            Formatter formatter = this.getFormatter();
            if (formatter == null) {
                ps.println("no formatter");
            } else {
                ps.println(formatter.format(record));
            }
        }
    }

    public void setOutputStream(PrintStream ps) {
        threadOutputStream.set(ps);
    }

    private PrintStream getOutputStream() {
        return (PrintStream)threadOutputStream.get();
    }
}

