/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String format(LogRecord record) {
        Throwable throwable;
        if (record == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        Level level = record.getLevel();
        String levelName = null;
        if (level != null) {
            levelName = level.getName();
        }
        if (levelName != null) {
            levelName = levelName.toLowerCase();
        }
        sw.write("[" + levelName + "] ");
        String message = record.getMessage();
        if (message != null) {
            sw.write(message);
        }
        if ((throwable = record.getThrown()) != null) {
            sw.write(LINE_SEPARATOR);
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.close();
            sw.write(".");
        }
        sw.flush();
        return sw.toString();
    }
}

