/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Vector;
import oracle.ldap.util.Base64;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.OrclGuid;

public class LDIFSubstitute {
    private static final char ESCAPE_CHAR = '\\';

    private static String substitute(String str, String schStr, String repStr) {
        StringBuffer retStrBuf = new StringBuffer();
        if (str == null || schStr == null || repStr == null) {
            retStrBuf = null;
        } else {
            schStr = "%" + schStr + "%";
            int sLen = schStr.length();
            int fromIndex = 0;
            int startIndex = str.indexOf(schStr, fromIndex);
            while (startIndex != -1) {
                if (startIndex != 0 && str.charAt(startIndex - 1) == '\\') {
                    retStrBuf.append(str.substring(fromIndex, startIndex - 1)).append(str.substring(startIndex, startIndex + sLen));
                    fromIndex = startIndex + sLen;
                    startIndex = str.indexOf(schStr, fromIndex);
                    continue;
                }
                retStrBuf.append(str.substring(fromIndex, startIndex)).append(repStr);
                fromIndex = startIndex + sLen;
                startIndex = str.indexOf(schStr, fromIndex);
            }
            retStrBuf.append(str.substring(fromIndex));
        }
        if (retStrBuf == null) {
            return null;
        }
        return retStrBuf.toString();
    }

    private static String substitute(String str, Vector sAndRep) {
        return LDIFSubstitute.substitute(str, sAndRep, false);
    }

    private static String substitute(String str, Vector sAndRep, boolean subOrclGuid) {
        String retStr = str;
        if (str != null && sAndRep != null) {
            int sz = 0;
            if (subOrclGuid) {
                String schStr = "%s_orclguid";
                int sLen = schStr.length();
                int toIndex = 0;
                int startIndex = str.indexOf(schStr);
                while (startIndex != -1) {
                    String orclGuidSubVar = null;
                    toIndex = str.indexOf("%", startIndex + sLen);
                    if (toIndex == -1) break;
                    orclGuidSubVar = str.substring(startIndex + 1, toIndex);
                    if (!sAndRep.contains(orclGuidSubVar)) {
                        sAndRep.add(orclGuidSubVar);
                        sAndRep.add(OrclGuid.newInstance().toString());
                    }
                    startIndex = str.indexOf(schStr, toIndex);
                }
            }
            sz = sAndRep.size();
            for (int iCn = 0; iCn < sz - 1; iCn += 2) {
                String schStr = (String)sAndRep.elementAt(iCn);
                String repStr = (String)sAndRep.elementAt(iCn + 1);
                retStr = LDIFSubstitute.substitute(retStr, schStr, repStr);
            }
        }
        return retStr;
    }

    public static Vector substitute(Vector ldifEntry, Vector sAndRep, boolean isUtf) {
        Vector<String> retVect;
        int ldifEntrySz = 0;
        int sAndRepSz = 0;
        if (ldifEntry == null || (ldifEntrySz = ldifEntry.size()) == 0) {
            retVect = null;
        } else if (sAndRep == null || (sAndRepSz = sAndRep.size()) == 0) {
            retVect = ldifEntry;
        } else {
            retVect = new Vector<String>();
            for (int iCn = 0; iCn < ldifEntrySz; ++iCn) {
                boolean base64Encoded = false;
                String tmpStr = (String)ldifEntry.elementAt(iCn);
                int startIndex = tmpStr.indexOf("::");
                if (startIndex != -1) {
                    tmpStr = tmpStr.substring(0, startIndex + 2) + (isUtf ? Base64.utfDecode(tmpStr.substring(startIndex + 2)) : new String(Base64.decode(tmpStr.substring(startIndex + 2).getBytes())));
                    base64Encoded = true;
                }
                String atrStr = tmpStr;
                for (int jCn = 0; jCn < sAndRepSz - 1; jCn += 2) {
                    String schStr = (String)sAndRep.elementAt(jCn);
                    String repStr = (String)sAndRep.elementAt(jCn + 1);
                    atrStr = LDIFSubstitute.substitute(atrStr, schStr, repStr);
                }
                if (atrStr == null) continue;
                if (base64Encoded) {
                    startIndex = atrStr.indexOf("::");
                    atrStr = atrStr.substring(0, startIndex + 2) + (isUtf ? Base64.utfEncode(atrStr.substring(startIndex + 2)) : new String(Base64.encode(atrStr.substring(startIndex + 2).getBytes())));
                }
                retVect.addElement(atrStr);
            }
        }
        return retVect;
    }

    public static Vector substitute(Vector ldifEntry, Vector sAndRep) {
        return LDIFSubstitute.substitute(ldifEntry, sAndRep, false);
    }

    public static LDIFRecord substitute(LDIFRecord ldifRecord, Vector sAndRep) {
        LDIFRecord retRecord = null;
        int ldifRecordSz = 0;
        int sAndRepSz = 0;
        if (ldifRecord == null) {
            retRecord = null;
        } else if (sAndRep == null || (sAndRepSz = sAndRep.size()) == 0) {
            retRecord = ldifRecord;
        } else {
            String newRDN = ldifRecord.getNewRdn();
            String newSuperior = ldifRecord.getNewSuperior();
            String newDN = LDIFSubstitute.substitute(ldifRecord.getDN(), sAndRep, true);
            ldifRecordSz = ldifRecord.size();
            retRecord = new LDIFRecord(newDN);
            retRecord.setChangeType(ldifRecord.getChangeType());
            retRecord.setExpChgType(ldifRecord.getExpChgType());
            if (null != newRDN) {
                newRDN = LDIFSubstitute.substitute(newRDN, sAndRep, true);
                if (null != newSuperior) {
                    newSuperior = LDIFSubstitute.substitute(newSuperior, sAndRep, true);
                }
                retRecord.setNewRdn(newRDN, ldifRecord.getDeleteOldRdn(), newSuperior);
            }
            for (int iCn = 0; iCn < ldifRecordSz; ++iCn) {
                int jCn;
                LDIFAttribute ldifAttribute = ldifRecord.getAttribute(iCn);
                String newAttrName = LDIFSubstitute.substitute(ldifAttribute.getName(), sAndRep, true);
                boolean isBinary = ldifAttribute.isBinary();
                LDIFAttribute newLDIFAttribute = new LDIFAttribute(newAttrName, isBinary);
                newLDIFAttribute.setChangeType(ldifAttribute.getChangeType());
                if (isBinary) {
                    byte[][] bvals = ldifAttribute.getByteValueArray();
                    if (bvals != null) {
                        for (jCn = 0; jCn < bvals.length; ++jCn) {
                            newLDIFAttribute.addValue(bvals[jCn]);
                        }
                    }
                } else {
                    String[] values = ldifAttribute.getStringValueArray();
                    if (values != null) {
                        for (jCn = 0; jCn < values.length; ++jCn) {
                            values[jCn] = LDIFSubstitute.substitute(values[jCn], sAndRep, true);
                        }
                        newLDIFAttribute.setValues(values);
                    }
                }
                retRecord.addAttribute(newLDIFAttribute);
            }
        }
        return retRecord;
    }

    public static void main(String[] args) {
        String rep = "s_var";
        String str = "%s_var%,dn: cn=Heman,%s_var%s_var%,dc=ORACLE,dc_COM%s_var%%s_var%";
        String repWith = "dc=IDC";
        System.out.println(str);
        System.out.println(LDIFSubstitute.substitute(str, rep, repWith));
    }
}

