/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ldap.util.Base64;
import oracle.ldap.util.InvalidLDIFRecordException;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;

public class LDIFReader {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static final char COMMENT = '#';
    private static String DEFAULT_ENCODING = null;
    private String m_encoding = null;
    private String lookAheadBuf = null;
    private BufferedReader inBuf = null;
    private boolean isEndOfEntry = false;
    private long readCount = 0L;
    private int currLineNo = -1;
    private boolean previousValue = false;
    private boolean attrValAsFileContent = false;
    private String[] binaryAttributes = null;
    private String version = null;
    private boolean firstRecord = true;

    public LDIFReader() throws IOException {
        this.inBuf = new BufferedReader(new InputStreamReader(System.in, DEFAULT_ENCODING));
        this.m_encoding = DEFAULT_ENCODING;
    }

    public LDIFReader(String file) throws IOException {
        this(file, DEFAULT_ENCODING);
    }

    public LDIFReader(String file, String encoding) throws IOException {
        if (null == encoding) {
            encoding = DEFAULT_ENCODING;
        }
        this.inBuf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        this.m_encoding = encoding;
    }

    public LDIFReader(File fileObj) throws IOException {
        this(fileObj, DEFAULT_ENCODING);
    }

    public LDIFReader(File fileObj, String encoding) throws IOException {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        this.inBuf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileObj), encoding));
        this.m_encoding = encoding;
    }

    public LDIFReader(InputStream ds) throws IOException {
        this(ds, DEFAULT_ENCODING);
    }

    public LDIFReader(InputStream ds, String encoding) throws IOException {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        this.inBuf = new BufferedReader(new InputStreamReader(ds, encoding));
        this.m_encoding = encoding;
    }

    public long getReadCount() {
        return this.readCount;
    }

    private void ensureOpen() throws IOException {
        if (this.inBuf == null) {
            throw new IOException("Stream closed");
        }
    }

    private synchronized String readAttributeLine() throws IOException {
        String ret;
        block11: {
            block12: {
                Object[] attrNV;
                String attrName;
                block10: {
                    ret = null;
                    this.ensureOpen();
                    if (this.isEndOfEntry) break block12;
                    while (true) {
                        Object[] attrNV2;
                        String attrName2;
                        ret = this.inBuf.readLine();
                        ++this.currLineNo;
                        if (ret == null) break block10;
                        this.readCount += (long)(ret.length() + 1);
                        if (ret.length() < 1) {
                            if (this.lookAheadBuf == null) continue;
                            if (this.lookAheadBuf.charAt(0) == '#') {
                                ret = null;
                                this.lookAheadBuf = null;
                                if (!this.previousValue) continue;
                                this.previousValue = false;
                            } else {
                                if (this.firstRecord && (attrName = (String)(attrNV = this.getAttrNV(this.lookAheadBuf))[0]).equalsIgnoreCase("version")) {
                                    this.version = (String)attrNV[1];
                                    this.firstRecord = false;
                                    this.lookAheadBuf = null;
                                    continue;
                                }
                                ret = this.lookAheadBuf;
                                this.lookAheadBuf = null;
                                this.isEndOfEntry = true;
                                this.firstRecord = false;
                            }
                            break block11;
                        }
                        if (this.lookAheadBuf == null) {
                            this.lookAheadBuf = ret;
                            continue;
                        }
                        if (ret.charAt(0) == ' ' || ret.charAt(0) == '\t') {
                            this.lookAheadBuf = this.lookAheadBuf + ret.substring(1);
                            continue;
                        }
                        String tmp = this.lookAheadBuf;
                        this.lookAheadBuf = ret;
                        ret = tmp;
                        if (ret.charAt(0) == '#') continue;
                        if (!this.firstRecord || !(attrName2 = (String)(attrNV2 = this.getAttrNV(ret))[0]).equalsIgnoreCase("version")) break;
                        this.version = (String)attrNV2[1];
                        this.firstRecord = false;
                    }
                    this.firstRecord = false;
                    this.previousValue = true;
                    break block11;
                }
                this.isEndOfEntry = true;
                ret = this.lookAheadBuf;
                this.lookAheadBuf = null;
                if (ret != null && ret.charAt(0) == '#') {
                    ret = null;
                } else if (this.firstRecord && ret != null && (attrName = (String)(attrNV = this.getAttrNV(ret))[0]).equalsIgnoreCase("version")) {
                    this.version = (String)attrNV[1];
                    this.firstRecord = false;
                }
                break block11;
            }
            this.isEndOfEntry = false;
            this.previousValue = false;
        }
        return ret;
    }

    public void setBinaryAttributes(String[] attrNames) {
        this.binaryAttributes = attrNames;
    }

    private boolean isBinaryAttribute(String attrName) {
        if (null != attrName && null != this.binaryAttributes && 0 != this.binaryAttributes.length) {
            for (int i = 0; i < this.binaryAttributes.length; ++i) {
                if (!attrName.equalsIgnoreCase(this.binaryAttributes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Vector nextEntry() throws IOException {
        Vector<String> retVector = new Vector<String>();
        String attrNV = null;
        while ((attrNV = this.readAttributeLine()) != null) {
            retVector.addElement(attrNV);
        }
        if (retVector.size() == 0) {
            retVector = null;
        }
        return retVector;
    }

    private byte[] string2bytes(String attrStr) {
        byte[] retBytes = null;
        try {
            retBytes = attrStr.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            m_logger.log(Level.INFO, uee.getMessage());
        }
        return retBytes;
    }

    private String bytes2string(byte[] bytes) {
        String retStr = null;
        try {
            retStr = new String(bytes, this.m_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            m_logger.log(Level.INFO, uee.getMessage());
        }
        return retStr;
    }

    private Object[] getAttrNV(String attrNV) {
        if (attrNV == null) {
            return null;
        }
        Object[] retArr = new Object[3];
        int endIndex = 0;
        int startIndex = 0;
        int len = attrNV.length();
        boolean base64Encoded = false;
        boolean urlAttribValue = false;
        String attrName = null;
        String attrValue = "";
        byte[] byteValue = null;
        retArr[2] = "0";
        endIndex = attrNV.indexOf(":");
        if (endIndex == -1) {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE");
        }
        attrName = attrNV.substring(startIndex, endIndex).trim();
        if (attrName.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE");
        }
        if (endIndex + 1 < len) {
            if (attrNV.charAt(endIndex + 1) == ':') {
                ++endIndex;
                base64Encoded = true;
            } else if (attrNV.charAt(endIndex + 1) == '<') {
                ++endIndex;
                urlAttribValue = true;
            }
        }
        startIndex = endIndex + 1;
        endIndex = len;
        attrValue = attrNV.substring(startIndex, endIndex).trim();
        if (urlAttribValue) {
            byteValue = this.readFile(attrValue);
            if (this.isBinaryAttribute(attrName)) {
                retArr[2] = "1";
            } else {
                attrValue = this.bytes2string(byteValue);
            }
        } else if (base64Encoded) {
            if (this.isBinaryAttribute(attrName)) {
                byteValue = Base64.decode(this.string2bytes(attrValue));
                retArr[2] = "1";
            } else {
                try {
                    attrValue = new String(Base64.decode(attrValue.getBytes()), "UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    attrValue = null;
                    m_logger.log(Level.INFO, uee.getMessage());
                }
            }
        } else if (this.attrValAsFileContent && !attrValue.equals("") && (attrValue.startsWith("/") || attrValue.indexOf(":") == 1)) {
            byteValue = this.readFile(attrValue);
            if (this.isBinaryAttribute(attrName)) {
                retArr[2] = "1";
            } else {
                attrValue = this.bytes2string(byteValue);
            }
        }
        retArr[0] = attrName;
        retArr[1] = retArr[2].equals("1") ? byteValue : (byte[])attrValue;
        return retArr;
    }

    private byte[] readFile(String urlStr) {
        byte[] retArr = null;
        try {
            BufferedInputStream bufStream = null;
            if (urlStr.startsWith("/") || urlStr.indexOf(":") == 1) {
                File valFile = new File(urlStr);
                bufStream = new BufferedInputStream(new FileInputStream(new File(urlStr)), 4096);
            } else {
                bufStream = new BufferedInputStream(new URL(urlStr).openStream(), 4096);
            }
            retArr = new byte[bufStream.available()];
            bufStream.read(retArr, 0, retArr.length);
            bufStream.close();
        }
        catch (IOException ioe) {
            throw new InvalidLDIFRecordException(this.currLineNo, ioe.getMessage());
        }
        return retArr;
    }

    private void handleRecChangeTypeModDn(LDIFRecord ldifRecord) throws IOException {
        ldifRecord.setChangeType(4);
        String attrNV = this.readAttributeLine();
        if (attrNV == null) {
            throw new InvalidLDIFRecordException(this.currLineNo, "NEWRDN_EXPECTED");
        }
        Object[] attrNVArr = this.getAttrNV(attrNV);
        String attrName = (String)attrNVArr[0];
        String attrValue = (String)attrNVArr[1];
        if (!attrName.equalsIgnoreCase("newrdn") || attrValue == null || attrValue.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "NEWRDN_EXPECTED");
        }
        boolean deleteOldRdn = false;
        String newSuperior = null;
        String newAttrNV = this.readAttributeLine();
        while (null != newAttrNV) {
            Object[] newArr = this.getAttrNV(newAttrNV);
            String newAttrName = (String)newArr[0];
            String newAttrVal = (String)newArr[1];
            if (newAttrName.equalsIgnoreCase("deleteoldrdn")) {
                if (newAttrVal == null || !newAttrVal.equals("1") && !newAttrVal.equals("0")) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_DELETEOLDRDN_0/1_EXPECTED");
                }
                deleteOldRdn = newAttrVal.equals("1");
                newAttrNV = this.readAttributeLine();
                continue;
            }
            if (newAttrName.equalsIgnoreCase("newsuperior")) {
                if (newAttrVal == null || newAttrVal.equals("")) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "NEWSUPERIOR_VALUE_EXPECTED");
                }
                newSuperior = newAttrVal;
                newAttrNV = this.readAttributeLine();
                continue;
            }
            throw new InvalidLDIFRecordException(this.currLineNo, "UNKNOWN_ATTRIBUTE");
        }
        ldifRecord.setNewRdn(attrValue, deleteOldRdn, newSuperior);
    }

    private void handleRecChangeTypeDelete(LDIFRecord ldifRecord) throws IOException {
        ldifRecord.setChangeType(2);
        String attrNV = this.readAttributeLine();
        if (attrNV != null) {
            Object[] arr = this.getAttrNV(attrNV);
            String attrName = (String)arr[0];
            String attrValue = (String)arr[1];
            if (attrName.equalsIgnoreCase("orclguid")) {
                ldifRecord.add(attrName, attrValue, 6);
                attrNV = this.readAttributeLine();
                if (attrNV == null) {
                    return;
                }
            }
            throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_NOT_EXPECTED");
        }
    }

    private void handleRecChangeTypeModify(LDIFRecord ldifRecord) throws IOException {
        ldifRecord.setChangeType(3);
        String attrNV = null;
        boolean atLeastOneAttribute = false;
        while ((attrNV = this.readAttributeLine()) != null) {
            Object[] arr = this.getAttrNV(attrNV);
            String attrName = (String)arr[0];
            String attrValue = (String)arr[1];
            int atrChangeType = 5;
            boolean isBinaryAttr = false;
            if (attrName.equalsIgnoreCase("changetype")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "REC_CHANGE_ALREADY_DEFINED");
            }
            if (attrName.equalsIgnoreCase("delete")) {
                atrChangeType = 6;
            } else if (attrName.equalsIgnoreCase("replace")) {
                atrChangeType = 7;
            } else if (!attrName.equalsIgnoreCase("add")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_ATTRIBUTE_CHANGE_TYPE");
            }
            if (attrValue == null || attrValue.equals("")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_VALUE_MANDATORY");
            }
            attrName = attrValue;
            isBinaryAttr = this.isBinaryAttribute(attrName);
            LDIFAttribute attribute = new LDIFAttribute(attrName, isBinaryAttr);
            attribute.setChangeType(atrChangeType);
            String nextAttrNV = null;
            while ((nextAttrNV = this.readAttributeLine()) != null && !nextAttrNV.trim().equals("-")) {
                Object[] nextArr = this.getAttrNV(nextAttrNV);
                String nextAttrName = (String)nextArr[0];
                String nextAttrVal = null;
                byte[] nextAttrByteVal = null;
                String substr = null;
                int index = 0;
                if (isBinaryAttr) {
                    nextAttrByteVal = (byte[])nextArr[1];
                } else {
                    nextAttrVal = (String)nextArr[1];
                }
                index = attrName.indexOf(59);
                if (atrChangeType == 5 && index == -1 ? ((index = nextAttrName.indexOf(59)) != -1 ? !(substr = nextAttrName.substring(0, index)).equalsIgnoreCase(attrName) : !nextAttrName.equalsIgnoreCase(attrName)) : !nextAttrName.equalsIgnoreCase(attrName)) {
                    throw new InvalidLDIFRecordException(this.currLineNo, "ATTRIBUTE_TYPE_NAME_MISMATCH");
                }
                if (isBinaryAttr) {
                    attribute.addValue(nextAttrByteVal);
                } else {
                    attribute.addValue(nextAttrVal);
                }
                atLeastOneAttribute = true;
            }
            if (!atLeastOneAttribute && atrChangeType == 5) {
                throw new InvalidLDIFRecordException(this.currLineNo, "NO_ATTRIBUTE_ADD_CHANGE_VALUE");
            }
            ldifRecord.addAttribute(attribute);
            if (nextAttrNV != null) continue;
            return;
        }
    }

    private void handleChangeRecord(LDIFRecord ldifRecord, String changeType) throws IOException {
        Object attrNV = null;
        if (changeType == null || changeType.equals("")) {
            throw new InvalidLDIFRecordException(this.currLineNo, "REC_CHANGE_NOT_DEFINED");
        }
        if (changeType.equalsIgnoreCase("delete")) {
            this.handleRecChangeTypeDelete(ldifRecord);
        } else if (changeType.equalsIgnoreCase("modify")) {
            this.handleRecChangeTypeModify(ldifRecord);
        } else if (changeType.equalsIgnoreCase("modrdn") || changeType.equalsIgnoreCase("moddn")) {
            this.handleRecChangeTypeModDn(ldifRecord);
        } else if (changeType.equalsIgnoreCase("add")) {
            this.handleAttrValueRecord(ldifRecord);
        } else {
            throw new InvalidLDIFRecordException(this.currLineNo, "INVALID_RECORD_CHANGE_TYPE");
        }
        ldifRecord.setExpChgType(true);
    }

    private void handleAttrValueRecord(LDIFRecord ldifRecord) throws IOException {
        ldifRecord.setChangeType(1);
        String attrNV = null;
        while ((attrNV = this.readAttributeLine()) != null) {
            Object[] arr = this.getAttrNV(attrNV);
            String attrName = (String)arr[0];
            String attrValue = null;
            byte[] attrByteVal = null;
            LDIFAttribute attribute = ldifRecord.getAttribute(attrName);
            if (arr[2].equals("1")) {
                attrByteVal = (byte[])arr[1];
            } else {
                attrValue = (String)arr[1];
            }
            if (attribute == null) {
                attribute = arr[2].equals("1") ? new LDIFAttribute(attrName, attrByteVal, true) : new LDIFAttribute(attrName, attrValue);
                ldifRecord.addAttribute(attribute);
                continue;
            }
            if (arr[2].equals("1")) {
                attribute.addValue(attrByteVal);
                continue;
            }
            attribute.addValue(attrValue);
        }
    }

    public synchronized LDIFRecord nextRecord() throws IOException {
        LDIFRecord ldifRecord = null;
        String attrNV = null;
        attrNV = this.readAttributeLine();
        if (attrNV != null) {
            Object[] arr = this.getAttrNV(attrNV);
            String attrName = (String)arr[0];
            String attrValue = (String)arr[1];
            Object attrByteValue = null;
            if (!attrName.equalsIgnoreCase("dn")) {
                throw new InvalidLDIFRecordException(this.currLineNo, "DN_NOT_FIRST");
            }
            ldifRecord = new LDIFRecord(attrValue);
            attrNV = this.readAttributeLine();
            if (attrNV != null) {
                arr = this.getAttrNV(attrNV);
                attrName = (String)arr[0];
                if (attrName.equalsIgnoreCase("changetype")) {
                    this.handleChangeRecord(ldifRecord, (String)arr[1]);
                } else {
                    LDIFAttribute ldifAttr = arr[2].equals("1") ? new LDIFAttribute(attrName, (byte[])arr[1], true) : new LDIFAttribute(attrName, (String)arr[1]);
                    ldifRecord.addAttribute(ldifAttr);
                    this.handleAttrValueRecord(ldifRecord);
                }
            }
        }
        return ldifRecord;
    }

    public void close() throws IOException {
        if (this.inBuf != null) {
            this.inBuf.close();
            this.inBuf = null;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setReadFileContentForAttrib(boolean bool) {
        this.attrValAsFileContent = bool;
    }

    private static void test1(String file) {
        LDIFReader ldifReader = null;
        String[] bAttrs = new String[]{"jpegphoto"};
        try {
            ldifReader = new LDIFReader(file);
            ldifReader.setBinaryAttributes(bAttrs);
        }
        catch (Exception e) {
            System.err.println("Error while reading LDIF file " + file);
            System.err.println(e.toString());
            System.exit(1);
        }
        try {
            LDIFRecord record = null;
            while ((record = ldifReader.nextRecord()) != null) {
                System.out.println(record);
            }
            ldifReader.close();
        }
        catch (IOException ex) {
            System.out.println("Error while reading the LDIF File " + file);
            System.exit(1);
        }
    }

    private static void test2(String file) {
        LDIFReader ldifReader = null;
        try {
            ldifReader = new LDIFReader(file);
        }
        catch (Exception e) {
            System.err.println("Error while reading LDIF file " + file);
            System.err.println(e.toString());
            System.exit(1);
        }
        try {
            Object attr = null;
            Vector vect = null;
            boolean i = false;
            while ((vect = ldifReader.nextEntry()) != null) {
                for (int ix = 0; ix < vect.size(); ++ix) {
                    System.out.println(vect.elementAt(ix));
                }
                System.out.println();
            }
            ldifReader.close();
        }
        catch (IOException ex) {
            System.out.println("Error while reading the LDIF File " + file);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java LDIFReader <FILE1>");
            System.exit(1);
        }
        LDIFReader.test1(args[0]);
        LDIFReader.test2(args[0]);
    }

    static {
        DEFAULT_ENCODING = System.getProperty("file.encoding");
    }
}

