/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.UtilException;

public class LDIFLoader {
    private static String fileName = null;
    private static Vector subVector = null;
    private boolean debug = true;
    private DirContext ctx = null;
    private boolean ignoreError = false;
    private NamingException[] ignoredExceptionList = null;
    private PrintStream pStream = null;
    private String listFileExt = ".lst";
    private String sbsFileExt = ".sbs";
    private static ResourceBundle resBundle = LDAPEntry.resBundle;
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");

    public LDIFLoader(DirContext inCtx, String inFileName, Vector inSubVector, Logger lgr) {
        this(inCtx, inFileName, inSubVector);
        m_logger = lgr;
    }

    public LDIFLoader(DirContext inCtx, String inFileName, Vector inSubVector) {
        fileName = inFileName;
        subVector = inSubVector;
        if (inCtx == null || inFileName == null) {
            // empty if block
        }
        this.ctx = inCtx;
        this.debug = true;
        this.pStream = System.out;
    }

    public void load() throws UtilException {
        if (fileName.endsWith(this.listFileExt)) {
            this.recursiveLoad(fileName, "");
        } else {
            this.loadOneLdifFile(fileName, "");
        }
    }

    public void load(boolean ignoreError, PrintStream pStream) throws UtilException {
        this.pStream = pStream == null ? System.out : pStream;
        this.ignoreError = ignoreError;
        this.load();
    }

    private void recursiveLoad(String inFileName, String indentStr) throws UtilException {
        if (this.debug) {
            m_logger.log(Level.INFO, indentStr + "->> " + inFileName + " *");
        }
        try {
            File file = new File(inFileName);
            if (!file.exists()) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String directory = file.getParent();
            while (in.ready()) {
                String curLine = in.readLine().trim();
                if (curLine.length() <= 0 || curLine.startsWith("#")) continue;
                String curFile = directory + File.separator + curLine;
                if (curFile.endsWith(this.listFileExt)) {
                    this.recursiveLoad(curFile, indentStr + "   ");
                    continue;
                }
                this.loadOneLdifFile(curFile, indentStr + "   ");
            }
        }
        catch (Exception e) {
            m_logger.log(Level.SEVERE, "Exception in recursive load", this);
        }
    }

    private void loadOneLdifFile(String curFileName, String indentStr) throws UtilException {
        try {
            if (this.debug) {
                m_logger.log(Level.INFO, indentStr + "-> LOADING:  " + curFileName);
            }
            LDIFReader ldifReader = new LDIFReader(curFileName);
            LDIFWriter ldifWriter = null;
            ByteArrayOutputStream outStream = null;
            outStream = new ByteArrayOutputStream();
            ldifWriter = new LDIFWriter(outStream);
            Vector ldifEntry = null;
            Vector subsLdifEntry = null;
            while ((ldifEntry = ldifReader.nextEntry()) != null) {
                subsLdifEntry = LDIFSubstitute.substitute(ldifEntry, subVector);
                ldifWriter.writeEntry(subsLdifEntry);
            }
            ldifWriter.close();
            ldifReader.close();
            ldifReader = new LDIFReader(new ByteArrayInputStream(outStream.toByteArray()), "UTF-8");
            LDIFRecord curRecord = null;
            while ((curRecord = ldifReader.nextRecord()) != null) {
                try {
                    switch (curRecord.getChangeType()) {
                        case 1: {
                            Attributes attrs = curRecord.getJNDIAttributes();
                            this.ctx.createSubcontext(curRecord.getDN(), attrs);
                            break;
                        }
                        case 3: {
                            ModificationItem[] modItem = curRecord.getJNDIModificationItems();
                            this.ctx.modifyAttributes(curRecord.getDN(), modItem);
                            break;
                        }
                        case 2: {
                            this.ctx.destroySubcontext(curRecord.getDN());
                        }
                    }
                }
                catch (NamingException e) {
                    if (e instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
                    }
                    if (this.ignoreError) {
                        m_logger.log(Level.INFO, "Error:  " + curFileName);
                        m_logger.log(Level.INFO, curRecord.toString());
                        if (!this.isIgnoredException(e)) {
                            m_logger.log(Level.INFO, e.toString());
                            throw new UtilException("NamingException encountered during loading of file:  " + curFileName, e);
                        }
                    } else {
                        throw new UtilException("NamingException encountered during loading of file:  " + curFileName + curRecord.toString(), e);
                    }
                    m_logger.log(Level.INFO, "Ignoring Error:  " + e.toString());
                    m_logger.log(Level.INFO, "\n");
                }
            }
            ldifReader.close();
        }
        catch (IOException e) {
            throw new UtilException("IOException encountered when loading file:  " + curFileName, e);
        }
    }

    private boolean isIgnoredException(NamingException ne) {
        if (this.ignoredExceptionList == null) {
            return true;
        }
        return ne instanceof AttributeInUseException || ne instanceof NameAlreadyBoundException || ne instanceof NoSuchAttributeException;
    }
}

