/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPObjectClass {
    private String objClsValue = null;
    private String OID = null;
    private String NAME = null;
    private String DESC = null;
    private Vector SUPER = null;
    private Vector mandatoryAttrs = null;
    private Vector optionalAttrs = null;
    public final int TYPE_NONE = 0;
    public final int TYPE_STRUCTURAL = 1;
    public final int TYPE_ABSTRACT = 2;
    public final int TYPE_AUXILIARY = 3;
    private int TYPE = 0;

    public LDAPObjectClass(String inObjClsValue) {
        this.objClsValue = inObjClsValue;
        StringTokenizer oidTok = new StringTokenizer(inObjClsValue.substring(inObjClsValue.indexOf("(") + 1));
        this.OID = oidTok.nextToken();
        StringTokenizer nameTok = new StringTokenizer(inObjClsValue.substring(inObjClsValue.indexOf("NAME") + 4).trim(), "'");
        this.NAME = nameTok.nextToken();
        if (inObjClsValue.indexOf("DESC") > -1) {
            StringTokenizer descTok = new StringTokenizer(inObjClsValue.substring(inObjClsValue.indexOf("DESC") + 4).trim(), "'");
            this.DESC = descTok.nextToken();
        }
        if (inObjClsValue.indexOf("AUXILIARY") > -1) {
            this.TYPE = 3;
        } else if (inObjClsValue.indexOf("ABSTRACT") > -1) {
            this.TYPE = 2;
        } else if (inObjClsValue.indexOf("STRUCTURAL") > -1) {
            this.TYPE = 1;
        }
        String[] typeArr = new String[]{"SUP", "MUST", "MAY"};
        Vector[] tmpVector = new Vector[3];
        this.SUPER = new Vector();
        this.mandatoryAttrs = new Vector();
        this.optionalAttrs = new Vector();
        tmpVector[0] = this.SUPER;
        tmpVector[1] = this.mandatoryAttrs;
        tmpVector[2] = this.optionalAttrs;
        for (int i = 0; i < typeArr.length; ++i) {
            int typeInd = inObjClsValue.indexOf(typeArr[i]);
            if (typeInd <= -1) continue;
            StringTokenizer typeTok = new StringTokenizer(inObjClsValue.substring(typeInd + typeArr[i].length(), inObjClsValue.length()));
            String firstTok = typeTok.nextToken();
            if (firstTok.equals("(")) {
                StringTokenizer valueTok = new StringTokenizer(typeTok.nextToken(")"), "$");
                while (valueTok.hasMoreTokens()) {
                    tmpVector[i].addElement(valueTok.nextToken().trim());
                }
                continue;
            }
            tmpVector[i].addElement(firstTok.replace('\'', ' ').trim());
        }
    }

    public String getName() {
        return this.NAME;
    }

    public String getOID() {
        return this.OID;
    }

    public String getDESC() {
        return this.DESC;
    }

    public int getType() {
        return this.TYPE;
    }

    public String[] getSuperClass() {
        return this.SUPER.toArray(new String[0]);
    }

    public String[] getMandatoryAttributes() {
        return this.mandatoryAttrs.toArray(new String[0]);
    }

    public String[] getOptionalAttributes() {
        return this.optionalAttrs.toArray(new String[0]);
    }

    public String getObjectClassDef() {
        return this.objClsValue;
    }

    public static String getName(String objClsValue) {
        StringTokenizer nameTok = new StringTokenizer(objClsValue.substring(objClsValue.indexOf("NAME") + 4).trim(), "'");
        return nameTok.nextToken();
    }

    public static String getOID(String objClsValue) {
        StringTokenizer oidTok = new StringTokenizer(objClsValue.substring(objClsValue.indexOf("(") + 1));
        return oidTok.nextToken();
    }
}

