/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public abstract class LDAPEntry
implements Serializable {
    protected static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    protected String entryDN = null;
    protected String inEntryId = null;
    protected int entryIdType = -1;
    protected PropertySetCollection entryPsc = null;
    protected boolean validated = false;

    public LDAPEntry() {
    }

    protected LDAPEntry(DirContext inCtx, String inEntryDN) {
        this.entryDN = inEntryDN;
        this.entryPsc = new PropertySetCollection();
    }

    protected LDAPEntry(DirContext inCtx, String inEntryDN, PropertySet inDnPs) {
        this.entryDN = inEntryDN;
        this.entryPsc = new PropertySetCollection();
        this.entryPsc.add(inDnPs);
    }

    public PropertySetCollection getProperties(DirContext ctx, String[] attrList, boolean usecache) throws UtilException {
        if (!this.validated) {
            this.resolve(ctx);
        }
        try {
            if (usecache && attrList != null && !this.entryPsc.isEmpty()) {
                this.entryPsc.getPropertySet(0).doSearch(ctx, attrList);
                PropertySetCollection returnPsc = new PropertySetCollection();
                returnPsc.add(this.entryPsc.getPropertySet(0).returnPropertySet(attrList));
                return returnPsc;
            }
            this.entryPsc = Util.getEntryDetails(ctx, this.entryDN, "(objectclass=*)", 0, attrList);
            return this.entryPsc;
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new GeneralErrorException(resBundle.getString("NAMINGEXCEPTION_SEARCH") + ":  " + this.entryDN, e);
        }
    }

    public void setProperties(DirContext ctx, ModPropertySet ps) throws UtilException {
        this.resolve(ctx);
        Util.ldapModify(ctx, this.entryDN, ps);
    }

    public String getDN(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        return this.entryDN;
    }

    public abstract void resolve(DirContext var1) throws UtilException;
}

