/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.JARReader;
import oracle.ldap.util.jndi.ConnectionUtil;

public class LDAPClassLoader
extends ClassLoader {
    private DirContext m_dirCtx = null;
    private String m_dn = null;
    private String m_attr = null;
    private boolean m_jarResource = true;
    private JARReader m_jarReader = null;

    public LDAPClassLoader(DirContext dirCtx, String dn, String attrName, ClassLoader parent) {
        super(parent);
        this.m_dirCtx = dirCtx;
        this.m_dn = dn;
        this.m_attr = attrName;
    }

    public LDAPClassLoader(DirContext dirCtx, String dn, String attrName) {
        this.m_dirCtx = dirCtx;
        this.m_dn = dn;
        this.m_attr = attrName;
    }

    public void setJARResource(boolean enable) {
        this.m_jarResource = enable;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> retClass = null;
        if (!this.m_jarResource) {
            retClass = this.getClassFromLDAP(name);
        } else {
            byte[] classBytes;
            if (null == this.m_jarReader) {
                byte[] jarContent = null;
                ZipInputStream zis = null;
                try {
                    jarContent = this.getAttrFromLDAP();
                    if (null == jarContent) {
                        throw new ClassNotFoundException("JAR missing in the directory");
                    }
                    zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(jarContent)));
                    this.m_jarReader = new JARReader(zis);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(ioe.getMessage());
                }
                catch (NamingException ne) {
                    throw new ClassNotFoundException(ne.getMessage());
                }
                finally {
                    try {
                        if (zis != null) {
                            zis.close();
                            zis = null;
                        }
                    }
                    catch (IOException ioe) {}
                }
            }
            if (null != (classBytes = this.m_jarReader.getResource(this.formatClassName(name)))) {
                retClass = this.defineClass(name, classBytes, 0, classBytes.length);
            } else {
                throw new ClassNotFoundException(name);
            }
        }
        return retClass;
    }

    private String formatClassName(String name) {
        return name.replace('.', '/') + ".class";
    }

    private Class getClassFromLDAP(String name) throws ClassNotFoundException {
        Class<?> retClass = null;
        try {
            byte[] classBytes = this.getAttrFromLDAP();
            if (null == classBytes) {
                throw new ClassNotFoundException(name);
            }
            retClass = this.defineClass(name, classBytes, 0, classBytes.length);
        }
        catch (NamingException ne) {
            throw new ClassNotFoundException(name);
        }
        return retClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAttrFromLDAP() throws NamingException {
        Attribute attr = null;
        Attributes attrs = null;
        String binPropKey = "java.naming.ldap.attributes.binary";
        Object prevPropVal = null;
        byte[] retBytes = null;
        try {
            prevPropVal = this.m_dirCtx.addToEnvironment(binPropKey, this.m_attr);
            attrs = this.m_dirCtx.getAttributes(this.m_dn, new String[]{this.m_attr});
            attr = attrs.get(this.m_attr);
            if (null != attr) {
                retBytes = (byte[])attr.get();
            }
        }
        finally {
            try {
                if (null != prevPropVal) {
                    this.m_dirCtx.addToEnvironment(binPropKey, prevPropVal);
                } else {
                    this.m_dirCtx.removeFromEnvironment(binPropKey);
                }
            }
            catch (NamingException ne) {}
        }
        return retBytes;
    }

    public static void main(String[] s) throws Exception {
        InitialLdapContext dirCtx = ConnectionUtil.getDefaultDirCtx("localhost", "3060", "cn=orcladmin", "welcome");
        String dn = "cn=plugins,orclApplicationType=EMAIL,cn=Applications,cn=Provisioning,cn=Directory Integration Platform,cn=Products,cn=OracleContext";
        String attr = "orclodippluginexecdata";
        LDAPClassLoader cl = new LDAPClassLoader(dirCtx, dn, attr);
        Class<?> cls = cl.loadClass(s[0]);
        Object obj = cls.newInstance();
        System.out.println(obj);
    }
}

