/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.ldap.util.UtilDebug;

public class JARReader
implements Serializable {
    private HashMap m_hashJarContents = null;
    private int INIT_CONTENT_SIZE = 4096;
    private int INCR_CONTENT_SIZE = 2048;
    private boolean m_closeInStream = false;

    public JARReader(byte[] jarContents) throws IOException {
        ZipInputStream zis = null;
        zis = new ZipInputStream(new BufferedInputStream(new ByteArrayInputStream(jarContents)));
        this.m_closeInStream = true;
        this.m_hashJarContents = new HashMap();
        this.init(zis);
    }

    public JARReader(ZipInputStream zis) throws IOException {
        this.m_hashJarContents = new HashMap();
        this.init(zis);
    }

    public byte[] getResource(String name) {
        return (byte[])this.m_hashJarContents.get(name);
    }

    private void init(ZipInputStream zis) throws IOException {
        ZipEntry ze = null;
        this.debug("Intializing.....");
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.isDirectory()) continue;
            int size = this.INIT_CONTENT_SIZE;
            int rb = 0;
            int chunk = 0;
            byte[] b = null;
            ArrayList<Object> al = new ArrayList<Object>();
            while (-1 != (chunk = zis.read(b = new byte[size], 0, size))) {
                rb += chunk;
                al.add(b);
                al.add(new Integer(chunk));
                size = this.INCR_CONTENT_SIZE;
            }
            int alsz = al.size();
            byte[] classBytes = new byte[rb];
            int offSet = 0;
            String key = ze.getName();
            for (int i = 0; i < alsz; i += 2) {
                byte[] src = (byte[])al.get(i);
                int sz = (Integer)al.get(i + 1);
                System.arraycopy(src, 0, classBytes, offSet, sz);
                offSet += sz;
            }
            this.m_hashJarContents.put(key, classBytes);
        }
        this.debug("Intializing finished.....");
        if (this.m_closeInStream && zis != null) {
            zis.close();
            zis = null;
        }
    }

    int size() {
        return this.m_hashJarContents.size();
    }

    private void debug(String msg) {
        UtilDebug.log(64, "JARReader: ", msg);
    }
}

