/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import oracle.ldap.util.JARReader;
import oracle.ldap.util.UtilDebug;

public class JARClassLoader
extends ClassLoader
implements Serializable {
    JARReader[] m_jarReader = null;

    public JARClassLoader(byte[][] jarContents, ClassLoader parentClLoader) throws IOException {
        super(parentClLoader);
        this.m_jarReader = new JARReader[jarContents.length];
        for (int i = 0; i < jarContents.length; ++i) {
            this.m_jarReader[i] = new JARReader(jarContents[i]);
            this.debug("Total Files in JAR-" + (i + 1) + " = " + this.m_jarReader[i].size());
        }
        this.debug("Initialized No.Of JARS : " + jarContents.length);
    }

    public JARClassLoader(byte[] jarContents, ClassLoader parentClLoader) throws IOException {
        super(parentClLoader);
        this.m_jarReader = new JARReader[1];
        this.m_jarReader[0] = new JARReader(jarContents);
        this.debug("Initialized...");
    }

    public JARClassLoader(byte[] jarContents) throws IOException {
        this.m_jarReader = new JARReader[1];
        this.m_jarReader[0] = new JARReader(jarContents);
        this.debug("Initialized...");
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> retClass;
        block3: {
            retClass = null;
            name = name.trim();
            try {
                retClass = super.findClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                for (int i = 0; i < this.m_jarReader.length; ++i) {
                    byte[] classBytes = this.m_jarReader[i].getResource(this.formatClassName(name));
                    if (null == classBytes) continue;
                    retClass = this.defineClass(name, classBytes, 0, classBytes.length);
                    break;
                }
                if (null != retClass) break block3;
                this.debug("Class Not found - " + name);
                throw new ClassNotFoundException(name);
            }
        }
        return retClass;
    }

    protected URL findResource(String name) {
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        ByteArrayInputStream inStream = null;
        for (int i = 0; i < this.m_jarReader.length; ++i) {
            byte[] resBytes = this.m_jarReader[i].getResource(name);
            if (resBytes == null) continue;
            inStream = new ByteArrayInputStream(resBytes);
            this.debug("Resource found in JAR : " + i);
            break;
        }
        if (inStream == null) {
            this.debug("getResourceAsStream Called - > NOT FOUND " + name);
        }
        return inStream;
    }

    private String formatClassName(String name) {
        return name.replace('.', '/') + ".class";
    }

    private void debug(String msg) {
        UtilDebug.log(64, "JARClassLoader: ", msg);
    }
}

