/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;

public class DistinguishedName
implements Name {
    private String normalizedDN = null;
    private LdapName ldapName = null;

    public DistinguishedName(String dnString) throws InvalidNameException {
        this.ldapName = new LdapName(dnString);
        this.normalizeDN();
    }

    private DistinguishedName(LdapName ldapName, String normalizedDN) {
        this.ldapName = ldapName;
        this.normalizedDN = normalizedDN;
    }

    private DistinguishedName(LdapName ldapName) {
        this.ldapName = ldapName;
        this.normalizeDN();
    }

    public Object clone() {
        return new DistinguishedName((LdapName)this.ldapName.clone(), this.normalizedDN);
    }

    public boolean equals(Object obj) {
        return obj instanceof DistinguishedName && this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        if (obj instanceof DistinguishedName) {
            return this.ldapName.compareTo(((DistinguishedName)obj).getLdapName());
        }
        return this.ldapName.compareTo(obj);
    }

    public int size() {
        return this.ldapName.size();
    }

    public boolean isEmpty() {
        return this.ldapName.isEmpty();
    }

    public Enumeration getAll() {
        return this.ldapName.getAll();
    }

    public String get(int posn) {
        return this.ldapName.get(posn);
    }

    public Name getPrefix(int posn) {
        return new DistinguishedName((LdapName)this.ldapName.getPrefix(posn));
    }

    public Name getSuffix(int posn) {
        return new DistinguishedName((LdapName)this.ldapName.getSuffix(posn));
    }

    public boolean startsWith(Name n) {
        if (n instanceof DistinguishedName) {
            return this.ldapName.startsWith(((DistinguishedName)n).getLdapName());
        }
        return this.ldapName.startsWith(n);
    }

    public boolean endsWith(Name n) {
        if (n instanceof DistinguishedName) {
            return this.ldapName.endsWith(((DistinguishedName)n).getLdapName());
        }
        return this.ldapName.endsWith(n);
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        return this.addAll(this.size(), suffix);
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        this.ldapName.addAll(posn, n);
        this.normalizeDN();
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        return this.add(this.size(), comp);
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        this.ldapName.add(posn, comp);
        this.normalizeDN();
        return this;
    }

    public Object remove(int posn) throws InvalidNameException {
        Object retObj = this.ldapName.remove(posn);
        this.normalizeDN();
        return retObj;
    }

    public String getNormalizedDN() {
        return this.normalizedDN;
    }

    public DistinguishedName getParentDN() throws InvalidNameException {
        DistinguishedName parentDN = (DistinguishedName)this.clone();
        parentDN.remove(parentDN.size() - 1);
        return parentDN;
    }

    public DistinguishedName getRDN() throws InvalidNameException {
        return (DistinguishedName)this.getSuffix(this.size() - 1);
    }

    public String toString() {
        return this.ldapName.toString();
    }

    public LdapName getLdapName() {
        return (LdapName)this.ldapName.clone();
    }

    private void normalizeDN() {
        this.normalizedDN = "";
        for (int i = this.size() - 1; i >= 0; --i) {
            if (i < this.size() - 1) {
                this.normalizedDN = this.normalizedDN + ",";
            }
            this.normalizedDN = this.normalizedDN + this.get(i).toLowerCase();
        }
    }

    public static void main(String[] args) throws Exception {
        String inDN = args[0];
        DistinguishedName originalDN = new DistinguishedName(inDN);
        DistinguishedName DN = (DistinguishedName)originalDN.clone();
        while (!DN.isEmpty()) {
            System.out.println("DN.toString(): " + DN.toString());
            System.out.println("DN.getNormalizedDN(): " + DN.getNormalizedDN());
            System.out.println("DN.size(): " + DN.size());
            DN = DN.getParentDN();
            System.out.println();
        }
        System.out.println();
        System.out.println("OriginalDN: " + originalDN);
        System.out.println("OriginalDN.toString(): " + originalDN.toString());
        System.out.println("OriginalDN.getNormalizedDN(): " + originalDN.getNormalizedDN());
        System.out.println("OriginalDN.size(): " + originalDN.size());
        System.out.println();
        for (int i = 1; i < originalDN.size(); ++i) {
            DistinguishedName curDN = (DistinguishedName)originalDN.getPrefix(i);
            System.out.println(curDN.toString());
            String rdn = curDN.get(curDN.size() - 1);
            System.out.println("RDN: " + rdn);
            System.out.println("RDN attrName: " + rdn.substring(0, rdn.indexOf("=")));
            System.out.println("RDN attrVal: " + rdn.substring(rdn.indexOf("=") + 1, rdn.length()));
            System.out.println();
        }
    }
}

