/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;

public class DirEntryReconcile {
    public static LDIFRecord getLdifDiffForSafe(LDIFRecord rec1, LDIFRecord rec2, boolean extended) {
        LDIFRecord retRecord = null;
        if (rec1 == null) {
            retRecord = null;
        } else if (rec2 == null) {
            retRecord = rec1;
        } else {
            int sz = rec1.size();
            retRecord = new LDIFRecord(rec1.getDN());
            retRecord.setChangeType(3);
            for (int iCnt = 0; iCnt < sz; ++iCnt) {
                LDIFAttribute atr = rec1.getAttribute(iCnt);
                int attrChgType = atr.getChangeType();
                String attrName = null;
                LDIFAttribute newAttr = null;
                LDIFAttribute dirAttr = null;
                if (attrChgType == 6) continue;
                attrName = atr.getName();
                newAttr = (LDIFAttribute)atr.clone();
                newAttr.setChangeType(5);
                dirAttr = rec2.getAttribute(attrName);
                if (extended) {
                    if (null != dirAttr) {
                        if (7 == attrChgType || dirAttr.isBinary()) continue;
                        String[] dirValues = dirAttr.getStringValueArray();
                        for (int jCnt = 0; jCnt < dirValues.length; ++jCnt) {
                            newAttr.removeValue(dirValues[jCnt]);
                        }
                    }
                } else if (null != dirAttr) continue;
                if (newAttr.size() == 0) continue;
                retRecord.addAttribute(newAttr);
            }
            if (0 == retRecord.size()) {
                retRecord = null;
            }
        }
        return retRecord;
    }

    public static LDIFRecord getLdifDiffForNormal(LDIFRecord rec1, LDIFRecord rec2) {
        LDIFRecord retRecord = null;
        if (rec1 == null) {
            retRecord = null;
        } else if (rec2 == null) {
            retRecord = rec1;
        } else {
            int sz = rec1.size();
            int recChgType = rec1.getChangeType();
            retRecord = new LDIFRecord(rec1.getDN());
            retRecord.setChangeType(rec1.getChangeType());
            if (recChgType != 2) {
                retRecord.setChangeType(3);
                for (int iCnt = 0; iCnt < sz; ++iCnt) {
                    LDIFAttribute atr = rec1.getAttribute(iCnt);
                    String attrName = atr.getName();
                    int attrChgType = atr.getChangeType();
                    LDIFAttribute newAttr = (LDIFAttribute)atr.clone();
                    LDIFAttribute dirAttr = rec2.getAttribute(attrName);
                    if (null != dirAttr) {
                        String[] attrValues;
                        if (dirAttr.isBinary()) continue;
                        if (6 == attrChgType) {
                            if (0 != newAttr.size()) {
                                attrValues = newAttr.getStringValueArray();
                                for (int jCnt = 0; attrValues != null && jCnt < attrValues.length; ++jCnt) {
                                    if (dirAttr.contains(attrValues[jCnt])) continue;
                                    newAttr.removeValue(attrValues[jCnt]);
                                }
                                if (0 == newAttr.size()) {
                                    continue;
                                }
                            }
                        } else {
                            attrValues = newAttr.getStringValueArray();
                            boolean foundAll = true;
                            dirAttr = (LDIFAttribute)dirAttr.clone();
                            for (int jCnt = 0; attrValues != null && jCnt < attrValues.length; ++jCnt) {
                                if (dirAttr.removeValue(attrValues[jCnt])) continue;
                                foundAll = false;
                                break;
                            }
                            if (foundAll && 0 == dirAttr.size()) continue;
                            newAttr.setChangeType(7);
                        }
                    } else {
                        if (6 == attrChgType) continue;
                        if (7 == attrChgType) {
                            if (newAttr.size() == 0) continue;
                            newAttr.setChangeType(5);
                        }
                    }
                    retRecord.addAttribute(newAttr);
                }
                if (0 == retRecord.size()) {
                    retRecord = null;
                }
            }
        }
        return retRecord;
    }
}

