/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class OIDContext
implements Cloneable,
Serializable {
    public static final String APP_IDENTIFIER = "application identifier";
    public static final String ACCESS_INTERFACE = "access interface";
    public static final String REALM_NAME = "realm name";
    public static final String ENDUSER_NAME = "enduser name";
    public static final String INITIAL_LDAP_CONTEXT = "ldap context";
    public static final String ACCESS_JNDI = "jndi";
    public static final String ACCESS_WEBSERVICE = "webservice";
    private Hashtable properties;

    public OIDContext(Hashtable properties) throws Exception {
        String access = (String)properties.get(ACCESS_INTERFACE);
        if (access.equals(ACCESS_JNDI) && (InitialLdapContext)properties.get(INITIAL_LDAP_CONTEXT) == null) {
            throw new Exception();
        }
        this.properties = (Hashtable)properties.clone();
    }

    public static OIDContext getInstance(LdapContext lCtx) throws Exception {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(ACCESS_INTERFACE, ACCESS_JNDI);
        env.put(INITIAL_LDAP_CONTEXT, lCtx);
        return new OIDContext(env);
    }

    public Object getProperty(String prop) {
        return this.properties.get(prop);
    }

    public void setProperty(String prop, String propval) {
        this.properties.put(prop, propval);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object addToEnvironment(String propName, String propVal) {
        return this.properties.put(propName, propVal);
    }
}

