/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.util;

import com.sun.jndi.ldap.BasicControl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import oracle.idm.provisioning.ProvisioningException;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.ConfigAttribute;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;

public class ProvUtil {
    private ProvUtil() {
    }

    public static HashMap getUserProvisioningStatus(LdapContext ctx, int idType, String id, Configuration prvConf) throws ProvisioningException {
        HashMap<String, String> retMap = null;
        String[] rqdAttrs = null;
        Attributes attrs = null;
        Attribute attr = null;
        rqdAttrs = new String[]{"orclUserApplnProvStatus", "orclUserApplnProvStatusDesc"};
        if (idType == Util.IDTYPE_GUID) {
            NamingEnumeration curEnum = null;
            SearchResult sr = null;
            try {
                curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "", "(orclguid=" + id + ")", 2, rqdAttrs, false);
                if (!curEnum.hasMoreElements()) {
                    throw new ProvisioningException("User does not exist - GUID = " + id);
                }
                sr = (SearchResult)curEnum.nextElement();
                attrs = sr.getAttributes();
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else if (idType == Util.IDTYPE_DN) {
            try {
                LdapName name = new LdapName(id);
                attrs = ctx.getAttributes(name, rqdAttrs);
            }
            catch (NameNotFoundException nfe) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus", nfe);
                throw new ProvisioningException("User does not exist - DN = " + id);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid identification type");
        }
        try {
            NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
            retMap = new HashMap<String, String>();
            block11: while (attrEnum.hasMore()) {
                int sz;
                String appKey;
                String attrName = null;
                String appName = null;
                String appType = null;
                String val = null;
                attr = attrEnum.next();
                val = (String)attr.get();
                attrName = attr.getID();
                int inx = attrName.indexOf(";");
                if (inx == -1) continue;
                appName = attrName.substring(inx + 1);
                if ((attrName = attrName.substring(0, inx)).equalsIgnoreCase(rqdAttrs[0])) {
                    int sz2;
                    inx = appName.indexOf(95);
                    if (inx == -1) continue;
                    appKey = null;
                    appType = appName.substring(inx + 1);
                    appName = appName.substring(0, inx);
                    appKey = appName + '_' + appType;
                    Vector apps = null;
                    try {
                        apps = prvConf.getAllApplications(ctx);
                    }
                    catch (Exception e) {
                        throw new ProvisioningException(e.getMessage());
                    }
                    int n = sz2 = apps != null ? apps.size() : 0;
                    for (int i = 0; i < sz2; ++i) {
                        Application app = (Application)apps.elementAt(i);
                        if (!app.equals(appKey)) continue;
                        retMap.put(appKey, val);
                        continue block11;
                    }
                    continue;
                }
                if (!attrName.equalsIgnoreCase(rqdAttrs[1]) || (inx = appName.indexOf(95)) == -1) continue;
                appKey = null;
                appType = appName.substring(inx + 1);
                appName = appName.substring(0, inx);
                appKey = appName + '_' + appType;
                if (val == null || val.equals("") || val.equalsIgnoreCase("null")) continue;
                String desc = val;
                int inx_desc = val.indexOf(95);
                if (inx_desc != -1) {
                    desc = val.substring(inx_desc + 1).trim();
                }
                if (desc.equals("")) continue;
                Vector apps = null;
                try {
                    apps = prvConf.getAllApplications(ctx);
                }
                catch (Exception e) {
                    throw new ProvisioningException(e.getMessage());
                }
                int n = sz = apps != null ? apps.size() : 0;
                for (int i = 0; i < sz; ++i) {
                    Application app = (Application)apps.elementAt(i);
                    if (!app.equals(appKey)) continue;
                    retMap.put(appKey + '_' + "DESC", desc);
                    continue block11;
                }
            }
            if (retMap.isEmpty()) {
                retMap = null;
            }
        }
        catch (NamingException ne) {
            UtilDebug.log(32, "ProvUtil.getProvisioningStatus", ne);
            throw new ProvisioningException(ne.getMessage());
        }
        return retMap;
    }

    public static String getUserProvisioningStatus(LdapContext ctx, int idType, String id, String appType, String appName) throws ProvisioningException {
        String retProvStatus = null;
        String appSubType = null;
        String[] rqdAttrs = null;
        Attributes attrs = null;
        Attribute attr = null;
        if (appName == null && appType == null) {
            throw new ProvisioningException("Application Name and Type Missing..");
        }
        if (appName == null) {
            appName = appType;
        }
        if (appType == null) {
            appType = appName;
        }
        appSubType = appName + '_' + appType;
        rqdAttrs = new String[]{"orclUserApplnProvStatus;" + appSubType.toLowerCase()};
        if (idType == Util.IDTYPE_GUID) {
            NamingEnumeration curEnum = null;
            SearchResult sr = null;
            try {
                curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "", "(orclguid=" + id + ")", 2, rqdAttrs, false);
                if (!curEnum.hasMoreElements()) {
                    throw new ProvisioningException("User does not exist - GUID = " + id);
                }
                sr = (SearchResult)curEnum.nextElement();
                attrs = sr.getAttributes();
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus : ", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else if (idType == Util.IDTYPE_DN) {
            try {
                LdapName name = new LdapName(id);
                attrs = ctx.getAttributes(name, rqdAttrs);
            }
            catch (NameNotFoundException nfe) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus : ", nfe);
                throw new ProvisioningException("User does not exist - DN = " + id);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus : ", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid identification type");
        }
        try {
            attr = attrs.get(rqdAttrs[0]);
            if (attr != null) {
                retProvStatus = (String)attr.get();
            } else {
                UtilDebug.log(32, "ProvUtil.getProvisioningStatus : ", "No Provisioning Status exists for " + appSubType + " ... Updating  to PENDING_UPGRADE..");
                retProvStatus = "PENDING_UPGRADE";
            }
        }
        catch (NamingException ne) {
            UtilDebug.log(32, "ProvUtil.getProvisioningStatus : ", ne);
            throw new ProvisioningException(ne.getMessage());
        }
        return retProvStatus;
    }

    public static synchronized void setUserProvisioningStatus(LdapContext ctx, int idType, String id, String appType, String appName, String provStatus, String provStatusDesc) throws ProvisioningException {
        boolean modify = false;
        String baseDn = null;
        String appSubType = null;
        String appStatusDesc = null;
        String appStatAttr = null;
        String appStatDescAttr = null;
        String appFailureCountAttr = null;
        int count = 0;
        Attributes attrs = null;
        ModificationItem[] mods = null;
        String time = "";
        if (appName == null && appType == null) {
            throw new ProvisioningException("Application Name and Type Missing..");
        }
        if (appName == null) {
            appName = appType;
        }
        if (appType == null) {
            appType = appName;
        }
        appSubType = appName + '_' + appType;
        appSubType = appSubType.toLowerCase();
        time = time + System.currentTimeMillis();
        appStatusDesc = time + '_';
        if (provStatusDesc != null) {
            appStatusDesc = appStatusDesc + provStatusDesc;
        }
        appStatAttr = "orclUserApplnProvStatus;" + appSubType;
        appStatDescAttr = "orclUserApplnProvStatusDesc;" + appSubType;
        appFailureCountAttr = "orclUserProvFailureCount;" + appSubType;
        if (idType == Util.IDTYPE_GUID) {
            NamingEnumeration curEnum = null;
            SearchResult sr = null;
            try {
                curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "", "(orclguid=" + id + ")", 2, new String[]{"orclUserProvFailureCount"}, false);
                if (!curEnum.hasMoreElements()) {
                    throw new ProvisioningException("User does not exist - GUID = " + id);
                }
                sr = (SearchResult)curEnum.nextElement();
                baseDn = sr.getNameInNamespace();
                attrs = sr.getAttributes();
                count = ProvUtil.getFailureCount(attrs);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else if (idType == Util.IDTYPE_DN) {
            baseDn = id;
            try {
                LdapName name = new LdapName(id);
                attrs = ctx.getAttributes(name);
                count = ProvUtil.getFailureCount(attrs);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid identification type");
        }
        try {
            Control[] prevControls = null;
            try {
                prevControls = ctx.getRequestControls();
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", "Unable to get the existing controls");
            }
            if (provStatus.equalsIgnoreCase("PROVISIONING_SUCCESSFUL") || provStatus.equalsIgnoreCase("PROVISIONING_IN_PROGRESS") || provStatus.equalsIgnoreCase("PROVISIONING_FAILURE") || provStatus.equalsIgnoreCase("DEPROVISIONING_IN_PROGRESS") || provStatus.equalsIgnoreCase("DEPROVISIONING_FAILURE") || provStatus.equalsIgnoreCase("DEPROVISIONING_SUCCESSFUL")) {
                try {
                    ctx.setRequestControls(new Control[]{new BasicControl("2.16.840.1.113894.1.8.10")});
                }
                catch (NamingException ne) {
                    UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", "Unable to set the Control to surpress changelog generation.." + ne.getMessage());
                }
            }
            if (provStatus.equalsIgnoreCase("PROVISIONING_FAILURE")) {
                mods = new ModificationItem[3];
                mods[2] = new ModificationItem(2, new BasicAttribute(appFailureCountAttr, String.valueOf(++count)));
            } else if (provStatus.equalsIgnoreCase("PROVISIONING_SUCCESSFUL")) {
                count = 0;
                mods = new ModificationItem[3];
                mods[2] = new ModificationItem(2, new BasicAttribute(appFailureCountAttr, String.valueOf(count)));
            } else {
                mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(appStatAttr, provStatus)), new ModificationItem(2, new BasicAttribute(appStatDescAttr, appStatusDesc))};
            }
            ctx.modifyAttributes(baseDn, mods);
            try {
                ctx.setRequestControls(prevControls);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", "Unable to unset the Control to surpress changelog generation.." + ne.getMessage());
            }
        }
        catch (SchemaViolationException sve) {
            UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", "Setting First Time Status For:(" + appSubType + ")");
            ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(appStatAttr, provStatus)), new ModificationItem(1, new BasicAttribute(appStatDescAttr, appStatusDesc)), new ModificationItem(1, new BasicAttribute(appFailureCountAttr, String.valueOf(count))), new ModificationItem(1, new BasicAttribute("objectClass", "orclUserProvStatus"))};
            try {
                ctx.modifyAttributes(baseDn, modItems);
            }
            catch (NamingException ne) {
                UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", ne);
                throw new ProvisioningException(ne.getMessage());
            }
        }
        catch (NamingException ne) {
            UtilDebug.log(32, "ProvUtil.setProvisioningStatus : ", ne);
            throw new ProvisioningException(ne.getMessage());
        }
    }

    public static String getProvStatusAttrName(Application app) {
        String appName = app.getName();
        String appType = app.getType();
        String appSubType = null;
        String appStatAttr = null;
        if (appName == null) {
            appName = appType;
        }
        if (appType == null) {
            appType = appName;
        }
        appSubType = appName + '_' + appType;
        appSubType = appSubType.toLowerCase();
        appStatAttr = "orclUserApplnProvStatus;" + appSubType;
        return appStatAttr.toLowerCase();
    }

    public static String getProvStatusDescAttrName(Application app) {
        String appName = app.getName();
        String appType = app.getType();
        String appSubType = null;
        String appStatDescAttr = null;
        if (appName == null) {
            appName = appType;
        }
        if (appType == null) {
            appType = appName;
        }
        appSubType = appName + '_' + appType;
        appSubType = appSubType.toLowerCase();
        appStatDescAttr = "orclUserApplnProvStatusDesc;" + appSubType;
        return appStatDescAttr.toLowerCase();
    }

    private static int getFailureCount(Attributes attrs) {
        int count = 0;
        try {
            String val;
            Attribute attr = attrs.get("orclUserProvFailureCount");
            String string = val = attr != null ? (String)attr.get() : null;
            if (val != null) {
                try {
                    count = Integer.parseInt(val);
                }
                catch (NumberFormatException NFE) {
                    count = 0;
                }
            }
        }
        catch (Exception ex) {
            count = 0;
        }
        return count;
    }

    private static void debug(Object obj) {
        UtilDebug.log(32, "ProvUtil : ", (String)obj);
    }

    public static String[] getAllProvisioningStatusVals() {
        String[] statusVals = new String[]{"PROVISIONING_REQUIRED", "PROVISIONING_NOT_REQUIRED", "PROVISIONING_SUCCESSFUL", "PROVISIONING_FAILURE", "PROVISIONING_IN_PROGRESS", "DEPROVISIONING_REQUIRED", "DEPROVISIONING_SUCCESSFUL", "DEPROVISIONING_FAILURE", "DEPROVISIONING_IN_PROGRESS", "PENDING_UPGRADE", "UPGRADE_IN_PROGRESS", "UPGRADE_FAILURE", "STATUS_UNKNOWN"};
        return statusVals;
    }

    public static boolean isUserProvisioned(String sts) {
        String[] provisionedStates = new String[]{"PROVISIONING_REQUIRED", "PROVISIONING_SUCCESSFUL", "PROVISIONING_IN_PROGRESS", "DEPROVISIONING_REQUIRED", "DEPROVISIONING_FAILURE", "DEPROVISIONING_IN_PROGRESS", "UPGRADE_IN_PROGRESS"};
        UtilDebug.log(32, "ProvUtil : ", "Checking whether the state means a provisioned state - " + sts);
        for (int i = 0; i < provisionedStates.length; ++i) {
            if (!sts.equalsIgnoreCase(provisionedStates[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isUserNotProvisioned(String sts) {
        String[] notProvisionedStates = new String[]{"PROVISIONING_NOT_REQUIRED", "PROVISIONING_FAILURE", "DEPROVISIONING_SUCCESSFUL", "PENDING_UPGRADE", "UPGRADE_FAILURE"};
        UtilDebug.log(32, "ProvUtil : ", "Checking whether the state means a non provisioned state - " + sts);
        for (int i = 0; i < notProvisionedStates.length; ++i) {
            if (!sts.equalsIgnoreCase(notProvisionedStates[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isStateLocked(String sts) {
        String[] lockedStates = new String[]{"PROVISIONING_REQUIRED", "PROVISIONING_IN_PROGRESS", "DEPROVISIONING_REQUIRED", "DEPROVISIONING_IN_PROGRESS", "UPGRADE_IN_PROGRESS"};
        for (int i = 0; i < lockedStates.length; ++i) {
            if (!sts.equalsIgnoreCase(lockedStates[i])) continue;
            return true;
        }
        return false;
    }

    public static String getProvisioningStatusDispValue(String sts, Locale lc) throws Exception {
        ResourceBundle resBundle = null;
        try {
            resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource", lc);
        }
        catch (Exception ex) {
            String emsg = "Unable to load resource Bundle for this locale:" + lc;
            throw new Exception(emsg);
        }
        String[] allstatues = ProvUtil.getAllProvisioningStatusVals();
        int i = 0;
        for (i = 0; i < allstatues.length && !sts.equals(allstatues[i]); ++i) {
        }
        if (i == allstatues.length) {
            return resBundle.getString("STATUS_UNKNOWN");
        }
        return resBundle.getString(sts);
    }

    public static void setNonPrintableAttrs(LdapContext lCtx, Configuration prvConfig) throws Exception {
        try {
            String attrNames = System.getProperty("oracle.idm.util.npattrs");
            if (attrNames == null) {
                attrNames = "";
            }
            attrNames = attrNames.toLowerCase();
            Vector apps = prvConfig.getAllApplications(lCtx);
            ConfigAttribute[] attrs = prvConfig.getAllBaseAttrConfig(lCtx);
            if (attrs != null) {
                for (int i = 0; i < attrs.length; ++i) {
                    String type = attrs[i].getName().toLowerCase();
                    if (attrs[i].isPrintable() || attrNames.indexOf(type) != -1) continue;
                    attrNames = attrNames + " " + type;
                }
            }
            if (apps != null) {
                int sz = apps.size();
                for (int j = 0; j < sz; ++j) {
                    Application app = (Application)apps.elementAt(j);
                    attrs = app.getAllAttributes(lCtx);
                    if (attrs == null) continue;
                    for (int i = 0; i < attrs.length; ++i) {
                        String type = attrs[i].getName().toLowerCase();
                        if (attrs[i].isPrintable() || attrNames.indexOf(type) != -1) continue;
                        attrNames = attrNames + " " + type;
                    }
                }
            }
            if (!attrNames.equals("")) {
                System.setProperty("oracle.idm.util.npattrs", attrNames);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: java oracle.idm.provisioning.util.ProvUtil set|get|getall <host> <port> <bindDn> <passwd> <appName> <appType> <idType> <0/2> <status>");
            return;
        }
        String opr = args[0];
        String hostName = args[1];
        String port = args[2];
        String bindDn = args[3];
        String passwd = args[4];
        int idType = Integer.parseInt(args[5]);
        String id = args[6];
        InitialLdapContext ctx = null;
        ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
        if (opr.equalsIgnoreCase("set")) {
            String appName = args[7];
            String appType = args[8];
            String status = args[9];
            ProvUtil.setUserProvisioningStatus(ctx, idType, id, appType, appName, status, "Unit test Sample");
        } else if (opr.equalsIgnoreCase("get")) {
            String appName = args[7];
            String appType = args[8];
            System.out.println(ProvUtil.getUserProvisioningStatus(ctx, idType, id, appType, appName));
        } else if (opr.equalsIgnoreCase("getAll")) {
            String realm = args[7];
            Configuration cfg = new Configuration(realm);
            Vector apps = cfg.getAllApplications(ctx);
            HashMap hmap = ProvUtil.getUserProvisioningStatus(ctx, idType, id, cfg);
            if (hmap != null) {
                Iterator iter = hmap.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String stat = (String)hmap.get(key);
                    System.out.println(key + " = " + stat);
                }
            }
        }
    }
}

