/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.util;

import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.IDataEntryPlugin;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.provisioning.util.DataEntryPluginAdapter;
import oracle.idm.user.IdmUser;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;

public class PreDataEntryPluginAdapter
extends DataEntryPluginAdapter {
    private static int sInstanceCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreDataEntryPluginAdapter(LdapContext lCtx, Application app, String operation) throws NoSuchPluginException, PluginException {
        String pluginName = "PRE_DATA_ENTRY_" + operation.toUpperCase();
        try {
            long startTime = System.currentTimeMillis();
            long noOfMilSec = 0L;
            this.m_dataEntryPlugin = (IDataEntryPlugin)app.getPluginInstance(lCtx, pluginName);
            noOfMilSec = System.currentTimeMillis() - startTime;
            PreDataEntryPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".getPluginInstance() - " + noOfMilSec);
        }
        catch (Exception e) {
            UtilDebug.log(32, "PreDataEntryPluginAdapter<>", e);
            throw new PluginException(e.getMessage());
        }
        if (null == this.m_dataEntryPlugin) {
            throw new NoSuchPluginException(pluginName + " not configured for (" + app.getType() + ", " + app.getName() + ")");
        }
        UtilDebug.log(32, "PreDataEntryPluginAdapter : Instantiated Plugin : ", pluginName);
        this.m_oper = operation;
        Class clazz = PreDataEntryPluginAdapter.class;
        synchronized (clazz) {
        }
        UtilDebug.log(32, "INSTANCE COUNT - " + app.getType() + "." + app.getName() + "#Plugin PRE DATA ENTRY " + this.m_oper, ++sInstanceCount + "");
    }

    public PluginStatus process(ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserAttr, ModPropertySet appUserAttr) throws PluginException {
        if (appCtx == null || appCtx.getApplication() == null) {
            throw new PluginException("NULL AppContext or Application Passed..");
        }
        appCtx.setCallWhen("PRE_DATA_ENTRY");
        Application app = appCtx.getApplication();
        UtilDebug.log(32, "PreDataEntryPluginAdapter: ", "=============Invoking For Application (" + appCtx.getApplication().getName() + ")=============");
        UtilDebug.log(32, "PreDataEntryPluginAdapter.process:", "AppCtx :" + appCtx);
        UtilDebug.log(32, "PreDataEntryPluginAdapter.process:", "IdmUser: " + idmUser);
        UtilDebug.log(32, "PreDataEntryPluginAdapter.process: ", "BasePropSet: " + baseUserAttr.getModProperty());
        UtilDebug.log(32, "PreDataEntryPluginAdapter.process: ", "appUserAttr: " + (appUserAttr != null ? appUserAttr.getModProperty() : null));
        UtilDebug.log(32, "PreDataEntryPluginAdapter", "*****Control Passing over to the PRE DATA ENTRY Plug in ******");
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        PluginStatus status = this.m_dataEntryPlugin.process(appCtx, idmUser, baseUserAttr, appUserAttr);
        noOfMilSec = System.currentTimeMillis() - startTime;
        PreDataEntryPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".process() - " + noOfMilSec);
        UtilDebug.log(32, "PreDataEntryPluginAdapter: ", "*****Control Back from the PRE DATA ENTRY Plug in ******");
        UtilDebug.log(32, "=============PreDataEntryPluginAdapter: ", "END=======================");
        return status;
    }

    static void debug(Object o) {
        UtilDebug.log(32, "PreDataEntryPluginAdapter : ", o);
    }
}

