/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.util;

import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.IDataAccessPlugin;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.user.IdmUser;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.UtilDebug;

public class DataAccessPluginAdapter {
    protected IDataAccessPlugin m_dataAccessPlugin = null;

    protected DataAccessPluginAdapter() {
    }

    public DataAccessPluginAdapter(LdapContext lCtx, Application app) throws NoSuchPluginException, PluginException {
        String pluginName = "DATA_ACCESS";
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        try {
            DataAccessPluginAdapter.debug("Checking for DATA ACCESS Plugin....");
            this.m_dataAccessPlugin = (IDataAccessPlugin)app.getPluginInstance(lCtx, pluginName);
            noOfMilSec = System.currentTimeMillis() - startTime;
            DataAccessPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".getPluginInstance() - " + noOfMilSec);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage());
        }
        if (null == this.m_dataAccessPlugin) {
            throw new NoSuchPluginException(pluginName + " not configured for (" + app.getType() + ", " + app.getName() + ")");
        }
    }

    public PluginStatus process(ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserAttr, ModPropertySet appUserAttr) throws PluginException {
        DataAccessPluginAdapter.debug("********************* Process Method ************************");
        DataAccessPluginAdapter.debug("**** App Context ****");
        DataAccessPluginAdapter.debug(appCtx);
        DataAccessPluginAdapter.debug("**** IdmUser Obj ****");
        DataAccessPluginAdapter.debug(idmUser);
        DataAccessPluginAdapter.debug("**** Base User Attr ****");
        DataAccessPluginAdapter.debug(baseUserAttr);
        DataAccessPluginAdapter.debug("**** App User Attr ****");
        DataAccessPluginAdapter.debug(appUserAttr);
        DataAccessPluginAdapter.debug("***** Invoking the process method *******");
        Application app = appCtx.getApplication();
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        PluginStatus status = this.m_dataAccessPlugin.process(appCtx, idmUser, baseUserAttr, appUserAttr);
        noOfMilSec = System.currentTimeMillis() - startTime;
        DataAccessPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".process() - " + noOfMilSec);
        DataAccessPluginAdapter.debug("***** Control Back from the Plug in ******");
        return status;
    }

    public PropertySet getAppUserData(ApplicationContext appCtx, IdmUser idmUser, String[] reqAttrs) throws PluginException {
        DataAccessPluginAdapter.debug("********************* getAppUserData ************************");
        DataAccessPluginAdapter.debug("**** App Context ****");
        DataAccessPluginAdapter.debug(appCtx);
        DataAccessPluginAdapter.debug("**** IdmUser Obj ****");
        DataAccessPluginAdapter.debug(idmUser);
        Application app = appCtx.getApplication();
        if (reqAttrs == null) {
            LdapContext lCtx = (LdapContext)appCtx.getDirCtx();
            try {
                reqAttrs = app.getAllAttributeNames(lCtx);
            }
            catch (Exception ex) {
                DataAccessPluginAdapter.debug("Error while retrieving application attribute names");
                DataAccessPluginAdapter.debug(ex);
            }
        }
        DataAccessPluginAdapter.debug("******** Invoking getAppUserData *******");
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        PropertySet prop = this.m_dataAccessPlugin.getAppUserData(appCtx, idmUser, reqAttrs);
        noOfMilSec = System.currentTimeMillis() - startTime;
        DataAccessPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".getAppUserData() - " + noOfMilSec);
        DataAccessPluginAdapter.debug("***** Control Back from the Plug in ******");
        return prop;
    }

    private static void debug(Object o) {
        UtilDebug.log(32, "DataAccessPluginAdapter: ", o);
    }
}

