/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.io.XmlPrintWriter;
import oracle.idm.io.XmlPrintable;
import oracle.idm.provisioning.ProvisioningException;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.user.IdmUser;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserFactoryBuilder;
import oracle.idm.util.Transitions;
import oracle.idm.util.progress.ProgressEvent;
import oracle.idm.util.progress.ProgressProcessor;
import oracle.idm.util.progress.info.PercentInfo;
import oracle.idm.util.progress.info.StatusInfo;
import oracle.idm.util.progress.info.StepInfo;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;

public class BulkProvision
extends ProgressProcessor {
    public static final Transitions TRANSITIONS = Transitions.unmodifiableTransitions((String[][])new String[][]{{null, "started"}, {"started", "stopped"}, {"started", "suspended"}, {"started", "finished"}, {"started", "aborted"}, {"started", "timedout"}, {"suspended", "stopped"}, {"suspended", "resumed"}, {"suspended", "finished"}, {"suspended", "aborted"}, {"suspended", "timedout"}, {"resumed", "stopped"}, {"resumed", "suspended"}, {"resumed", "finished"}, {"resumed", "aborted"}, {"resumed", "timedout"}});
    private LdapContext m_ldapCtx = null;
    private String m_realmName = null;
    private InputStream m_inputStream = null;
    private OutputStream m_failedStream = null;
    private PrintStream m_logStream = null;
    private boolean m_opennedStreams = false;
    private boolean m_continueOnFailure = true;
    private long m_inputFileLength = 0L;
    private long m_inputFileReadCount = 0L;
    private int m_totalCount = 0;
    private int m_failureCount = 0;
    private String m_inputEnc = "UTF-8";
    private ResourceBundle m_resBundle = null;

    public BulkProvision(LdapContext ldapCtx, String realmName, InputStream inputStream, OutputStream failedStream, PrintStream logStream) {
        super(TRANSITIONS);
        if (inputStream == null) {
            new IllegalArgumentException("Invalid argument. Null passed");
        }
        this.m_ldapCtx = ldapCtx;
        this.m_realmName = realmName;
        this.m_inputStream = inputStream;
        this.m_failedStream = failedStream;
        this.m_logStream = logStream;
        UtilDebug.setPrintStream(this.m_logStream);
        UtilDebug.setDebugMode(32);
    }

    public BulkProvision(LdapContext ldapCtx, String realmName, InputStream inputStream, String inEnc, OutputStream failedStream, PrintStream logStream) {
        this(ldapCtx, realmName, inputStream, failedStream, logStream);
        this.m_inputEnc = inEnc;
    }

    public BulkProvision(LdapContext ldapCtx, String realmName, String inputFile, String failedFile, String logFile) throws IOException {
        super(TRANSITIONS);
        if (inputFile == null) {
            new IllegalArgumentException("Invalid argument. Null passed");
        }
        this.m_ldapCtx = ldapCtx;
        this.m_realmName = realmName;
        this.m_inputFileLength = new File(inputFile).length();
        this.m_inputStream = new BufferedInputStream(new FileInputStream(inputFile));
        this.m_failedStream = new BufferedOutputStream(new FileOutputStream(failedFile));
        this.m_logStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)));
        UtilDebug.setPrintStream(this.m_logStream);
        UtilDebug.setDebugMode(32);
        this.m_opennedStreams = true;
    }

    public BulkProvision(LdapContext ldapCtx, String realmName, String inputFile, String failedFile, String logFile, Locale l) throws IOException {
        this(ldapCtx, realmName, inputFile, failedFile, logFile);
        try {
            this.m_resBundle = ResourceBundle.getBundle("oracle.idm.nls.Provisioning", l);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
    }

    public BulkProvision(LdapContext ldapCtx, String realmName, String inputFile, String inEnc, String failedFile, String logFile) throws IOException {
        this(ldapCtx, realmName, inputFile, failedFile, logFile);
        this.m_inputEnc = inEnc;
    }

    private void cleanup() throws IOException {
        if (this.m_opennedStreams) {
            this.m_inputStream.close();
            this.m_failedStream.close();
            this.m_logStream.close();
        }
    }

    public boolean getContinueOnFailure() {
        return this.m_continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.m_continueOnFailure = continueOnFailure;
    }

    public int getTotalCount() {
        return this.m_totalCount;
    }

    public int getSuccessCount() {
        return this.m_totalCount - this.m_failureCount;
    }

    public int getFailureCount() {
        return this.m_failureCount;
    }

    public void start() throws IOException, ProvisioningException, Exception {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public void suspend() {
        super.suspend();
    }

    public void resume() {
        super.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(boolean quiet) throws IOException, ProvisioningException, Exception {
        Object env = null;
        UserFactory factory = null;
        LDIFRecord lRec = null;
        LDIFReader ldifReader = null;
        LDIFWriter ldifWriter = null;
        if (!this.start(quiet)) {
            return;
        }
        UtilDebug.setDebugMode(32);
        try {
            Configuration prvConfig = new Configuration(this.m_realmName);
            factory = UserFactoryBuilder.createUserFactory((DirContext)this.m_ldapCtx, prvConfig);
            System.setProperty("oracle.idm.util.npattrs", "userpassword");
            ProvUtil.setNonPrintableAttrs(this.m_ldapCtx, prvConfig);
        }
        catch (Throwable throwable) {
            UtilDebug.log(32, "BulkProvision.process : ", BulkProvision.getMessage((Throwable)throwable));
            this.cleanup();
            this.throwErrorOrException(throwable);
        }
        UtilDebug.log(32, "BulkProvision.process : ", "JndiUserFactory created successfully...");
        ldifReader = new LDIFReader(this.m_inputStream, this.m_inputEnc);
        ldifWriter = new LDIFWriter(this.m_failedStream, this.m_inputEnc);
        while (true) {
            this.continuing();
            this.block("suspended");
            if (this.isFinal()) {
                this.cleanup();
                return;
            }
            if (this.hasTimedout()) {
                this.cleanup();
                this.timeout(quiet);
                return;
            }
            ++this.m_totalCount;
            try {
                lRec = ldifReader.nextRecord();
                if (lRec == null) {
                    --this.m_totalCount;
                    break;
                }
            }
            catch (Throwable throwable) {
                ++this.m_failureCount;
                UtilDebug.log(32, "BulkProvision.process : ", BulkProvision.getMessage((Throwable)throwable));
                this.cleanup();
                this.throwErrorOrException(throwable);
            }
            this.m_inputFileReadCount = ldifReader.getReadCount();
            int recChgType = lRec.getChangeType();
            String dn = lRec.getDN();
            ModPropertySet mpSet = new ModPropertySet(recChgType);
            int sz = lRec.size();
            for (int i = 0; i < sz; ++i) {
                LDIFAttribute attr = lRec.getAttribute(i);
                mpSet.addProperty(attr.getChangeType(), attr);
            }
            ProvisioningException createException = null;
            try {
                switch (recChgType) {
                    case 1: {
                        IdmUser createdUser = factory.createUser(lRec.getDN(), mpSet);
                        dn = createdUser.getDN();
                        UtilDebug.log(32, "BulkProvision.process : ", "Created User - " + dn);
                        break;
                    }
                    case 3: {
                        factory.modifyUserByDN(dn, mpSet);
                        UtilDebug.log(32, "BulkProvision.process : ", "Modified User - " + dn);
                        break;
                    }
                    case 2: {
                        String orclGuid = mpSet.getModPropertyValue("orclguid");
                        if (orclGuid != null) {
                            factory.deleteUser(orclGuid, dn);
                        } else {
                            factory.deleteUserByDN(dn);
                        }
                        UtilDebug.log(32, "BulkProvision.process : ", "Deleted User - " + dn);
                    }
                }
            }
            catch (Exception exception) {
                ++this.m_failureCount;
                UtilDebug.log(32, "BulkProvision.process : ", exception);
                createException = new ProvisioningException(BulkProvision.getMessage((Throwable)exception));
                ldifWriter.writeComment(BulkProvision.getMessage((Throwable)exception));
                LDIFRecord lrecBad = mpSet.getModProperty();
                lrecBad.setDN(dn);
                ldifWriter.writeEntry(lrecBad);
                ldifWriter.newLine();
                if (!this.m_continueOnFailure) {
                    this.cleanup();
                    throw createException;
                }
            }
            catch (Throwable throwable) {
                ++this.m_failureCount;
                UtilDebug.log(32, "BulkProvision.process : ", BulkProvision.getMessage((Throwable)throwable));
                this.cleanup();
                this.throwErrorOrException(throwable);
            }
            BulkProvision bulkProvision = this;
            synchronized (bulkProvision) {
                ProgressEvent event = this.getProgressEvent();
                if (createException != null) {
                    event.setStatusInfo(new StatusInfo("error"));
                    event.setCause((Throwable)createException);
                }
                this.sendProgressEvent(event);
            }
        }
        this.m_inputFileReadCount = this.m_inputFileLength;
        this.cleanup();
        this.finish(quiet);
    }

    protected String getProgressEventMessage() {
        String retStr = null;
        if (this.m_resBundle != null) {
            retStr = this.m_resBundle.getString("PROCESSED_USERS");
            MessageFormat msgFormatter = new MessageFormat(retStr);
            Object[] args = new Object[]{new Integer(this.m_totalCount)};
            retStr = msgFormatter.format(args);
        } else {
            retStr = "Processed " + this.m_totalCount + " users.";
        }
        return retStr;
    }

    protected StepInfo getProgressEventStepInfo() {
        return new StepInfo(this.m_totalCount);
    }

    protected PercentInfo getProgressEventPercentInfo() {
        if (this.m_inputFileLength == 0L) {
            return null;
        }
        return new PercentInfo(100.0f * (float)this.m_inputFileReadCount / (float)this.m_inputFileLength);
    }

    protected Object getProgressEventProgressInfo() {
        return new ProgressInfo(this.getTotalCount(), this.getSuccessCount(), this.getFailureCount());
    }

    private static void debug(Object o) {
        System.out.println(o);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            System.out.println("Usage: java oracle.ldap.util.provisioning.BulkProvision <realm> <host> <port> <bindDn> <passwd> <inputFile>");
            return;
        }
        String realmName = args[0];
        String hostName = args[1];
        String port = args[2];
        String bindDn = args[3];
        String passwd = args[4];
        String inputFile = args[5];
        String failedFile = inputFile + ".failed";
        String logFile = inputFile + ".log";
        InitialLdapContext ctx = null;
        BulkProvision blkProv = null;
        BulkProvision.debug("Connecting to " + hostName + ":" + port);
        ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
        BulkProvision.debug("Connected.");
        blkProv = new BulkProvision((LdapContext)ctx, realmName, inputFile, failedFile, logFile);
        blkProv.setContinueOnFailure(true);
        blkProv.start();
        ctx.close();
    }

    public static class ProgressInfo
    implements XmlPrintable {
        int totalCount;
        int successCount;
        int failureCount;

        public ProgressInfo(int totalCount, int successCount, int failureCount) {
            this.totalCount = totalCount;
            this.successCount = successCount;
            this.failureCount = failureCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public int getFailureCount() {
            return this.failureCount;
        }

        public void xprint(XmlPrintWriter out) {
            out.iprint("<ProgressInfo");
            out.print(" totalCount=\"" + this.totalCount + "\"");
            out.print(" successCount=\"" + this.successCount + "\"");
            out.print(" failureCount=\"" + this.failureCount + "\"");
            out.println("/>");
        }

        public String toString() {
            return "{totalCount=" + this.totalCount + ", " + "successCount=" + this.successCount + ", " + "failureCount=" + this.failureCount + "}";
        }
    }
}

