/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.tools;

import java.io.IOException;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.ProvisioningException;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.util.Transitions;
import oracle.idm.util.progress.ProgressProcessor;
import oracle.idm.util.progress.info.PercentInfo;
import oracle.idm.util.progress.info.StatusInfo;
import oracle.idm.util.progress.info.StepInfo;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;

public class BulkProvStatusUpdate
extends ProgressProcessor {
    static final Transitions TRANSITIONS = Transitions.unmodifiableTransitions((String[][])new String[][]{{null, "started"}, {"started", "stopped"}, {"started", "suspended"}, {"started", "finished"}, {"started", "aborted"}, {"started", "timedout"}, {"suspended", "stopped"}, {"suspended", "resumed"}, {"suspended", "finished"}, {"suspended", "aborted"}, {"suspended", "timedout"}, {"resumed", "stopped"}, {"resumed", "suspended"}, {"resumed", "finished"}, {"resumed", "aborted"}, {"resumed", "timedout"}});
    private String m_realmName = null;
    private LdapContext m_ldapCtx = null;
    private Application[] m_apps = null;
    private String m_status = null;
    private String m_statusDesc = null;
    private int m_nUsers = 0;
    private boolean m_continueOnFailure = true;
    private Subscriber m_subscriber = null;

    public BulkProvStatusUpdate(LdapContext ldapCtx, String realmName, Application[] apps, String status, String statusDesc) throws ProvisioningException {
        super(TRANSITIONS);
        if (this.m_apps == null || this.m_ldapCtx == null || this.m_status == null) {
            new IllegalArgumentException("Invalid argument. Null passed");
        }
        this.m_realmName = realmName;
        this.m_apps = apps;
        this.m_ldapCtx = ldapCtx;
        this.m_status = status;
        this.m_statusDesc = statusDesc;
        RootOracleContext roc = null;
        String realmDn = null;
        String[] aList = new String[]{"orclCommonUserSearchBase"};
        int subsType = this.m_realmName == null ? Util.IDTYPE_DEFAULT : Util.IDTYPE_SIMPLE;
        try {
            roc = new RootOracleContext((DirContext)this.m_ldapCtx, "");
            this.m_subscriber = roc.getSubscriber(this.m_ldapCtx, subsType, this.m_realmName, aList);
            realmDn = this.m_subscriber.getDN(this.m_ldapCtx);
            if (subsType == Util.IDTYPE_DEFAULT && realmDn != null) {
                this.m_realmName = Util.getAttrValueOfRDN(Util.getRDN(realmDn));
            }
        }
        catch (UtilException ue) {
            throw new ProvisioningException(ue.getMessage());
        }
    }

    public void start() throws IOException, ProvisioningException, Exception {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public void suspend() {
        super.suspend();
    }

    public void resume() {
        super.resume();
    }

    private void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(boolean quiet) throws IOException, ProvisioningException {
        reqAttrs = null;
        searchBases = null;
        if (!this.start(quiet)) {
            return;
        }
        reqAttrs = new String[]{};
        searchBases = this.m_subscriber.getUserSearchBase();
        for (i = 0; i < searchBases.length; ++i) {
            BulkProvStatusUpdate.debug(searchBases[i]);
        }
        i = 0;
        block11: while (true) {
            if (i >= this.m_apps.length) {
                this.finish(quiet);
                return;
            }
            this.continuing();
            this.block("suspended");
            if (this.isFinal()) {
                this.cleanup();
                return;
            }
            if (this.hasTimedout()) {
                this.cleanup();
                this.timeout(quiet);
                return;
            }
            appStatAttr = null;
            appName = null;
            appType = null;
            sCtl = null;
            appException = null;
            appType = this.m_apps[i].getType().toUpperCase();
            appName = this.m_apps[i].getName().toUpperCase();
            appStatAttr = "orclUserApplnProvStatus;" + appName + '_' + appType;
            BulkProvStatusUpdate.debug(appStatAttr);
            sCtl = null;
            sCtl = new SearchControls(2, 500L, 0, reqAttrs, false, false);
            j = 0;
            while (true) {
                block28: {
                    block30: {
                        if (j >= searchBases.length) break block30;
                        this.continuing();
                        this.block("suspended");
                        if (this.isFinal()) {
                            this.cleanup();
                            return;
                        }
                        if (this.hasTimedout()) {
                            this.cleanup();
                            this.timeout(quiet);
                            return;
                        }
                        users = null;
                        searchFilter = null;
                        searchException = null;
                        searchFilter = "(&(objectClass=InetOrgPerson)(!(" + appStatAttr + "=*)))";
                        BulkProvStatusUpdate.debug(searchFilter);
                        try {}
                        catch (NamingException ne) {
                            BulkProvStatusUpdate.debug(ne);
                            searchException = new ProvisioningException(ne.getMessage());
                            if (!this.m_continueOnFailure) {
                                this.cleanup();
                                throw searchException;
                            }
                            var15_17 = this;
                            synchronized (var15_17) {
                                event = this.getProgressEvent();
                                if (searchException != null) {
                                    event.setStatusInfo(new StatusInfo("warning"));
                                    event.setCause((Throwable)searchException);
                                }
                                this.sendProgressEvent(event);
                                break block28;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    System.out.println(this.m_nUsers);
                    ++i;
                    continue block11;
lbl-1000:
                    // 1 sources

                    {
                        while (true) {
                            try {}
                            catch (SizeLimitExceededException slee) {
                                continue;
                            }
                            break;
                        }
                    }
                    while ((users = this.m_ldapCtx.search(searchBases[j], searchFilter, sCtl)).hasMore()) {
                        while (users.hasMore()) {
                            block29: {
                                this.continuing();
                                this.block("suspended");
                                if (this.isFinal()) {
                                    this.cleanup();
                                    return;
                                }
                                if (this.hasTimedout()) {
                                    this.cleanup();
                                    this.timeout(quiet);
                                    return;
                                }
                                sr = null;
                                userDn = null;
                                userException = null;
                                sr = users.next();
                                userDn = sr.getName() + ", " + searchBases[j];
                                try {
                                    ProvUtil.setUserProvisioningStatus(this.m_ldapCtx, Util.IDTYPE_DN, userDn, appType, appName, this.m_status, this.m_statusDesc);
                                    ++this.m_nUsers;
                                }
                                catch (ProvisioningException pe) {
                                    BulkProvStatusUpdate.debug(pe);
                                    userException = new ProvisioningException(BulkProvStatusUpdate.getMessage((Throwable)pe));
                                    if (this.m_continueOnFailure) break block29;
                                    this.cleanup();
                                    throw userException;
                                }
                            }
                            var17_19 = this;
                            synchronized (var17_19) {
                                event = this.getProgressEvent();
                                if (userException != null) {
                                    event.setStatusInfo(new StatusInfo("error"));
                                    event.setCause((Throwable)userException);
                                }
                                this.sendProgressEvent(event);
                            }
                        }
                    }
                }
                ++j;
            }
            break;
        }
    }

    protected String getProgressEventMessage() {
        return "Processed " + this.m_nUsers + " users.";
    }

    protected StepInfo getProgressEventStepInfo() {
        return new StepInfo(this.m_nUsers);
    }

    protected PercentInfo getProgressEventPercentInfo() {
        return null;
    }

    private static void debug(Object o) {
        System.out.println(o);
    }

    public boolean getContinueOnFailure() {
        return this.m_continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.m_continueOnFailure = continueOnFailure;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 7) {
            System.out.println("Usage: java oracle.idm.provisioning.tools.BulkProvStatusUpdate <realm> <host> <port> <bindDn> <passwd> <appName> <appType>");
            return;
        }
        String realmName = args[0];
        String hostName = args[1];
        String port = args[2];
        String bindDn = args[3];
        String passwd = args[4];
        String appName = args[5];
        String appType = args[6];
        InitialLdapContext ctx = null;
        BulkProvStatusUpdate blkProvStatUpdate = null;
        Application[] apps = new Application[]{new Application(appName, appType)};
        BulkProvStatusUpdate.debug("Connecting to " + hostName + ":" + port);
        ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
        blkProvStatUpdate = new BulkProvStatusUpdate(ctx, realmName, apps, "PROVISIONING_REQUIRED", "Bulk Update");
        blkProvStatUpdate.start();
        BulkProvStatusUpdate.debug("Connected.");
        ctx.close();
    }
}

