/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.provpolicy;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.idm.policy.IPolicy;
import oracle.idm.policy.IPolicyTrusteeCollection;
import oracle.idm.policy.PolicyException;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.ApprovalPolicyManager;
import oracle.ldap.util.UtilDebug;

public class PolicyManager {
    public static String APPROVAL_POLICY = "approval_policy";
    private DirContext m_ctx = null;
    private String m_type = null;
    private ApprovalPolicyManager m_approvalMgr = new ApprovalPolicyManager();

    public void setOperationType(String type) throws PolicyException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(type)) {
            String msg = "Policy  type " + type + " not supported";
            UtilDebug.log(127, "PolicyManager:setOperationType:", msg);
            throw new PolicyException(msg);
        }
        this.m_type = type;
    }

    public void setDirContext(DirContext ctx) {
        if (ctx != null) {
            this.m_ctx = ctx;
        }
        this.m_approvalMgr.setDirContext(ctx);
    }

    public List getPolicyCollection(String resourceId) throws PolicyException, NamingException {
        ArrayList rtval = null;
        if (APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            rtval = this.m_approvalMgr.getApprovalPolicies(resourceId);
            if (rtval == null) {
                rtval = new ArrayList();
            }
        } else {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:getPolicyCollection:", msg);
            throw new PolicyException(msg);
        }
        return rtval;
    }

    public IPolicy getPolicy(String id) throws PolicyException, NamingException {
        ApprovalPolicy rtval = null;
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:getPolicy:", msg);
            throw new PolicyException(msg);
        }
        rtval = this.m_approvalMgr.getApprovalPolicy(id);
        return rtval;
    }

    public List getTrusteeCollection(String policyid) throws PolicyException, NamingException {
        ArrayList rtval = null;
        if (APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            rtval = this.m_approvalMgr.getApprovers(policyid);
            if (rtval == null) {
                rtval = new ArrayList();
            }
        } else {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:getTrusteeCollection:", msg);
            throw new PolicyException(msg);
        }
        return rtval;
    }

    public List getTrusteeCollectionByProperty(String policyid, String propname, String val) throws PolicyException, NamingException {
        ArrayList rtval = null;
        if (APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            rtval = this.m_approvalMgr.getApproversByProperty(policyid, propname, val);
            if (rtval == null) {
                rtval = new ArrayList();
            }
        } else {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:getTrusteeCollectionByProperty:", msg);
            throw new PolicyException(msg);
        }
        return rtval;
    }

    public void modifyPolicy(IPolicy policy) throws PolicyException, NamingException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:modifyPolicy:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.modifyApprovalPolicy(policy);
    }

    public void deletePolicy(IPolicy policy) throws PolicyException, NamingException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:deletePolicy:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.deleteApprovalPolicy(policy.getKey());
    }

    public String createPolicy(String resourceId, IPolicy policy, List trustees) throws PolicyException, NamingException {
        String rtval = null;
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:createPolicy:", msg);
            throw new PolicyException(msg);
        }
        rtval = this.m_approvalMgr.createApprovalPolicy(resourceId, policy, trustees);
        return rtval;
    }

    public void modifyTrustees(String policyuid, IPolicyTrusteeCollection trustees) throws PolicyException, NamingException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:modifyTrustees:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.modifyTrustees(policyuid, trustees, false);
    }

    public void addTrustees(String policyuid, IPolicyTrusteeCollection trustees) throws PolicyException, NamingException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:addTrustees:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.addTrustees(policyuid, trustees);
    }

    public void validatePolicy(IPolicy policy) throws PolicyException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:validatePolicy:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.validatePolicy(policy);
    }

    public void validateTrusteeCollection(List trustees) throws PolicyException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:validateTrusteeCollection:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.validateTrusteeCollection(trustees);
    }

    private void deleteTrustees(String policyuid, IPolicyTrusteeCollection trustees) throws PolicyException, NamingException {
        if (!APPROVAL_POLICY.equalsIgnoreCase(this.m_type)) {
            String msg = "Policy  type " + this.m_type + " not supported";
            UtilDebug.log(127, "PolicyManager:addTrustees:", msg);
            throw new PolicyException(msg);
        }
        this.m_approvalMgr.deleteTrustees(policyuid, trustees);
    }
}

