/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.plugin;

public class PluginStatus {
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    private String m_execStatus = null;
    private int m_errCode = 0;
    private String m_desc = null;
    private String m_provStatus = null;
    private Object m_callBackCtx = null;
    private Object m_pluginReturnObject = null;

    public PluginStatus(String execStatus, int errCode) {
        if (execStatus == null || !execStatus.equalsIgnoreCase(FAILURE) && !execStatus.equalsIgnoreCase(SUCCESS)) {
            throw new IllegalArgumentException("Invalid execution status");
        }
        this.m_execStatus = execStatus;
        this.m_errCode = errCode;
    }

    public PluginStatus(String execStatus, String desc, String provStatus) {
        if (execStatus == null || !execStatus.equalsIgnoreCase(FAILURE) && !execStatus.equalsIgnoreCase(SUCCESS)) {
            throw new IllegalArgumentException("Invalid execution status");
        }
        this.m_execStatus = execStatus;
        this.m_desc = desc;
        if (!(provStatus == null || provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED") || provStatus.equalsIgnoreCase("PROVISIONING_NOT_REQUIRED") || provStatus.equalsIgnoreCase("PROVISIONING_SUCCESSFUL") || provStatus.equalsIgnoreCase("PROVISIONING_FAILURE") || provStatus.equalsIgnoreCase("PROVISIONING_IN_PROGRESS") || provStatus.equalsIgnoreCase("DEPROVISIONING_REQUIRED") || provStatus.equalsIgnoreCase("DEPROVISIONING_FAILURE") || provStatus.equalsIgnoreCase("DEPROVISIONING_SUCCESSFUL") || provStatus.equalsIgnoreCase("DEPROVISIONING_IN_PROGRESS"))) {
            throw new IllegalArgumentException("Invalid provisioning status");
        }
        this.m_provStatus = provStatus;
    }

    public void setErrCode(int errCode) {
        this.m_errCode = errCode;
    }

    public void setCallBackCtx(Object callBackCtx) {
        this.m_callBackCtx = callBackCtx;
    }

    public String getExecStatus() {
        return this.m_execStatus;
    }

    public int getErrCode() {
        return this.m_errCode;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public void setDesc(String desc) {
        this.m_desc = desc;
    }

    public String getProvStatus() {
        return this.m_provStatus;
    }

    public void setProvStatus(String provStatus) {
        this.m_provStatus = provStatus;
    }

    private Object getCallBackCtx() {
        return this.m_callBackCtx;
    }

    public Object getPluginReturnObject() {
        return this.m_pluginReturnObject;
    }

    public void setPluginReturnObject(Object retobj) {
        this.m_pluginReturnObject = retobj;
    }
}

