/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.plugin;

import java.io.PrintStream;
import java.util.Locale;
import javax.naming.directory.DirContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.ldap.util.UtilDebug;

public class ApplicationContext {
    public static final String PRE_DATA_ENTRY = "PRE_DATA_ENTRY";
    public static final String POST_DATA_ENTRY = "POST_DATA_ENTRY";
    public static final String DATA_ACCESS = "DATA_ACCESS";
    public static final String PRE_EVENT_DELIVERY = "PRE_EVENT_DELIVERY";
    public static final String INTERACTIVE_MODE = "INTERACTIVE_MODE";
    public static final String AUTOMATIC_MODE = "AUTOMATIC_MODE";
    public static final String OP_CREATE = "CREATE";
    public static final String OP_MODIFY = "MODIFY";
    public static final String OP_DELETE = "DELETE";
    private DirContext m_dirCtx = null;
    private Application m_appln = null;
    private String m_evtId = null;
    private Object m_callBackCtx = null;
    private Locale m_clientLocale = null;
    private String m_callMode = null;
    private String m_callOp = null;
    private String m_callWhen = null;
    private PrintStream m_dbg = null;
    private String mGuid = null;
    private boolean m_debugEnabled = false;

    public ApplicationContext(DirContext dirCtx, Application appln) {
        this.m_dirCtx = dirCtx;
        this.m_appln = appln;
    }

    public ApplicationContext(DirContext dirCtx, Application appln, PrintStream dbg) {
        this.m_dirCtx = dirCtx;
        this.m_appln = appln;
        this.m_dbg = dbg;
    }

    public DirContext getDirCtx() {
        return this.m_dirCtx;
    }

    public Application getApplication() {
        return this.m_appln;
    }

    public void setClientLocale(Locale clientLocale) {
        this.m_clientLocale = clientLocale;
    }

    public Locale getClientLocale() {
        return this.m_clientLocale;
    }

    public void setEventId(String evtId) {
        this.m_evtId = evtId;
    }

    public String getEventId() {
        return this.m_evtId;
    }

    public String getCallMode() {
        return this.m_callMode;
    }

    public String getCallOp() {
        return this.m_callOp;
    }

    public String getCallWhen() {
        return this.m_callWhen;
    }

    public void setCallMode(String mode) {
        this.m_callMode = mode;
    }

    public void setCallOp(String op) {
        this.m_callOp = op;
    }

    public void setCallWhen(String when) {
        this.m_callWhen = when;
    }

    public void setGuid(String guid) {
        this.mGuid = guid;
    }

    public String getGuid() {
        return this.mGuid;
    }

    public void setCallBackCtx(Object callBackCtx) {
        this.m_callBackCtx = callBackCtx;
    }

    public Object getCallBackCtx() {
        return this.m_callBackCtx;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.m_debugEnabled = debugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.m_debugEnabled;
    }

    public void log(String msg) {
        UtilDebug.log(32, "AppContextLog: ", msg);
    }

    private void log(int dbgmode, String msg) {
        UtilDebug.log(dbgmode, "AppContextLog: ", msg);
    }

    public void log(Exception e) {
        UtilDebug.log(32, "SessionId " + this.m_evtId, e);
    }

    public String toString() {
        String NL = System.getProperty("line.separator");
        String retString = NL + " Application   : (" + this.m_appln.getName() + "," + this.m_appln.getType() + ")" + NL + " Call Back Ctx : " + this.m_callBackCtx + NL + " Client Locale : " + this.m_clientLocale + NL + " Call Mode     : " + this.m_callMode + NL + " Call When     : " + this.m_callWhen + NL + " Call OP       : " + this.m_callOp + NL + " Debug Enabled : " + this.m_debugEnabled + NL;
        return retString;
    }
}

