/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.event;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.idm.provisioning.event.Event;
import oracle.idm.provisioning.event.PlsqlAttr;
import oracle.idm.provisioning.event.PlsqlAttrVal;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class PlsqlEvent
extends Event
implements ORAData,
ORADataFactory {
    private String m_objType = null;
    static final PlsqlEvent _PlsqlEventFactory = new PlsqlEvent();
    ARRAY m_attrs = null;
    private String m_schemaName = "";
    public static final String SQL_NAME_LDAP_ATTR_VALUE = "LDAP_ATTR_VALUE_V3";
    public static final String SQL_NAME_LDAP_ATTR_VALUE_LIST = "LDAP_ATTR_VALUE_LIST_V3";
    public static final String SQL_NAME_LDAP_ATTR = "LDAP_ATTR_V3";
    public static final String SQL_NAME_LDAP_ATTR_LIST = "LDAP_ATTR_LIST_V3";
    public static final String SQL_NAME_LDAP_EVENT = "LDAP_EVENT_V3";
    public static final String SQL_NAME_LDAP_EVENT_LIST = "LDAP_EVENT_LIST_V3";
    public static final String SQL_NAME_LDAP_EVENT_STATUS = "LDAP_EVENT_STATUS_V3";
    public static final String SQL_NAME_LDAP_EVENT_STATUS_LIST = "LDAP_EVENT_STATUS_LIST_V3";

    public static ORADataFactory getFactory() {
        return _PlsqlEventFactory;
    }

    public PlsqlEvent() {
    }

    public PlsqlEvent(String pType, String pID, String pSrc, String pTime, String pObjName, String pObjType, String pObjGUID, String pObjDN, String pProfileID) {
        this.m_eventType = pType;
        this.m_eventID = pID;
        this.m_eventSrc = pSrc;
        this.m_eventTime = pTime;
        this.m_objectName = pObjName;
        this.m_objType = pObjType;
        this.m_objectGuid = pObjGUID;
        this.m_objectDN = pObjDN;
        this.m_profileID = pProfileID;
        this.m_changes = new ModPropertySet();
    }

    public PlsqlEvent(Connection conn, Event le, String schemaName) throws SQLException {
        this(le.getType(), le.getID(), le.getSource(), le.getTime(), le.getObjName(), "USER", le.getObjGuid(), le.getObjDN(), le.getProfileID());
        ModPropertySet modProps = le.getChanges();
        LDIFRecord lRec = modProps.getModProperty();
        int sz = lRec != null ? lRec.size() : 0;
        this.m_schemaName = schemaName;
        if (sz > 0) {
            PlsqlAttr[] plsqlAttrs = new PlsqlAttr[sz];
            for (int i = 0; i < sz; ++i) {
                plsqlAttrs[i] = new PlsqlAttr(conn, lRec.getAttribute(i), this.m_schemaName);
            }
            this.addAttrList(conn, plsqlAttrs);
        }
    }

    void addAttrList(Connection conn, PlsqlAttr[] attrs) throws SQLException {
        ArrayDescriptor attrDesc = ArrayDescriptor.createDescriptor((String)(this.m_schemaName + SQL_NAME_LDAP_ATTR_LIST), (Connection)conn);
        this.m_attrs = new ARRAY(attrDesc, conn, (Object)attrs);
    }

    void addAttrList(ARRAY attrs) {
        this.m_attrs = attrs;
    }

    public Datum toDatum(Connection conn) throws SQLException {
        StructDescriptor sd = StructDescriptor.createDescriptor((String)(this.m_schemaName + SQL_NAME_LDAP_EVENT), (Connection)conn);
        Object[] attributes = new Object[]{this.m_eventType, this.m_eventID, this.m_eventSrc, this.m_eventTime, this.m_objectName, this.m_objType, this.m_objectGuid, this.m_objectDN, this.m_profileID, this.m_attrs};
        return new STRUCT(sd, conn, attributes);
    }

    public ORAData create(Datum d, int sqlType) throws SQLException {
        if (d == null) {
            return null;
        }
        Datum[] attributes = ((STRUCT)d).getOracleAttributes();
        PlsqlEvent newObj = new PlsqlEvent(attributes[0] != null ? attributes[0].stringValue() : null, attributes[1] != null ? attributes[1].stringValue() : null, attributes[2] != null ? attributes[2].stringValue() : null, attributes[3] != null ? attributes[3].stringValue() : null, attributes[4] != null ? attributes[4].stringValue() : null, attributes[5] != null ? attributes[5].stringValue() : null, attributes[6] != null ? attributes[6].stringValue() : null, attributes[7] != null ? attributes[7].stringValue() : null, attributes[8] != null ? attributes[8].stringValue() : null);
        newObj.addAttrList((ARRAY)attributes[9]);
        return newObj;
    }

    public ModPropertySet setChanges() {
        this.m_changes = new ModPropertySet();
        Object[] attrs = null;
        try {
            attrs = (Object[])this.m_attrs.getArray();
            for (int i = 0; i < attrs.length; ++i) {
                PlsqlAttr attr = (PlsqlAttr)attrs[i];
                Object[] vals = null;
                vals = (Object[])attr.getValues().getArray();
                for (int k = vals.length - 1; k >= 0; --k) {
                    PlsqlAttrVal val = (PlsqlAttrVal)vals[k];
                    if (attr.getAttrType() == 0) {
                        this.m_changes.addProperty(this.alterChangeType(attr.getChgType()), attr.getAttrName(), val.getAttrValue());
                        continue;
                    }
                    if (attr.getAttrType() != 1) continue;
                    this.m_changes.addProperty(this.alterChangeType(attr.getChgType()), attr.getAttrName(), val.getAttrBValue());
                }
            }
        }
        catch (SQLException SQLE) {
            UtilDebug.log(127, "Exception in reading attribute values ", SQLE.getMessage());
        }
        catch (Exception Ex) {
            UtilDebug.log(127, "Exception in reading attribute values ", Ex.getMessage());
        }
        return this.m_changes;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer(nl);
        sbuf.append("------------------- EVENT START -------------------").append(nl).append("Event Type  : " + this.m_eventType).append(nl).append("Event ID    : " + this.m_eventID).append(nl).append("Event Src   : " + this.m_eventSrc).append(nl).append("Event Time  : " + this.m_eventTime).append(nl).append("Object Name : " + this.m_objectName).append(nl).append("Object Type : " + this.m_objType).append(nl).append("Object GUID : " + this.m_objectGuid).append(nl).append("Object DN   : " + this.m_objectDN).append(nl).append("Profile ID  : " + this.m_profileID).append(nl).append("No.of Attr  : ");
        if (this.m_changes != null) {
            LDIFRecord lrec = this.m_changes.getModProperty();
            sbuf.append(lrec.toString());
        } else {
            sbuf.append("0");
        }
        sbuf.append(nl);
        sbuf.append("-------------------- EVENT END --------------------");
        sbuf.append(nl);
        return sbuf.toString();
    }

    String getEventType() {
        return this.m_eventType;
    }

    void setEventType(String pEventType) {
        this.m_eventType = pEventType;
    }

    private int alterChangeType(int chgType) {
        chgType = chgType >= 5 ? (chgType -= 5) : (chgType += 5);
        return chgType;
    }
}

