/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.event;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class PlsqlAttrVal
implements ORAData,
ORADataFactory {
    static final PlsqlAttrVal _PlsqlAttrValFactory = new PlsqlAttrVal();
    private String m_attrVal = null;
    private byte[] m_attrBval = null;
    private int m_attrLen;
    private String m_schemaName = "";

    public static ORADataFactory getFactory() {
        return _PlsqlAttrValFactory;
    }

    public PlsqlAttrVal() {
    }

    public PlsqlAttrVal(String attrVal, String schemaName) {
        this.m_attrVal = attrVal;
        if (null != attrVal) {
            this.m_attrLen = attrVal.length();
        }
        this.m_schemaName = schemaName;
    }

    public PlsqlAttrVal(byte[] attrVal, String schemaName) {
        this.m_attrBval = attrVal;
        if (null != attrVal) {
            this.m_attrLen = attrVal.length;
        }
        this.m_schemaName = schemaName;
    }

    public Datum toDatum(Connection c) throws SQLException {
        StructDescriptor sd = StructDescriptor.createDescriptor((String)(this.m_schemaName + "LDAP_ATTR_VALUE_V3"), (Connection)c);
        Object[] attributes = new Object[]{this.m_attrVal, this.m_attrBval, new NUMBER(this.m_attrLen)};
        return new STRUCT(sd, c, attributes);
    }

    public ORAData create(Datum d, int sqlType) throws SQLException {
        if (d == null) {
            return null;
        }
        Datum[] attributes = ((STRUCT)d).getOracleAttributes();
        PlsqlAttrVal newObj = new PlsqlAttrVal();
        newObj.setAttrValue(attributes[0] != null ? attributes[0].stringValue() : null);
        Datum bval = attributes[1] != null ? attributes[1] : null;
        newObj.setAttrBValue((byte[])bval);
        return newObj;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer(nl);
        sbuf.append("  AttrValue : ");
        if (null == this.m_attrVal && null != this.m_attrBval) {
            sbuf.append("BINARY");
        } else {
            sbuf.append(this.m_attrVal);
        }
        sbuf.append(nl).append("  Attr Len  : ").append(this.m_attrLen).append(nl);
        return sbuf.toString();
    }

    public String getAttrValue() {
        return this.m_attrVal;
    }

    public void setAttrValue(String val) {
        this.m_attrVal = val;
        if (null != val) {
            this.m_attrLen = val.length();
        }
    }

    public byte[] getAttrBValue() {
        return this.m_attrBval;
    }

    public void setAttrBValue(byte[] bval) {
        this.m_attrBval = bval;
        if (null != bval) {
            this.m_attrLen = bval.length;
        }
    }

    public int getValueLen() {
        return this.m_attrLen;
    }
}

