/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.util.List;
import java.util.Vector;

public class SearchAttribute {
    private String mName;
    private String mAttrDisplayName;
    private String mAttrDataType;
    private String mAttrFormat;
    private boolean mAttrSortable;
    private List mAttrComparators = new Vector();
    private boolean mIsDefault;
    private List mValues;
    public static final String ATTR_DATA_TYPE_STRING = "STRING_TYPE";
    public static final String ATTR_DATA_TYPE_DATE = "DATE_TYPE";
    public static final String ATTR_DATA_TYPE_NUMERIC = "NUMBER_TYPE";
    public static final String ATTR_DATA_TYPE_FORMAT = "YYYYMMDDHH24MISS";

    public SearchAttribute(String attrname) {
        this.mName = attrname;
        this.mAttrDisplayName = attrname;
        this.mAttrDataType = ATTR_DATA_TYPE_STRING;
        this.mAttrFormat = null;
        this.mAttrSortable = true;
        this.mIsDefault = false;
        this.mAttrComparators.add("equal");
        this.mAttrComparators.add("not equal");
        this.mAttrComparators.add("greater than or equal");
        this.mAttrComparators.add("less than or equal");
    }

    public String getName() {
        return this.mName;
    }

    public void setDisplayName(String val) {
        this.mAttrDisplayName = val;
    }

    public String getDisplayName() {
        return this.mAttrDisplayName;
    }

    public void setDataType(String val) {
        this.mAttrDataType = val;
    }

    public String getDataType() {
        return this.mAttrDataType;
    }

    public String getFormat() {
        return this.mAttrFormat;
    }

    public boolean isSortable() {
        return this.mAttrSortable;
    }

    public List getComparators() {
        return this.mAttrComparators;
    }

    public boolean isDefault() {
        return this.mIsDefault;
    }

    public List getValues() {
        return this.mValues;
    }

    public void setDefault(boolean bool) {
        this.mIsDefault = bool;
    }

    public void setValues(List vals) {
        this.mValues = vals;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n----------------------------------------");
        sbuf.append("\nAttribute Name : " + this.getName());
        sbuf.append("\nAttribute Display Name : " + this.getDisplayName());
        List values = this.getValues();
        if (values != null && values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                Value val = (Value)values.get(i);
                sbuf.append("\nActual Value : " + val.getActualValue());
                sbuf.append("\nDisplay Value : " + val.getDisplayValue());
            }
        }
        sbuf.append("\n");
        return sbuf.toString();
    }

    public static class Value {
        String mActualValue;
        String mDisplayVlaue;

        public Value(String actualVal, String DisplayVal) {
            this.mActualValue = actualVal;
            this.mDisplayVlaue = DisplayVal;
        }

        public String getActualValue() {
            return this.mActualValue;
        }

        public String getDisplayValue() {
            return this.mDisplayVlaue;
        }
    }
}

