/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.ApplicationType;
import oracle.idm.provisioning.configuration.AttrLOV;
import oracle.idm.provisioning.configuration.ConfigAttribute;
import oracle.idm.provisioning.configuration.SearchAttribute;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.schema.DIPSchema;

public class Configuration
implements Serializable {
    private String mRealmName;
    private String mRealmDN;
    private Hashtable mAppTypes;
    private Hashtable mAppList;
    private Subscriber mSubscriber;
    private String mNickNameAttr;
    private ConfigAttribute[] mBaseAttrList;
    private final String ATTRIBUTE_CONFIG_DN_PREFIX = "cn=Attributes,cn=User Configuration,cn=Attribute Configuration,cn=DAS,cn=Products,cn=OracleContext,";

    public Configuration(String realmName) {
        if (realmName == null) {
            throw new NullPointerException("Realm name is NULL ");
        }
        this.mRealmName = realmName.trim();
    }

    public synchronized Subscriber getSubscriber(LdapContext lCtx) throws Exception {
        if (this.mSubscriber == null) {
            int subscriberType = Util.IDTYPE_SIMPLE;
            String[] attrlist = new String[]{"*", "orclguid"};
            RootOracleContext rootOC = new RootOracleContext((DirContext)lCtx, "");
            this.mSubscriber = rootOC.getSubscriber(lCtx, subscriberType, this.mRealmName, attrlist);
            this.mRealmDN = this.mSubscriber.getDN(lCtx);
            UtilDebug.log(32, "Configuration : ", "Realm DN :" + this.mRealmDN);
        }
        return this.mSubscriber;
    }

    public synchronized Vector getInstalledApplications(LdapContext ctx) throws Exception {
        Vector retVect = null;
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        UtilDebug.log(32, "Configuration : ", "getInstalledApplications");
        if (this.mAppList == null) {
            this.initConfig(ctx, true);
        }
        boolean allApps = true;
        retVect = this.toVectorList(this.mAppList, allApps);
        noOfMilSec = System.currentTimeMillis() - startTime;
        Configuration.debug("QUANTIFY TIME - getInstalledApplications() - " + noOfMilSec);
        return retVect;
    }

    public Vector getAllApplications(LdapContext lCtx) throws Exception {
        return this.getAllApplications(lCtx, false);
    }

    public synchronized Vector getAllApplications(LdapContext ctx, boolean force) throws Exception {
        Vector retVect = null;
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        UtilDebug.log(32, "Configuration : ", "getAllApplication - force read - " + force);
        if (this.mAppList == null || force) {
            this.initConfig(ctx, true);
        }
        boolean allApps = false;
        retVect = this.toVectorList(this.mAppList, allApps);
        noOfMilSec = System.currentTimeMillis() - startTime;
        Configuration.debug("QUANTIFY TIME - getAllApplication() - Force Read(" + force + ") - " + noOfMilSec);
        return retVect;
    }

    public Application getApplication(LdapContext ctx, String appType, String appName) throws Exception {
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        Application app = null;
        if (this.mAppList == null) {
            this.initConfig(ctx, false);
        }
        if (this.mAppList != null) {
            if (appName == null || appName.equalsIgnoreCase("")) {
                appName = appType;
            }
            String key = appType + '_' + appName;
            app = (Application)this.mAppList.get(key.toUpperCase());
        }
        if (app == null) {
            UtilDebug.log(32, "Configuration : ", "Application Not Found For (" + appType + ',' + appName + ")");
        }
        noOfMilSec = System.currentTimeMillis() - startTime;
        Configuration.debug("QUANTIFY TIME - getApplication() - " + noOfMilSec);
        return app;
    }

    public Application getApplication(LdapContext ctx, String subType) throws Exception {
        String type = subType.replace('_', '_');
        return (Application)this.mAppList.get(type.toUpperCase());
    }

    public ConfigAttribute[] getAllBaseAttrConfig(LdapContext lCtx) throws Exception {
        if (this.mBaseAttrList == null && lCtx != null) {
            String searchBase = null;
            String searchFilter = null;
            SearchControls pCtls = null;
            NamingEnumeration<SearchResult> pEnum = null;
            ArrayList<ConfigAttribute> attrList = null;
            searchBase = ApplicationType.USER_ATTRIBUTES + ApplicationType.ATTRIBUTE_CONTAINER + ",cn=DAS,cn=Products,cn=OracleContext," + this.mRealmDN;
            pCtls = new SearchControls();
            pCtls.setSearchScope(1);
            attrList = new ArrayList<ConfigAttribute>();
            searchFilter = "objectClass=" + ApplicationType.APPLN_ATTRCATEGORY_OBJCLS;
            try {
                pEnum = lCtx.search(searchBase, searchFilter, pCtls);
                SearchResult sr = null;
                String dn = null;
                Attributes attrs = null;
                Object attr = null;
                int absz = 0;
                while (pEnum.hasMore()) {
                    String uitype;
                    ++absz;
                    sr = pEnum.next();
                    dn = sr.getName() + ',' + searchBase;
                    attrs = sr.getAttributes();
                    boolean isLOV = false;
                    Attribute uitypeattr = attrs.get("orcldasuitype");
                    if (uitypeattr != null && (uitype = (String)uitypeattr.get()).equalsIgnoreCase("lov")) {
                        isLOV = true;
                    }
                    if (isLOV) {
                        String attrname = sr.getName();
                        attrname = attrname.substring(attrname.indexOf("=") + 1);
                        AttrLOV daslov = AttrLOV.createAttrLOV(attrname, lCtx, dn, attrs);
                        BasicAttribute newAttr = new BasicAttribute("orcldaslov", daslov);
                        attrs.put(newAttr);
                    }
                    ConfigAttribute cfgattr = new ConfigAttribute(dn, attrs);
                    attrList.add(cfgattr);
                }
            }
            catch (NamingException nnfe) {
                Configuration.debug("DAS Attribute Configuration reading error..");
                Configuration.debug(nnfe);
                return null;
            }
            if (attrList.size() > 0) {
                this.mBaseAttrList = attrList.toArray(new ConfigAttribute[0]);
            }
        }
        return this.mBaseAttrList;
    }

    private void initConfig(LdapContext ctx, boolean onlyDASViewable) throws Exception {
        DIPSchema pSchema = new DIPSchema(ctx);
        NamingEnumeration namEnum = this.getAppList(pSchema);
        Attributes attrs = null;
        Attribute attr = null;
        SearchResult sr = null;
        this.mAppList = new Hashtable();
        this.mAppTypes = new Hashtable();
        UtilDebug.log(32, "Configuration : ", "Initializing Application Cache..");
        while (namEnum.hasMore()) {
            String orgname;
            sr = (SearchResult)namEnum.next();
            attrs = sr.getAttributes();
            attr = attrs.get("orclApplicationType");
            String type = attr != null ? (String)attr.get(0) : "";
            type = type.toUpperCase();
            attr = attrs.get("orclODIPProvisioningAppName");
            String name = attr != null ? (String)attr.get(0) : "";
            attr = attrs.get("orclStatus");
            String status = attr != null ? (String)attr.get(0) : "";
            attr = attrs.get("orclODIPProvisioningOrgName");
            String string = orgname = attr != null ? (String)attr.get(0) : "";
            if (!orgname.equalsIgnoreCase(this.mRealmName)) {
                Configuration.debug("Ignoring Profile For Realm : " + orgname);
                continue;
            }
            if (onlyDASViewable) {
                String isDASViewable;
                attr = attrs.get("orclApplicationIsDASViewable");
                String string2 = isDASViewable = attr != null ? (String)attr.get(0) : "";
                if (!isDASViewable.equalsIgnoreCase("TRUE")) {
                    Configuration.debug("Not a DAS ViewAble Application. Ignoring..");
                    continue;
                }
            }
            Configuration.debug("<" + name + "," + type + ">");
            ApplicationType appTypeObj = (ApplicationType)this.mAppTypes.get(type);
            if (appTypeObj == null) {
                appTypeObj = new ApplicationType(pSchema, type);
                this.mAppTypes.put(type, appTypeObj);
            }
            String profileDn = sr.getName() + "," + pSchema.getProvProfileContainerDN();
            Application app = new Application(ctx, appTypeObj, attrs);
            app.setAppProfileDN(profileDn);
            String key = type + '_' + name;
            this.mAppList.put(key.toUpperCase(), app);
        }
        if (this.mAppList.size() == 0) {
            this.mAppList = null;
            Configuration.debug("The Realm does not have any applications");
        }
        if (this.mAppTypes.size() == 0) {
            this.mAppTypes = null;
        }
    }

    private NamingEnumeration getAppList(DIPSchema pSchema) throws Exception {
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        LdapContext lCtx = (LdapContext)pSchema.getDirContext();
        String pContainer = pSchema.getProvProfileContainerDN();
        UtilDebug.log(32, "Configuration : ", "Prov Profile Container : " + pContainer);
        if (this.mSubscriber == null) {
            this.mSubscriber = this.getSubscriber(lCtx);
        }
        String filter = "(&(objectclass=orclODIPIntegrationProfile)(orclodipprofilename=*))";
        UtilDebug.log(32, "Configuration.getAppList:", "Search Filter :" + filter);
        String[] aList = new String[]{"orclApplicationType", "orclODIPProvisioningAppName", "orclODIPProvisioningOrgName", "orclApplicationUserDataLoc", "orclApplicationDefaultPolicy", "orclApplicationDisplayName", "orclApplicationIsDASViewable", "orclManageApplicationDefaults", "orclStatus", "orclODIPProfileSchedule", "orclODIPProvisioningAppGUID", "orclODIPProvisioningAppDN"};
        NamingEnumeration namEnum = (NamingEnumeration)Util.getEntryDetails(lCtx, pContainer, filter, 1, aList, false);
        noOfMilSec = System.currentTimeMillis() - startTime;
        Configuration.debug("QUANTIFY TIME - getAppList() - " + noOfMilSec);
        return namEnum;
    }

    private Vector toVectorList(Hashtable appList, boolean allApps) {
        if (appList == null) {
            return null;
        }
        Vector<Application> appVecList = new Vector<Application>();
        try {
            ArrayList keys = new ArrayList(appList.keySet());
            Collections.sort(keys);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Application app = (Application)appList.get((String)iterator.next());
                if (!allApps && !app.isEnabled()) continue;
                appVecList.addElement(app);
            }
        }
        catch (Exception e) {
            Configuration.debug(e);
        }
        return appVecList;
    }

    public String getRealmName() {
        return this.mRealmName;
    }

    public String getRealmDN() {
        return this.mRealmDN;
    }

    public List getUserSearchableAttributes(LdapContext ctx, Locale lc) throws Exception {
        ResourceBundle resBundle = null;
        System.out.println("Getting ALL user Searchable Attributes...");
        try {
            resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource", lc);
        }
        catch (Exception ex) {
            String emsg = "Unable to load resource Bundle for this locale:" + lc;
            throw new Exception(emsg);
        }
        ArrayList<SearchAttribute> searchAttributes = new ArrayList<SearchAttribute>();
        boolean isMailTheNickName = false;
        if (this.mSubscriber == null) {
            RootOracleContext rootctx = new RootOracleContext(ctx);
            this.mSubscriber = rootctx.getSubscriber(ctx, Util.IDTYPE_SIMPLE, this.mRealmName, null);
            this.mRealmDN = this.mSubscriber.getDN(ctx);
            String[] attrID = new String[]{"orclCommonNickNameAttribute"};
            PropertySetCollection pSetC = null;
            PropertySet pSet = null;
            Property prop = null;
            try {
                pSetC = this.mSubscriber.getExtendedProperties(ctx, Subscriber.EXTPROPTYPE_COMMON, attrID, "");
                pSet = pSetC.getPropertySet(0);
                prop = pSet.getProperty(attrID[0]);
                this.mNickNameAttr = (String)prop.getValue(0);
                UtilDebug.log(32, "Configuration : ", "NickName Attribute : " + this.mNickNameAttr);
            }
            catch (Exception ex) {
                Configuration.debug("Error retrieving nickname attribute ..\n");
                Configuration.debug(ex);
            }
        }
        if (this.mNickNameAttr != null && this.mNickNameAttr.equalsIgnoreCase("mail")) {
            isMailTheNickName = true;
            SearchAttribute sAttr = new SearchAttribute("mail");
            searchAttributes.add(sAttr);
        }
        try {
            String attrName;
            String filter = "objectclass=*";
            String[] getAttrs = new String[]{"cn"};
            ArrayList<String> arList = new ArrayList<String>();
            NamingEnumeration namEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "cn=Attributes,cn=User Configuration,cn=Attribute Configuration,cn=DAS,cn=Products,cn=OracleContext," + this.mRealmDN, filter, 1, getAttrs, false);
            while (namEnum.hasMore()) {
                SearchResult sr = (SearchResult)namEnum.next();
                Attributes lAttrs = sr.getAttributes();
                Attribute lAttr = lAttrs.get(getAttrs[0]);
                attrName = ((String)lAttr.get()).toLowerCase();
                arList.add(attrName);
            }
            getAttrs[0] = "orclIndexedAttribute";
            Attributes lAttrs = ctx.getAttributes("cn=catalogs", getAttrs);
            Attribute lAttr = lAttrs.get(getAttrs[0]);
            NamingEnumeration<?> values = lAttr.getAll();
            while (values.hasMore()) {
                attrName = (String)values.next();
                if (!arList.contains(attrName.toLowerCase())) continue;
                SearchAttribute sAttr = new SearchAttribute(attrName);
                if (attrName.equalsIgnoreCase("sn")) {
                    sAttr.setDefault(true);
                } else if (attrName.equalsIgnoreCase("cn")) {
                    sAttr.setDefault(true);
                } else if (attrName.equalsIgnoreCase("uid")) {
                    sAttr.setDefault(true);
                } else if (!isMailTheNickName && attrName.equalsIgnoreCase("mail")) {
                    sAttr.setDefault(true);
                }
                searchAttributes.add(sAttr);
            }
        }
        catch (NamingException ne) {
            Configuration.debug(ne);
        }
        try {
            Vector apps = this.getAllApplications(ctx);
            if (apps != null) {
                SearchAttribute sAttr = null;
                Vector<SearchAttribute.Value> valueList = null;
                for (int loop = 0; loop < apps.size(); ++loop) {
                    Application app = (Application)apps.elementAt(loop);
                    String appType = app.getType();
                    String appName = app.getName();
                    String statusAttr = app.getProvStatusAttrName(true);
                    sAttr = new SearchAttribute(statusAttr);
                    Object[] arguments = new Object[]{app.getDisplayName()};
                    String result = MessageFormat.format(resBundle.getString("USER_PROVISIONING_STATUS_FOR_APP"), arguments);
                    sAttr.setDisplayName(result);
                    valueList = new Vector<SearchAttribute.Value>();
                    String[] statusVals = ProvUtil.getAllProvisioningStatusVals();
                    for (int i = 0; i < statusVals.length; ++i) {
                        valueList.add(new SearchAttribute.Value(statusVals[i], resBundle.getString(statusVals[i])));
                    }
                    sAttr.setValues(valueList);
                    searchAttributes.add(sAttr);
                }
            }
        }
        catch (Exception e) {
            Configuration.debug(e);
        }
        return searchAttributes;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage :  java oracle.idm.provisioning.configuration.Configuration <hostName> <port> <binddn> <passwd> <realm> <Prov dn>");
            return;
        }
        UtilDebug.setDebugMode(32);
        String hostName = args[0];
        String port = args[1];
        String bindDn = args[2];
        String passwd = args[3];
        String realm = args[4];
        String dn = null;
        if (args.length > 5) {
            dn = args[5];
        }
        Configuration cfg = new Configuration(realm);
        try {
            Configuration.debug("Connecting...");
            InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
            Configuration.debug("Connected...");
            Configuration.debug("------ Getting Specific Application Instance ------");
            Application app = cfg.getApplication(ctx, "EMAIL", "EMAIL");
            if (app == null) {
                Configuration.debug("Application instance WIRELESS sprintpcs not found");
            } else {
                Configuration.debug(app);
                ConfigAttribute[] cfAttr = app.getAllAttributes(ctx);
                ModPropertySet mpSet = app.getAttributes(ctx);
                System.out.println(app.getDisplayName());
                System.out.println(mpSet.getModProperty());
                for (int i = 0; i < cfAttr.length; ++i) {
                    System.out.println(cfAttr[i].getDisplayName());
                }
            }
            Vector apps = cfg.getAllApplications(ctx);
            if (apps != null) {
                System.out.println("No .of application instances configured : " + apps.size());
            } else {
                System.out.println("No applications found ");
            }
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void debug(Object o) {
        UtilDebug.log(32, "Configuration: ", o);
    }
}

