/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import oracle.idm.provisioning.configuration.AttrLOV;
import oracle.ldap.util.UtilDebug;

public class ConfigAttribute
implements Serializable {
    String m_dn;
    String m_cn;
    private String m_UIField;
    private String m_UIType;
    private String m_isAdminModifiable;
    private String m_isSelfModifiable;
    private String m_isMandatory;
    private String m_displayName;
    private String m_CreateField;
    private String m_EditField;
    private String m_DisplayByDefault;
    private String m_DefaultValue;
    private String m_AttrObjectClass;
    private String m_isViewable;
    private String m_isDisplayOnly;
    private HashMap m_atrrDisplayName = new HashMap();
    private AttrLOV lovobj = null;
    static final String CONFIG_ATTR_CN = "cn";
    static final String CONFIG_ATTR_UIFIELD = "orclDASAttrIsUIField";
    static final String CONFIG_ATTR_CREATE_FIELD = "orclDASAttrIsFieldForCreate";
    static final String CONFIG_ATTR_EDIT_FIELD = "orclDASAttrIsFieldForEdit";
    static final String CONFIG_ATTR_DISP_BY_DEF = "orclDASAttrToDisplayByDefault";
    static final String CONFIG_ATTR_DISPLAYNAME = "displayname";
    static final String CONFIG_ATTR_MANDATORY = "orclDASismandatory";
    static final String CONFIG_ATTR_VIEWABLE = "orclDASviewable";
    static final String CONFIG_ATTR_DISPLAY_ONLY = "orclDASAttrIsDisplayOnly";
    static final String CONFIG_ATTR_BY_ADMIN = "orclDASAdminModifiable";
    static final String CONFIG_ATTR_BY_SELF = "orclDASSelfModifiable";
    static final String CONFIG_ATTR_UITYPE = "orclDASUIType";
    static final String CONFIG_ATTR_LOVS = "orclDASlov";
    static final String CONFIG_ATTR_DISPLAY_ORDER = "orclDASAttrDisplayOrder";
    static final String CONFIG_ATTR_OBJCLS = "orclDASAttrObjectclass";
    static final String CONFIG_ATTR_DEFAULT_VAL = "orclDASAttrDefaultValue";
    static final String CONFIG_ATTR_VALIDATION_CLASS = "orclDASAttrValidationClass";

    ConfigAttribute(String dn, Attributes attrin) throws NamingException {
        this.m_dn = dn;
        if (attrin != null) {
            int pos = dn.indexOf(",");
            String tmp = dn.substring(pos + 1);
            Attribute uitypeattr = attrin.get(CONFIG_ATTR_UITYPE);
            if (uitypeattr != null) {
                this.m_UIType = (String)uitypeattr.get();
            }
            NamingEnumeration<? extends Attribute> ae = attrin.getAll();
            while (ae.hasMore()) {
                String key;
                int i;
                Attribute attr = ae.next();
                String name = attr.getID().toLowerCase();
                if (name.equalsIgnoreCase(CONFIG_ATTR_CN)) {
                    this.m_cn = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_UIFIELD)) {
                    this.m_UIField = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_CREATE_FIELD)) {
                    this.m_CreateField = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_EDIT_FIELD)) {
                    this.m_EditField = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_DISP_BY_DEF)) {
                    this.m_DisplayByDefault = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_DISPLAYNAME)) {
                    this.m_displayName = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_MANDATORY)) {
                    this.m_isMandatory = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_VIEWABLE)) {
                    this.m_isViewable = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_DISPLAY_ONLY)) {
                    this.m_isDisplayOnly = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_BY_ADMIN)) {
                    this.m_isAdminModifiable = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_BY_SELF)) {
                    this.m_isSelfModifiable = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_OBJCLS)) {
                    this.m_AttrObjectClass = (String)attr.get();
                    continue;
                }
                if (name.equalsIgnoreCase(CONFIG_ATTR_DEFAULT_VAL)) {
                    this.m_DefaultValue = (String)attr.get();
                    continue;
                }
                if (this.m_UIType.equalsIgnoreCase("lov") && name.equalsIgnoreCase(CONFIG_ATTR_LOVS)) {
                    this.lovobj = (AttrLOV)attr.get();
                    continue;
                }
                if (!name.startsWith(CONFIG_ATTR_DISPLAYNAME) || (i = name.indexOf(";")) == -1 || (i = (key = name.substring(i + 1)).indexOf("lang-")) == -1) continue;
                key = key.substring(i + 5).toLowerCase();
                this.m_atrrDisplayName.put(key, attr.get());
            }
        }
    }

    public String getName() {
        return this.m_cn;
    }

    public void setName(String val) {
        this.m_cn = val.toLowerCase();
    }

    public void setIsUIField(String val) {
        this.m_UIField = val;
    }

    public void setIsCreateField(String val) {
        this.m_CreateField = val;
    }

    public void setDispByDef(String val) {
        this.m_DisplayByDefault = val;
    }

    public void setDisplayName(String val) {
        this.m_displayName = val;
    }

    public void setIsSelfModifiable(String val) {
        this.setBoolean(this.m_isSelfModifiable, val);
    }

    public void setIsViewable(String val) {
        this.setBoolean(this.m_isViewable, val);
    }

    public void setIsDisplayOnly(String val) {
        this.setBoolean(this.m_isDisplayOnly, val);
    }

    public void setIsMandatory(String val) {
        this.setBoolean(this.m_isMandatory, val);
    }

    private void setBoolean(String attr, String val) {
        attr = val == null ? "false" : val;
    }

    public void setUIType(String val) {
        this.m_UIType = val;
    }

    public void setAttrObjClass(String val) {
        this.m_AttrObjectClass = val;
    }

    public void setDefaultVal(String val) {
        this.m_DefaultValue = val;
    }

    public void setLOVVals(String vals) {
    }

    public void setIsAdminModifiable(String val) {
        this.setBoolean(this.m_isAdminModifiable, val);
    }

    public boolean isUIField() {
        return this.getBoolean(this.m_UIField);
    }

    public boolean isCreateField() {
        return this.getBoolean(this.m_CreateField);
    }

    public boolean isEditField() {
        return this.getBoolean(this.m_EditField);
    }

    public boolean isDispByDef() {
        return this.getBoolean(this.m_DisplayByDefault);
    }

    public boolean isViewable() {
        return this.getBoolean(this.m_DisplayByDefault);
    }

    public boolean isDisplayOnly() {
        return this.getBoolean(this.m_isDisplayOnly);
    }

    public boolean isMandatory() {
        return this.getBoolean(this.m_isMandatory);
    }

    private boolean getBoolean(String val) {
        if (val != null) {
            return val.equals("1") || val.equalsIgnoreCase("true");
        }
        return false;
    }

    public boolean isSelfModifiable() {
        return this.getBoolean(this.m_isSelfModifiable);
    }

    public boolean isAdminModifiable() {
        return this.getBoolean(this.m_isAdminModifiable);
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getDisplayName(String lang) {
        String retVal = null;
        retVal = (String)this.m_atrrDisplayName.get(lang = lang.toLowerCase());
        if (retVal == null) {
            ConfigAttribute.debug("Requested Locale not found. Returning default Display Name");
            retVal = this.getDisplayName();
        }
        return retVal;
    }

    public String getDN() {
        return this.m_dn;
    }

    public String getUIType() {
        return this.m_UIType;
    }

    public boolean isPrintable() {
        return !this.m_UIType.equalsIgnoreCase("password");
    }

    public String getAttrObjClass() {
        return this.m_AttrObjectClass;
    }

    public String getDefaultVal() {
        return this.m_DefaultValue;
    }

    public AttrLOV getAttrLOVVals() {
        return this.lovobj;
    }

    public String[] getLOVVals() {
        return this.lovobj.getRealVals();
    }

    static Vector parseInputData(String data) {
        if (data == null || data.length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        while (true) {
            String s;
            int idx = data.indexOf(13);
            int idx2 = data.indexOf(10);
            if (idx > 0) {
                s = data.substring(0, idx);
                v.addElement(s);
                data = data.substring(idx + 2);
                continue;
            }
            if (idx2 <= 0) break;
            s = data.substring(0, idx2);
            v.addElement(s);
            data = data.substring(idx2 + 1);
        }
        if (data != null && data.length() > 0) {
            v.addElement(data);
        }
        return v;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\n--------------------");
        sbuf.append("\n cn                 : " + this.getName());
        sbuf.append("\n Display Name       : " + this.getDisplayName());
        sbuf.append("\n Mandatory          : " + this.isMandatory());
        sbuf.append("\n Default Value      : " + this.getDefaultVal());
        sbuf.append("\n Viewable           : " + this.m_isViewable);
        sbuf.append("\n Display Only       : " + this.isDisplayOnly());
        sbuf.append("\n Self Modifiable    : " + this.isSelfModifiable());
        sbuf.append("\n Admin Modifiable   : " + this.isAdminModifiable());
        sbuf.append("\n UI Type            : " + this.getUIType());
        sbuf.append("\n Attr ObjectClass   : " + this.getAttrObjClass());
        sbuf.append("\n lov_list           : ");
        return sbuf.toString();
    }

    static void debug(Object o) {
        UtilDebug.log(32, "ConfigAttribute: ", o);
    }

    public static void main(String[] args) {
    }
}

