/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;

public class AttrLOV
implements Serializable {
    private boolean oldScheme = false;
    private String attrname = null;
    private String attrDN = null;
    private HashMap vmap = new HashMap();
    private HashMap cacheMap = new HashMap();
    private String[] cacheReal = null;
    private int attrType = STATICLOV;
    private static String DELIMITER = ";;;";
    private static String DEFAULT_KEY = "oiddefaultkey";
    private static String DISPNAME = "displayname";
    private static String LANGSUBTYPE = ";Lang-";
    private static String ORCLDASLOV = "orcldaslov";
    private static String OU = "ou";
    private static int DISPNAME_LEN = DISPNAME.length();
    private static int LANGSUBTYPE_LEN = LANGSUBTYPE.length();
    public static int STATICLOV = 1;
    public static int DYNAMICLOV = 2;

    public static AttrLOV createAttrLOV(String attrname, DirContext ctx, String attrdn, Attributes attrEntry) {
        AttrLOV lov = null;
        try {
            SearchControls sctrls = new SearchControls();
            sctrls.setSearchScope(1);
            NamingEnumeration<SearchResult> penum = ctx.search(attrdn, "objectclass=*", sctrls);
            if (penum.hasMore()) {
                lov = new AttrLOV(attrname, attrdn, penum);
            } else {
                Attribute lovattr = attrEntry.get(ORCLDASLOV);
                if (lovattr != null) {
                    int size = lovattr.size();
                    String[] lovvals = new String[size];
                    for (int i = 0; i < size; ++i) {
                        lovvals[i] = (String)lovattr.get(i);
                    }
                    lov = new AttrLOV(attrname, attrdn, lovvals);
                }
            }
        }
        catch (Exception e) {
            AttrLOV.debug("AttrLOV.createAttrLOV(): Exception occured");
            AttrLOV.debug(e);
        }
        return lov;
    }

    public boolean persistToDIR(DirContext dirctx) throws Exception {
        return false;
    }

    public int getSize() {
        return this.vmap.size();
    }

    public boolean addDisplayRealPair(String display, String real) {
        return this.addDisplayRealPair(display, real, null);
    }

    public boolean addDisplayRealPair(String display, String real, Locale locale) {
        String key = null;
        boolean status = true;
        HashMap<String, String> map = null;
        boolean newEntry = false;
        if (locale != null) {
            key = locale.getLanguage();
            if (key.length() > 0) {
                String country = locale.getCountry();
                if (country.length() > 0) {
                    key = key + "-" + country;
                }
            } else {
                key = DEFAULT_KEY;
            }
        } else {
            key = DEFAULT_KEY;
        }
        map = (HashMap<String, String>)this.vmap.get(real);
        if (map == null) {
            map = new HashMap<String, String>();
            newEntry = true;
        }
        map.put(key, display);
        if (newEntry) {
            this.vmap.put(real, map);
        }
        this.clearCache();
        return status;
    }

    public String getDisplayVal(String realval) {
        return this.getDisplayVal(realval, null);
    }

    public String getDisplayVal(String realval, Locale locale) {
        String key = null;
        String display = null;
        Stack<String> keyStack = new Stack<String>();
        if (realval == null) {
            return null;
        }
        keyStack.push(DEFAULT_KEY);
        if (locale != null && (key = locale.getLanguage()).length() > 0) {
            keyStack.push(key);
            String country = locale.getCountry();
            if (country.length() > 0) {
                key = key + "-" + country;
                keyStack.push(key);
            }
        }
        Map map = (Map)this.vmap.get(realval);
        while (!keyStack.empty()) {
            key = (String)keyStack.pop();
            if ((key = this.normalizeKey(key)) != null && key.length() > 0 && map != null) {
                display = (String)map.get(key);
            }
            if (display == null) continue;
        }
        display = display != null ? display : realval;
        return display;
    }

    public String[] getRealVals() {
        if (this.cacheReal == null) {
            Set keyset = this.vmap.keySet();
            Iterator itr = keyset.iterator();
            int sz = this.getSize();
            this.cacheReal = new String[sz];
            for (int i = 0; i < sz; ++i) {
                this.cacheReal[i] = (String)itr.next();
            }
        }
        return (String[])this.cacheReal.clone();
    }

    public List getSortedDisplayRealPairs(Locale locale) {
        ArrayList<String> displist = new ArrayList<String>();
        String real = null;
        boolean try_next_key = false;
        Object row = null;
        HashMap<String, String> disprealmap = new HashMap<String, String>();
        HashMap map = null;
        int i = 0;
        String display = null;
        Stack<String> keyStack = new Stack<String>();
        ArrayList list = null;
        String key = null;
        keyStack.push(DEFAULT_KEY);
        if (locale != null && (key = locale.getLanguage()).length() > 0) {
            keyStack.push(key);
            String country = locale.getCountry();
            if (country.length() > 0) {
                key = key + "-" + country;
                keyStack.push(key);
            }
        }
        while (!keyStack.empty()) {
            try_next_key = false;
            key = (String)keyStack.pop();
            list = (ArrayList)this.cacheMap.get(key = this.normalizeKey(key));
            if (list != null) {
                return list;
            }
            Set keyset = this.vmap.keySet();
            Iterator keyitr = keyset.iterator();
            if (key != null && key.length() > 0) {
                while (keyitr.hasNext()) {
                    real = (String)keyitr.next();
                    map = (HashMap)this.vmap.get(real);
                    display = (String)map.get(key);
                    if (display == null) {
                        try_next_key = true;
                        displist.clear();
                        disprealmap.clear();
                        break;
                    }
                    displist.add(display);
                    disprealmap.put(display, real);
                }
            }
            if (key == null || key.length() == 0 || try_next_key) continue;
        }
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }

            public boolean equals(Object o2) {
                return super.equals(o2);
            }
        };
        Collections.sort(displist, comp);
        int sz = displist.size();
        list = new ArrayList();
        for (i = 0; i < sz; ++i) {
            String[] arr;
            arr = new String[]{(String)displist.get(i), (String)disprealmap.get(arr[0])};
            list.add(arr);
        }
        displist.clear();
        disprealmap.clear();
        this.cacheMap.put(key, list);
        return list;
    }

    public int getLOVType() {
        return this.attrType;
    }

    private void clearCache() {
        this.cacheMap.clear();
        this.cacheReal = null;
    }

    private String getLangKey(String id) {
        String langKey = null;
        langKey = id.substring(DISPNAME_LEN);
        if (langKey.length() == 0) {
            langKey = DEFAULT_KEY;
        } else if (langKey.regionMatches(true, 0, LANGSUBTYPE, 0, LANGSUBTYPE_LEN)) {
            if ((langKey = langKey.substring(LANGSUBTYPE_LEN)).length() == 0) {
                langKey = null;
            }
        } else {
            langKey = null;
        }
        return langKey;
    }

    private AttrLOV(String attrname, String attrDN, NamingEnumeration oneLvlAttrSearchEnum) {
        this.attrname = attrname;
        this.attrDN = attrDN;
        this.attrType = STATICLOV;
        try {
            while (oneLvlAttrSearchEnum.hasMore()) {
                HashMap<String, String> map = new HashMap<String, String>();
                SearchResult lovEntry = (SearchResult)oneLvlAttrSearchEnum.next();
                Attributes lovEntryAttrs = lovEntry.getAttributes();
                NamingEnumeration<String> attrIdsEnum = lovEntryAttrs.getIDs();
                String realval = lovEntry.getName();
                realval = realval.substring(realval.indexOf("=") + 1);
                while (attrIdsEnum.hasMore()) {
                    String id = attrIdsEnum.next().toLowerCase();
                    if (!id.startsWith(DISPNAME)) continue;
                    Attribute attr = lovEntryAttrs.get(id);
                    String key = this.getLangKey(id);
                    key = this.normalizeKey(key);
                    String dispval = (String)attr.get();
                    map.put(key, dispval);
                }
                this.vmap.put(realval, map);
            }
        }
        catch (Exception e) {
            AttrLOV.debug("AttrLOV(): Exception occured");
            AttrLOV.debug(e);
        }
    }

    private AttrLOV(String attrname, String attrDN, String[] orcldaslovAttrVals) {
        this.oldScheme = true;
        this.attrname = attrname;
        this.attrDN = attrDN;
        this.attrType = DYNAMICLOV;
        int len = orcldaslovAttrVals.length;
        for (int i = 0; i < len; ++i) {
            String realval = null;
            String dispval = null;
            Object[] row = new Object[2];
            HashMap<String, String> map = new HashMap<String, String>();
            if (!this.attrname.equalsIgnoreCase(OU)) {
                int idx = orcldaslovAttrVals[i].indexOf(DELIMITER);
                if (idx != -1) {
                    dispval = orcldaslovAttrVals[i].substring(0, idx);
                    realval = orcldaslovAttrVals[i].substring(idx + DELIMITER.length());
                } else {
                    realval = dispval = orcldaslovAttrVals[i];
                }
            } else {
                realval = dispval = orcldaslovAttrVals[i];
            }
            map.put(DEFAULT_KEY, dispval);
            this.vmap.put(realval, map);
        }
    }

    private String normalizeKey(String keyTobeNormalized) {
        String normalizedKey = keyTobeNormalized.toLowerCase();
        normalizedKey = normalizedKey.replace('_', '-');
        return normalizedKey;
    }

    private static void debug(Object o) {
        UtilDebug.log(32, "AttrLOV: ", o);
    }

    public static void main(String[] args) {
        try {
            InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx("usunnac08.us.oracle.com", "3060", "cn=orcladmin", "welcome");
            SearchControls sctrls = new SearchControls();
            sctrls.setSearchScope(1);
            String basedn = "cn=Attributes, cn=User Configuration,cn=Attribute Configuration, cn=DAS,cn=Products,cn=OracleContext,dc=us,dc=oracle,dc=com";
            NamingEnumeration<SearchResult> penum = ctx.search(basedn, "objectclass=*", sctrls);
            while (penum.hasMore()) {
                String uitype;
                SearchResult sr = penum.next();
                boolean isLOV = false;
                AttrLOV daslov = null;
                String attrname = null;
                attrname = sr.getName();
                attrname = attrname.substring(attrname.indexOf("=") + 1);
                Attributes attrs = sr.getAttributes();
                Attribute uitypeattr = attrs.get("orcldasuitype");
                if (uitypeattr != null && (uitype = (String)uitypeattr.get()).equalsIgnoreCase("lov")) {
                    isLOV = true;
                }
                if (!isLOV) continue;
                String attrdn = sr.getName() + "," + basedn;
                daslov = AttrLOV.createAttrLOV(attrname, ctx, attrdn, attrs);
                daslov.getSortedDisplayRealPairs(Locale.GERMAN);
                daslov.getSortedDisplayRealPairs(Locale.ENGLISH);
                daslov.getDisplayVal("DEP2");
                AttrLOV.debug(daslov);
                daslov.addDisplayRealPair("administration department", "DEP3");
                daslov.addDisplayRealPair("Leitung Abteilung", "DEP3", Locale.GERMAN);
                AttrLOV.debug(daslov);
            }
        }
        catch (Exception e) {
            AttrLOV.debug(e);
        }
    }

    public String toString() {
        String out = "";
        String sep = System.getProperty("line.separator");
        Set keyset = this.vmap.keySet();
        Iterator keyitr = keyset.iterator();
        while (keyitr.hasNext()) {
            String real = (String)keyitr.next();
            out = out + "[ " + sep + "    " + real + " = ";
            Map map = (Map)this.vmap.get(real);
            Set mset = map.keySet();
            Iterator mitr = mset.iterator();
            out = out + "{ ";
            while (mitr.hasNext()) {
                String lang = (String)mitr.next();
                String display = (String)map.get(lang);
                out = out + lang + " = " + display + ", ";
            }
            out = out + "}" + sep + "]" + sep;
        }
        return out;
    }
}

