/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.AttrLOV;
import oracle.idm.provisioning.configuration.ConfigAttribute;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.schema.DIPSchema;
import oracle.ldap.util.schema.ODISchemaException;
import oracle.ldap.util.schema.PluginContext;

public class ApplicationType
implements Serializable {
    static String ATTRIBUTE_CONTAINER = "cn=Attribute Configuration";
    static String USER_ATTRIBUTES = "cn=Attributes,cn=User Configuration,";
    static String USER_CATEGORIES = "cn=Categories,cn=user Configuration,";
    static String APPLN_USERDATA_LOCATION = "orclApplicationUserDataLoc";
    static String APPLN_USERRDN_FORMAT = "orclAppUserRDNFormat";
    static String APPLN_OBJECTCLASS_ATTR = "orclDASAttrObjectClass";
    static String APPLN_OBJECTCATEGORY = "orclDASAttrCategory";
    static String APPLN_ATTRCATEGORY_OBJCLS = "orclDASConfigAttr";
    private static String APPLN_DEFAULTVAL_ATTR = "orclDASAttrDefaultValue";
    private String mAppContainerDN = null;
    private ConfigAttribute[] mAttrList = null;
    private String mType = null;
    private ArrayList mObjClasses = new ArrayList();
    private PluginContext mPlgCtx = null;

    public ApplicationType(LdapContext lCtx, String type) throws ODISchemaException, Exception {
        this(new DIPSchema(lCtx), type);
    }

    public ApplicationType(DIPSchema dipSchema, String type) throws ODISchemaException, Exception {
        this.mType = type.toLowerCase();
        LdapContext lCtx = (LdapContext)dipSchema.getDirContext();
        this.mAppContainerDN = "cn=" + type + ',' + dipSchema.getProvApplicationsContainer();
        this.getAllAttributes(lCtx);
        this.mPlgCtx = new PluginContext(dipSchema, type, type);
    }

    public String getType() {
        return this.mType;
    }

    public String[] getAllAttributeNames(LdapContext lCtx) throws Exception {
        String[] retAttrNames = null;
        ConfigAttribute[] cfgAttrs = null;
        cfgAttrs = this.getAllAttributes(lCtx);
        if (cfgAttrs != null && cfgAttrs.length > 0) {
            retAttrNames = new String[cfgAttrs.length];
            for (int i = 0; i < cfgAttrs.length; ++i) {
                ConfigAttribute attr = cfgAttrs[i];
                retAttrNames[i] = attr.getName();
            }
        }
        return retAttrNames;
    }

    public ConfigAttribute[] getAllAttributes(LdapContext lCtx) throws Exception {
        if (this.mAttrList == null && lCtx != null) {
            String searchBase = null;
            String searchFilter = null;
            SearchControls pCtls = null;
            NamingEnumeration<SearchResult> pEnum = null;
            ArrayList<ConfigAttribute> attrList = null;
            searchBase = USER_ATTRIBUTES + ATTRIBUTE_CONTAINER + ',' + this.mAppContainerDN;
            pCtls = new SearchControls();
            pCtls.setSearchScope(1);
            attrList = new ArrayList<ConfigAttribute>();
            searchFilter = "objectClass=" + APPLN_ATTRCATEGORY_OBJCLS;
            try {
                pEnum = lCtx.search(searchBase, searchFilter, pCtls);
                SearchResult sr = null;
                String dn = null;
                Attributes attrs = null;
                Object attr = null;
                while (pEnum.hasMore()) {
                    String uitype;
                    sr = pEnum.next();
                    dn = sr.getName() + ',' + searchBase;
                    attrs = sr.getAttributes();
                    boolean isLOV = false;
                    Attribute uitypeattr = attrs.get("orcldasuitype");
                    if (uitypeattr != null && (uitype = (String)uitypeattr.get()).equalsIgnoreCase("lov")) {
                        isLOV = true;
                    }
                    if (isLOV) {
                        String attrname = sr.getName();
                        attrname = attrname.substring(attrname.indexOf("=") + 1);
                        AttrLOV daslov = AttrLOV.createAttrLOV(attrname, lCtx, dn, attrs);
                        BasicAttribute newAttr = new BasicAttribute("orcldaslov", daslov);
                        attrs.put(newAttr);
                    }
                    ConfigAttribute cfgattr = new ConfigAttribute(dn, attrs);
                    attrList.add(cfgattr);
                    this.addToObjClassList(attrs);
                }
            }
            catch (NameNotFoundException nnfe) {
                ApplicationType.debug("Attribute Configuration Container NOT Found..");
                return null;
            }
            if (attrList.size() > 0) {
                this.mAttrList = attrList.toArray(new ConfigAttribute[0]);
            }
        }
        return this.mAttrList;
    }

    void refreshAttrDefValCache(LdapContext lCtx) throws Exception {
        this.mAttrList = null;
        this.getAllAttributes(lCtx);
    }

    public ConfigAttribute[] getMandatoryAttributes(LdapContext lCtx) throws Exception {
        ConfigAttribute[] retlist = null;
        if (this.mAttrList == null) {
            this.getAllAttributes(lCtx);
        }
        if (this.mAttrList != null) {
            ArrayList<ConfigAttribute> alist = new ArrayList<ConfigAttribute>();
            ConfigAttribute attr = null;
            for (int i = 0; i < this.mAttrList.length; ++i) {
                attr = this.mAttrList[i];
                if (!attr.isMandatory()) continue;
                alist.add(attr);
            }
            if (alist.size() > 0) {
                retlist = alist.toArray(new ConfigAttribute[0]);
            }
        }
        return retlist;
    }

    public ConfigAttribute[] getOptionalAttributes(LdapContext lCtx) throws Exception {
        ConfigAttribute[] retlist = null;
        if (this.mAttrList == null) {
            this.getAllAttributes(lCtx);
        }
        if (this.mAttrList != null) {
            ArrayList<ConfigAttribute> alist = new ArrayList<ConfigAttribute>();
            ConfigAttribute attr = null;
            for (int i = 0; i < this.mAttrList.length; ++i) {
                attr = this.mAttrList[i];
                if (attr.isMandatory()) continue;
                alist.add(attr);
            }
            if (alist.size() > 0) {
                retlist = alist.toArray(new ConfigAttribute[0]);
            }
        }
        return retlist;
    }

    public Object getPluginInstance(LdapContext lCtx, String mName, String pName) throws Exception {
        return this.mPlgCtx.getPluginInstance(lCtx, this.mType, mName, pName);
    }

    private void addToObjClassList(Attributes attrin) throws Exception {
        String objClass;
        Attribute attr = attrin.get(APPLN_OBJECTCLASS_ATTR);
        if (attr != null && (objClass = (String)attr.get()) != null && !this.mObjClasses.contains(objClass = objClass.toLowerCase())) {
            this.mObjClasses.add(objClass);
        }
    }

    public String[] getObjectClasses() {
        return this.mObjClasses == null || this.mObjClasses.size() == 0 ? null : this.mObjClasses.toArray(new String[0]);
    }

    ModPropertySet getAttributes(LdapContext lCtx) throws Exception {
        ModPropertySet retPropSet = null;
        ConfigAttribute[] cfAttrs = null;
        cfAttrs = this.getAllAttributes(lCtx);
        if (cfAttrs != null) {
            ApplicationType.debug("cfgAttrs : " + cfAttrs);
            ApplicationType.debug("cfgAttrs length : " + cfAttrs.length);
            ConfigAttribute attr = null;
            String defVal = null;
            String name = null;
            retPropSet = new ModPropertySet(1);
            for (int i = 0; i < cfAttrs.length; ++i) {
                attr = cfAttrs[i];
                defVal = attr.getDefaultVal();
                name = attr.getName();
                ApplicationType.debug("Config Attr Name : " + name);
                if (name == null) continue;
                if (defVal != null) {
                    retPropSet.addProperty(5, name, defVal);
                    continue;
                }
                retPropSet.addProperty(5, name, "");
            }
            if (retPropSet.size() == 0) {
                retPropSet = null;
            }
        } else {
            ApplicationType.debug("cfgAttrs NULL");
        }
        return retPropSet;
    }

    public void setDefaultAttrs(LdapContext lCtx, ModPropertySet pmods) throws Exception {
        LDIFRecord ldifrec = pmods.getModProperty();
        int alen = ldifrec == null ? 0 : ldifrec.size();
        for (int i = 0; i < alen; ++i) {
            BasicAttribute jndiAttr = null;
            LDIFAttribute ldifattr = null;
            String attrname = null;
            String defVal = null;
            String attrDN = null;
            ModificationItem[] mods = null;
            int modOp = 1;
            ldifattr = ldifrec.getAttribute(i);
            attrname = ldifattr.getName();
            defVal = ldifattr.getValue();
            attrDN = "cn=" + attrname + ',' + USER_ATTRIBUTES + ATTRIBUTE_CONTAINER + ',' + this.mAppContainerDN;
            jndiAttr = new BasicAttribute(APPLN_DEFAULTVAL_ATTR, defVal);
            if (ldifattr.getChangeType() == 7) {
                modOp = 2;
            } else if (ldifattr.getChangeType() == 6) {
                modOp = 3;
            }
            mods = new ModificationItem[]{new ModificationItem(modOp, jndiAttr)};
            lCtx.modifyAttributes(attrDN, mods);
        }
    }

    static void debug(Object o) {
        UtilDebug.log(32, "ApplicationType: ", o);
    }
}

