/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import oracle.idm.provisioning.approval.Request;

public class RequestProcessingHistory {
    private String m_processor;
    private String m_action;
    private Date m_date;

    RequestProcessingHistory(String user, String action, Date date) {
        this.m_processor = user;
        this.m_action = action;
        this.m_date = date;
    }

    RequestProcessingHistory(String val) {
        if (val != null) {
            int ind1 = val.indexOf(43, 0);
            String str = val.substring(0, ind1);
            int ind2 = val.indexOf(43, ind1 + 1);
            this.m_action = val.substring(ind1 + 1, ind2);
            this.m_processor = val.substring(ind2 + 1, val.length());
            SimpleDateFormat format = new SimpleDateFormat(Request.REQUEST_DATE_FORMAT);
            TimeZone tz = TimeZone.getTimeZone(Request.REQUEST_DATE_TIMEZONE);
            format.setTimeZone(tz);
            try {
                this.m_date = format.parse(str);
            }
            catch (ParseException ex) {
                this.m_date = null;
            }
        }
    }

    public String getProcessingHistory() {
        return this.m_processor;
    }

    public String getAction() {
        return this.m_action;
    }

    public Date getDate() {
        return this.m_date;
    }

    public String formatObject() {
        SimpleDateFormat format = new SimpleDateFormat(Request.REQUEST_DATE_FORMAT);
        TimeZone tz = TimeZone.getTimeZone(Request.REQUEST_DATE_TIMEZONE);
        format.setTimeZone(tz);
        StringBuffer rtval = new StringBuffer();
        format.format(this.m_date, rtval, new FieldPosition(0));
        rtval.append("+").append(this.m_action).append("+").append(this.m_processor);
        return rtval.toString();
    }

    public static String formatObject(String processor, String action, Date date) {
        SimpleDateFormat format = new SimpleDateFormat(Request.REQUEST_DATE_FORMAT);
        TimeZone tz = TimeZone.getTimeZone(Request.REQUEST_DATE_TIMEZONE);
        format.setTimeZone(tz);
        StringBuffer rtval = new StringBuffer();
        format.format(date, rtval, new FieldPosition(0));
        rtval.append("+").append(action).append("+").append(processor);
        return rtval.toString();
    }
}

