/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

public class RequestPayload {
    private static String CHAR_VALUE_SEPARATOR = ":";
    private int mOrder;
    private String mAttrName;
    private String mChgType;
    private String mCharValue;

    public RequestPayload() {
        this.mOrder = 0;
        this.mAttrName = null;
        this.mChgType = null;
        this.mCharValue = null;
    }

    public RequestPayload(RequestPayload val) {
        if (val != null) {
            this.mOrder = val.mOrder;
            this.mAttrName = val.mAttrName;
            this.mChgType = val.mChgType;
            this.mCharValue = val.mCharValue;
        }
    }

    public int getOrder() {
        return this.mOrder;
    }

    public String getAttrName() {
        return this.mAttrName;
    }

    public String getChgType() {
        return this.mChgType;
    }

    public String getCharValue() {
        return this.mCharValue;
    }

    public void setValue(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("Invalid input for request char data.");
        }
        int[] indexes = new int[3];
        int lastindex = 0;
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            index = str.indexOf(CHAR_VALUE_SEPARATOR, lastindex);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid input for request char data.");
            }
            indexes[i] = index;
            if (index >= str.length() - 1) {
                if (i != 2) continue;
                lastindex = str.length();
                continue;
            }
            lastindex = index + 1;
        }
        if (indexes[0] == 0) {
            this.mOrder = 0;
        } else {
            try {
                String str2 = str.substring(0, indexes[0]);
                this.mOrder = Integer.parseInt(str2);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid input for request char data.");
            }
        }
        if (indexes[0] + 1 < indexes[1]) {
            try {
                this.mAttrName = str.substring(indexes[0] + 1, indexes[1]);
            }
            catch (IndexOutOfBoundsException ex) {
                String msg = "Index out of bound for " + str + ", indexes = " + indexes[0] + "," + indexes[1] + "," + indexes[2];
                throw new IllegalArgumentException(msg);
            }
        } else {
            this.mAttrName = null;
        }
        if (indexes[1] + 1 < indexes[2]) {
            try {
                this.mChgType = str.substring(indexes[1] + 1, indexes[2]);
            }
            catch (IndexOutOfBoundsException ex) {
                String msg = "Index out of bound for " + str + ", indexes = " + indexes[0] + "," + indexes[1] + "," + indexes[2];
                throw new IllegalArgumentException(msg);
            }
        } else {
            this.mChgType = null;
        }
        if (indexes[2] + 1 < str.length()) {
            try {
                this.mCharValue = str.substring(indexes[2] + 1);
            }
            catch (IndexOutOfBoundsException ex) {
                String msg = "Index out of bound for " + str + ", indexes = " + indexes[0] + "," + indexes[1] + "," + indexes[2];
                throw new IllegalArgumentException(msg);
            }
        } else {
            this.mCharValue = null;
        }
    }

    public RequestPayload(int order, String name, String chgtype, String val) {
        this.mOrder = order;
        this.mAttrName = name;
        this.mChgType = chgtype;
        this.mCharValue = val;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.mOrder);
        strbuf.append(CHAR_VALUE_SEPARATOR);
        if (this.mAttrName != null) {
            strbuf.append(this.mAttrName);
        }
        strbuf.append(CHAR_VALUE_SEPARATOR);
        if (this.mChgType != null) {
            strbuf.append(this.mChgType);
        }
        strbuf.append(CHAR_VALUE_SEPARATOR);
        if (this.mCharValue != null) {
            strbuf.append(this.mCharValue);
        }
        return strbuf.toString();
    }
}

