/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.idm.provisioning.approval.ApprovalProcessException;
import oracle.idm.provisioning.approval.InvalidRequestException;
import oracle.idm.provisioning.approval.ModRequest;
import oracle.idm.provisioning.approval.Request;
import oracle.idm.provisioning.approval.RequestDAO;
import oracle.idm.provisioning.approval.RequestOperationData;
import oracle.idm.provisioning.approval.RequestPayload;
import oracle.idm.provisioning.approval.RequestProcessingHistory;
import oracle.idm.provisioning.approval.RequestSearchCriteria;
import oracle.ldap.util.UtilDebug;

public class RequestLDAPDAO
extends RequestDAO {
    private static String objClassAttr = "objectclass";
    private static String requestClass = "orclrequest";
    private static String reqIDAttr = "orclRequestID";
    private static String reqTargetApp = "orclRequestTargetApp";
    private static String reqSourceApp = "orclRequestSourceApp";
    private static String reqStatus = "orclRequestStatus";
    private static String reqProcessingStatus = "orclRequestProcessingStatus";
    private static String reqOperation = "orclRequestOperation";
    private static String reqObject = "orclRequestObjectDN";
    private static String reqObjectInfo = "orclRequestObjectInfo";
    private static String reqOpInfo = "orclRequestOperationInfo";
    private static String reqCreationDate = "orclRequestCreationTime";
    private static String reqCreator = "orclRequestCreator";
    private static String reqLastModificationDate = "orclRequestLastModifiedTime";
    private static String reqProcessedBy = "orclRequestProcessedBy";
    private static String reqApproverComments = "orclApproverComment";
    private static String reqCharData = "orclRequestCharData";
    private static String reqCurrApprLevel = "orclRequestCurrentApprovalLevel";
    private static String reqTotalApprLevels = "orclRequestTotalApprovalLevels";
    private static String reqApprovers = "orclProvApproverUid";
    private static String reqApproverGroups = "orclProvApproverGroupUid";
    private static String reqApprovalPolicy = "orclRequestApprovalPolicy";
    private static String reqBinaryData = "orclrequestbindata";
    private static String[] opattrs = new String[]{reqIDAttr, reqTargetApp, reqSourceApp, reqStatus, reqProcessingStatus, reqOperation, reqObject, reqObjectInfo, reqOpInfo, reqCreationDate, reqCreator, reqLastModificationDate, reqProcessedBy, reqApproverComments, reqCharData, reqCurrApprLevel};
    private static String[] apattrs = new String[]{reqIDAttr, reqCurrApprLevel, reqTotalApprLevels, reqApprovers, reqApproverGroups, reqApprovalPolicy};
    private static String[] polattrs = new String[]{reqIDAttr, reqCurrApprLevel, reqTotalApprLevels, reqApprovalPolicy};
    private static String[] allattrs = null;
    private int MAX_FILTER_SIZE = 8192;
    private DirContext m_dirCtx;
    private String m_requestBase;

    public RequestLDAPDAO(DirContext ctx, String requestBase) {
        this.m_dirCtx = ctx;
        this.m_requestBase = requestBase;
    }

    public Request getRequest(String id, String app, int flags) throws NamingException, IllegalArgumentException, ApprovalProcessException {
        Request req = null;
        if (id == null || app == null) {
            String msg = "Insufficient information to get request, id: " + id + ", application: " + app;
            UtilDebug.log(127, "RequestLDAPDAO.getRequest:", msg);
            throw new IllegalArgumentException(msg);
        }
        if (this.m_dirCtx == null) {
            UtilDebug.log(127, "RequestLDAPDAO.getRequest:", "Null directory context. Can not proceed.");
            throw new ApprovalProcessException("Null directory context in getRequest()");
        }
        String reqDN = reqIDAttr + "=" + id + ",cn=" + app + "," + this.m_requestBase;
        String filter = "(" + objClassAttr + "=" + requestClass + ")";
        SearchControls ctl = new SearchControls();
        ctl.setSearchScope(0);
        if ((flags & Request.REQUEST_ALL_DATA) == Request.REQUEST_ALL_DATA) {
            ctl.setReturningAttributes(allattrs);
        } else if ((flags & Request.REQUEST_APPROVAL_DATA) == Request.REQUEST_APPROVAL_DATA) {
            ctl.setReturningAttributes(apattrs);
        } else if ((flags & Request.REQUEST_POLICY_DATA) == Request.REQUEST_POLICY_DATA) {
            ctl.setReturningAttributes(polattrs);
        } else {
            ctl.setReturningAttributes(opattrs);
        }
        NamingEnumeration<SearchResult> results = null;
        UtilDebug.log(127, "RequestLDAPDAO.getRequest:", "Searching for request, base: " + reqDN + ", filter: " + filter);
        results = this.m_dirCtx.search(reqDN, filter, ctl);
        SearchResult res = null;
        if (results.hasMore()) {
            res = (SearchResult)results.nextElement();
            req = this.ConstructRequest(res);
        }
        return req;
    }

    public String getRequestStatus(String id, String app) throws NamingException, IllegalArgumentException, ApprovalProcessException {
        if (id == null || app == null) {
            String msg = "Illegal arguments when reading request status " + id + ", " + app;
            UtilDebug.log(127, "RequestLDAPDAO.getRequestStatus:", msg);
            throw new IllegalArgumentException(msg);
        }
        String status = null;
        if (this.m_dirCtx == null) {
            UtilDebug.log(127, "RequestLDAPDAO.getRequestStatus:", "Null directory context. Can not proceed.");
            throw new ApprovalProcessException("Null or uninitialized DB context.");
        }
        String reqDN = reqIDAttr + "=" + id + ",cn=" + app + "," + this.m_requestBase;
        String[] attrs = new String[]{reqStatus};
        UtilDebug.log(127, "RequestLDAPDAO.getRequestStatus:", "Getting status for request DN: " + reqDN);
        Attributes returnAttrs = this.m_dirCtx.getAttributes(reqDN, attrs);
        Attribute statusAttr = returnAttrs.get(reqStatus);
        status = (String)statusAttr.get();
        return status;
    }

    public List getRequestsWProcStatus(String app, String status) throws NamingException, ApprovalProcessException {
        ArrayList<Request> list = null;
        if (status != null) {
            if (this.m_dirCtx == null) {
                UtilDebug.log(127, "RequestLDAPDAO.getRequestsWProcStatus:", "Null directory context. Can not proceed.");
                throw new ApprovalProcessException("Null directory context in getRequestsWProcStatus()");
            }
            String reqDN = null;
            SearchControls ctl = new SearchControls();
            if (app != null) {
                reqDN = "cn=" + app + "," + this.m_requestBase;
                ctl.setSearchScope(1);
            } else {
                reqDN = this.m_requestBase;
                ctl.setSearchScope(2);
            }
            StringBuffer buf = new StringBuffer();
            buf.append("(&(").append(objClassAttr).append("=");
            buf.append(requestClass).append(")(");
            buf.append(reqProcessingStatus).append("=").append(status).append(")");
            buf.append(")");
            String filter = buf.toString();
            NamingEnumeration<SearchResult> results = null;
            UtilDebug.log(127, "RequestLDAPDAO.getRequestsWProcStatus:", "Searching for requests, base: " + reqDN + ", filter: " + filter);
            results = this.m_dirCtx.search(reqDN, filter, ctl);
            list = new ArrayList<Request>();
            Object attrs = null;
            Object attr = null;
            Object attrName = null;
            while (results.hasMore()) {
                SearchResult res = (SearchResult)results.nextElement();
                Request req = this.ConstructRequest(res);
                if (req == null) continue;
                list.add(req);
            }
            UtilDebug.log(127, "RequestLDAPDAO.getRequestsWProcStatus:", "Number of requests fetched: " + list.size());
        }
        return list;
    }

    public String createRequest(Request req) throws NamingException, InvalidRequestException, ApprovalProcessException {
        int retry;
        ListIterator itr;
        String creator;
        List charvals;
        ListIterator itr2;
        List lst;
        String str = null;
        String id = null;
        if (req == null) {
            UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Can not create null request");
            throw new InvalidRequestException("Request can not be null.");
        }
        if (this.m_dirCtx == null) {
            UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Null directory context. Can not proceed.");
            throw new ApprovalProcessException("Null or uninitialized DB context.");
        }
        RequestOperationData opdata = req.getRequestOpData();
        String toapp = opdata.getTargetApp();
        String op = opdata.getOperation();
        String object = opdata.getObjectKey();
        List objlst = opdata.getObjectInfo();
        int tl = req.getTotalApprovalLevels();
        List ausers = req.getApproverUids();
        List agrps = req.getApproverGroups();
        if (toapp == null || op == null || object == null && objlst == null) {
            UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Invalid request: " + req.toString());
            throw new InvalidRequestException("Request, application, request operation and object id can not be null.");
        }
        if (tl <= 0) {
            UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Invalid total approval levels: " + req.toString());
            throw new InvalidRequestException("Request, application, request operation and object id can not be null.");
        }
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(new BasicAttribute(reqTargetApp, toapp));
        attrs.put(new BasicAttribute(reqOperation, op));
        if (object != null) {
            BasicAttribute objAttr = new BasicAttribute(reqObject);
            objAttr.add(object);
            attrs.put(objAttr);
        }
        attrs.put(new BasicAttribute(objClassAttr, requestClass));
        str = req.getStatus();
        BasicAttribute statusAttr = new BasicAttribute(reqStatus);
        if (str != null) {
            statusAttr.add(str);
        } else {
            statusAttr.add(Request.REQUEST_PENDING_APPROVAL);
        }
        attrs.put(statusAttr);
        str = req.getProcessingStatus();
        if (str != null) {
            BasicAttribute procAttr = new BasicAttribute(reqProcessingStatus);
            procAttr.add(str);
            attrs.put(procAttr);
        }
        if ((lst = opdata.getOperationInfo()) != null && lst.size() > 0) {
            BasicAttribute chgAttr = new BasicAttribute(reqOpInfo);
            itr2 = lst.listIterator();
            while (itr2.hasNext()) {
                str = (String)itr2.next();
                chgAttr.add(str);
            }
            attrs.put(chgAttr);
        }
        if (objlst != null && objlst.size() > 0) {
            BasicAttribute infoAttr = new BasicAttribute(reqObjectInfo);
            itr2 = objlst.listIterator();
            while (itr2.hasNext()) {
                str = (String)itr2.next();
                infoAttr.add(str);
            }
            attrs.put(infoAttr);
        }
        if ((str = opdata.getSourceApp()) != null) {
            BasicAttribute toSourceAttr = new BasicAttribute(reqSourceApp);
            toSourceAttr.add(str);
            attrs.put(toSourceAttr);
        }
        if ((charvals = opdata.getRequestPayload()) != null && charvals.size() > 0) {
            Attribute valAttr = null;
            ListIterator itr3 = charvals.listIterator();
            while (itr3.hasNext()) {
                RequestPayload val = (RequestPayload)itr3.next();
                if (valAttr == null) {
                    valAttr = new BasicAttribute(reqCharData);
                }
                valAttr.add(val.toString());
            }
            if (valAttr != null) {
                attrs.put(valAttr);
            }
        }
        if ((creator = req.getOriginator()) != null) {
            BasicAttribute creatorAttr = new BasicAttribute(reqCreator);
            creatorAttr.add(creator);
            attrs.put(creatorAttr);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(Request.REQUEST_DATE_FORMAT);
        TimeZone tz = TimeZone.getTimeZone(Request.REQUEST_DATE_TIMEZONE);
        sdf.setTimeZone(tz);
        Date date = new Date();
        String dateString = sdf.format(date);
        BasicAttribute cdAttr = new BasicAttribute(reqCreationDate);
        cdAttr.add(dateString);
        attrs.put(cdAttr);
        BasicAttribute lmAttr = new BasicAttribute(reqLastModificationDate);
        lmAttr.add(dateString);
        attrs.put(lmAttr);
        String pol = req.getApprovalPolicyKey();
        if (pol != null) {
            BasicAttribute polAttr = new BasicAttribute(reqApprovalPolicy);
            polAttr.add(pol);
            attrs.put(polAttr);
        }
        BasicAttribute tlAttr = new BasicAttribute(reqTotalApprLevels);
        String str1 = new Integer(tl).toString();
        tlAttr.add(str1);
        attrs.put(tlAttr);
        BasicAttribute clAttr = new BasicAttribute(reqCurrApprLevel, "1");
        attrs.put(clAttr);
        if (ausers != null && ausers.size() > 0) {
            Attribute uidAttr = null;
            itr = ausers.listIterator();
            while (itr.hasNext()) {
                String au = (String)itr.next();
                if (uidAttr == null) {
                    uidAttr = new BasicAttribute(reqApprovers);
                }
                uidAttr.add(au);
            }
            if (uidAttr != null) {
                attrs.put(uidAttr);
            }
        }
        if (agrps != null && agrps.size() > 0) {
            Attribute grpAttr = null;
            itr = agrps.listIterator();
            while (itr.hasNext()) {
                String ag = (String)itr.next();
                if (grpAttr == null) {
                    grpAttr = new BasicAttribute(reqApproverGroups);
                }
                grpAttr.add(ag);
            }
            if (grpAttr != null) {
                attrs.put(grpAttr);
            }
        }
        int maxAttempts = 3;
        for (retry = 0; retry < maxAttempts; ++retry) {
            try {
                if (retry > 0) {
                    attrs.remove(reqIDAttr);
                }
                id = this.generateUniqueID(toapp);
                String dn = reqIDAttr + "=" + id + ",cn=" + toapp + "," + this.m_requestBase;
                BasicAttribute idattr = new BasicAttribute(reqIDAttr);
                idattr.add(id);
                attrs.put(idattr);
                try {
                    DirContext result = this.m_dirCtx.createSubcontext(dn, (Attributes)attrs);
                    break;
                }
                catch (NamingException nex) {
                    NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
                    StringBuffer buf = new StringBuffer();
                    while (namingEnumeration.hasMore()) {
                        Attribute attr = namingEnumeration.next();
                        String attrName = attr.getID();
                        buf.append(attrName).append("=").append(attr.get(0)).append("/");
                    }
                    UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Exception while creating request: " + buf.toString());
                    UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Request is: " + req.toString());
                    UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Exception is: " + nex.getMessage());
                    String msg = nex.getMessage() + " ---" + buf.toString();
                    throw new ApprovalProcessException(msg);
                }
            }
            catch (NameAlreadyBoundException ex) {
                UtilDebug.log(127, "RequestLDAPDAO.createRequest:", "Request id: " + id + " in use. Attempt: " + retry);
                continue;
            }
        }
        if (retry >= maxAttempts) {
            UtilDebug.log(127, "RequestLDAPDAO.createRequest:", retry + " attempts to generate a unique request ID failed, abandoning request creation.");
            throw new ApprovalProcessException("Repeated errors while creating a unique ID for request.");
        }
        return id;
    }

    public List getCreatedRequests(String user, RequestSearchCriteria criteria, int flags) throws NamingException, ApprovalProcessException {
        List rtval = null;
        if (user != null) {
            String andfilter = "(" + reqCreator + "=" + user + ")";
            String filter = this.createFilterFromCriteria(andfilter, criteria);
            rtval = (flags & Request.REQUEST_ALL_DATA) == Request.REQUEST_ALL_DATA ? this.getRequests(filter, allattrs) : ((flags & Request.REQUEST_APPROVAL_DATA) == Request.REQUEST_APPROVAL_DATA ? this.getRequests(filter, apattrs) : ((flags & Request.REQUEST_POLICY_DATA) == Request.REQUEST_POLICY_DATA ? this.getRequests(filter, polattrs) : this.getRequests(filter, opattrs)));
        }
        return rtval;
    }

    public List getRequestsWCriteria(RequestSearchCriteria criteria, int flags) throws NamingException, ApprovalProcessException {
        List rtval = null;
        String filter = this.createFilterFromCriteria(null, criteria);
        rtval = (flags & Request.REQUEST_ALL_DATA) == Request.REQUEST_ALL_DATA ? this.getRequests(filter, allattrs) : ((flags & Request.REQUEST_APPROVAL_DATA) == Request.REQUEST_APPROVAL_DATA ? this.getRequests(filter, apattrs) : ((flags & Request.REQUEST_POLICY_DATA) == Request.REQUEST_POLICY_DATA ? this.getRequests(filter, polattrs) : this.getRequests(filter, opattrs)));
        return rtval;
    }

    public List getPendingRequestsToApprove(String user, List grps, int flags) throws NamingException, ApprovalProcessException {
        List rtval = null;
        if (user != null) {
            StringBuffer filter = new StringBuffer();
            filter.append("(&(").append(reqStatus);
            filter.append("=");
            filter.append(Request.REQUEST_PENDING_APPROVAL).append(")");
            if (grps != null && !grps.isEmpty()) {
                filter.append("(|");
            }
            filter.append("(").append(reqApprovers);
            filter.append("=").append(user).append(")");
            if (grps != null && !grps.isEmpty()) {
                ListIterator iter = grps.listIterator();
                while (iter.hasNext()) {
                    String grp = (String)iter.next();
                    filter.append("(").append(reqApproverGroups);
                    filter.append("=").append(grp).append(")");
                }
                filter.append(")");
            }
            filter.append(")");
            rtval = (flags & Request.REQUEST_ALL_DATA) == Request.REQUEST_ALL_DATA ? this.getRequests(filter.toString(), allattrs) : ((flags & Request.REQUEST_APPROVAL_DATA) == Request.REQUEST_APPROVAL_DATA ? this.getRequests(filter.toString(), apattrs) : ((flags & Request.REQUEST_POLICY_DATA) == Request.REQUEST_POLICY_DATA ? this.getRequests(filter.toString(), polattrs) : this.getRequests(filter.toString(), opattrs)));
        }
        return rtval;
    }

    public void modifyRequest(ModRequest modreq) throws NamingException, ApprovalProcessException, IllegalArgumentException {
        int level;
        Date t;
        if (modreq == null) {
            return;
        }
        String id = modreq.getID();
        String app = modreq.getApp();
        if (id == null || app == null) {
            String msg = "Can not locate request based on id = " + id + ", app = " + app;
            UtilDebug.log(127, "RequestLDAPDAO.modifyRequest:", "Invalid input: request id: " + id + ", app: " + app);
            throw new IllegalArgumentException(msg);
        }
        if (this.m_dirCtx == null) {
            UtilDebug.log(127, "RequestLDAPDAO.modifyRequest:", "Null directory context. Can not proceed.");
            throw new ApprovalProcessException("Null or uninitialized DB context.");
        }
        ArrayList<ModificationItem> attrArray = new ArrayList<ModificationItem>();
        String val = modreq.getStatus();
        if (val != null) {
            BasicAttribute attr = new BasicAttribute(reqStatus, val);
            attrArray.add(new ModificationItem(2, attr));
        }
        val = modreq.getProcessingStatus();
        BasicAttribute procstatattr = new BasicAttribute(reqProcessingStatus);
        if (val != null) {
            procstatattr.add(val);
            attrArray.add(new ModificationItem(2, procstatattr));
        } else if (modreq.deleteProcessingStatus()) {
            attrArray.add(new ModificationItem(2, procstatattr));
        }
        List procs = modreq.getProcessors();
        if (procs != null && procs.size() > 0) {
            BasicAttribute attr = new BasicAttribute(reqProcessedBy);
            ListIterator iter = procs.listIterator();
            while (iter.hasNext()) {
                RequestProcessingHistory proc = (RequestProcessingHistory)iter.next();
                attr.add(proc.formatObject());
            }
            attrArray.add(new ModificationItem(1, attr));
        }
        if ((t = modreq.getCreationTime()) != null) {
            SimpleDateFormat format = new SimpleDateFormat(Request.REQUEST_DATE_FORMAT);
            TimeZone tz = TimeZone.getTimeZone(Request.REQUEST_DATE_TIMEZONE);
            format.setTimeZone(tz);
            StringBuffer buf = new StringBuffer();
            format.format(t, buf, new FieldPosition(0));
            BasicAttribute attr = new BasicAttribute(reqLastModificationDate, buf.toString());
            attrArray.add(new ModificationItem(2, attr));
        }
        if ((level = modreq.getCurrentApprovalLevel()) > 0) {
            String str = new Integer(level).toString();
            BasicAttribute attr = new BasicAttribute(reqCurrApprLevel, str);
            attrArray.add(new ModificationItem(2, attr));
        }
        List users = modreq.getApproverUids();
        BasicAttribute userAttr = new BasicAttribute(reqApprovers);
        if (users != null && users.size() > 0) {
            ListIterator iter = users.listIterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                userAttr.add(user);
            }
        } else if (modreq.deleteApproverUids()) {
            attrArray.add(new ModificationItem(2, userAttr));
        }
        List groups = modreq.getApproverGroups();
        BasicAttribute grpAttr = new BasicAttribute(reqApproverGroups);
        if (groups != null && groups.size() > 0) {
            ListIterator iter = groups.listIterator();
            while (iter.hasNext()) {
                String grp = (String)iter.next();
                grpAttr.add(grp);
            }
        } else if (modreq.deleteApproverGroups()) {
            attrArray.add(new ModificationItem(2, grpAttr));
        }
        String dn = reqIDAttr + "=" + id + ",cn=" + app + "," + this.m_requestBase;
        ModificationItem[] mods = attrArray.toArray(new ModificationItem[0]);
        UtilDebug.log(127, "RequestLDAPDAO.modifyRequest:", "Modifying request: " + dn);
        this.m_dirCtx.modifyAttributes(dn, mods);
    }

    private List getRequests(String filter, String[] rattrs) throws NamingException, ApprovalProcessException {
        if (this.m_dirCtx == null) {
            String msg = "Null directory context. Can not proceed.";
            UtilDebug.log(127, "RequestLDAPDAO.getRequests:", msg);
            throw new ApprovalProcessException(msg);
        }
        SearchControls ctl = new SearchControls();
        ctl.setSearchScope(2);
        ctl.setReturningAttributes(rattrs);
        UtilDebug.log(127, "RequestLDAPDAO.getRequests:", "Searching for requests, base: " + this.m_requestBase + ", filter: " + filter);
        NamingEnumeration<SearchResult> results = this.m_dirCtx.search(this.m_requestBase, filter, ctl);
        ArrayList<Request> list = new ArrayList<Request>();
        Object attrs = null;
        Object attr = null;
        Object attrName = null;
        while (results.hasMore()) {
            SearchResult res = (SearchResult)results.nextElement();
            Request req = this.ConstructRequest(res);
            if (req == null) continue;
            list.add(req);
        }
        UtilDebug.log(127, "RequestLDAPDAO.getRequests:", "Number of requests fetched: " + list.size());
        return list;
    }

    private Request ConstructRequest(SearchResult res) throws NamingException {
        if (res == null) {
            return null;
        }
        Request req = new Request();
        Attributes attrs = null;
        Attribute attr = null;
        String attrName = null;
        attrs = res.getAttributes();
        NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
        while (namingEnumeration.hasMore()) {
            int i;
            attr = namingEnumeration.next();
            attrName = attr.getID();
            if (attrName.equalsIgnoreCase(reqIDAttr)) {
                req.setID((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqTargetApp)) {
                req.setTargetApp((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqSourceApp)) {
                req.setSourceApp((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqObject)) {
                req.setObjectKey((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqOperation)) {
                req.setOperation((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqStatus)) {
                req.setStatus((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqProcessingStatus)) {
                req.setProcessingStatus((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqCreationDate)) {
                req.setCreationDate(((String)attr.get(0)).trim());
                continue;
            }
            if (attrName.equalsIgnoreCase(reqCreator)) {
                req.setCreator((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqLastModificationDate)) {
                req.setLastModDate(((String)attr.get(0)).trim());
                continue;
            }
            if (attrName.equalsIgnoreCase(reqProcessedBy)) {
                for (i = 0; i < attr.size(); ++i) {
                    req.addProcessor((String)attr.get(i));
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqCurrApprLevel)) {
                try {
                    req.setCurrentApprovalLevel(Integer.parseInt((String)attr.get(0)));
                }
                catch (NumberFormatException ex) {
                    req.setCurrentApprovalLevel(-1);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqTotalApprLevels)) {
                try {
                    req.setTotalApprovalLevels(Integer.parseInt((String)attr.get(0)));
                }
                catch (NumberFormatException ex) {
                    req.setTotalApprovalLevels(-1);
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqApprovers)) {
                for (i = 0; i < attr.size(); ++i) {
                    req.addApproverUid((String)attr.get(i));
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqApproverGroups)) {
                for (i = 0; i < attr.size(); ++i) {
                    req.addApproverGroup((String)attr.get(i));
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqApprovalPolicy)) {
                req.setApprovalPolicyKey((String)attr.get(0));
                continue;
            }
            if (attrName.equalsIgnoreCase(reqOpInfo)) {
                for (i = 0; i < attr.size(); ++i) {
                    req.addOperationInfo((String)attr.get(i));
                }
                continue;
            }
            if (attrName.equalsIgnoreCase(reqObjectInfo)) {
                for (i = 0; i < attr.size(); ++i) {
                    req.addObjectInfo((String)attr.get(i));
                }
                continue;
            }
            if (!attrName.equalsIgnoreCase(reqCharData)) continue;
            for (i = 0; i < attr.size(); ++i) {
                RequestPayload val = new RequestPayload();
                val.setValue((String)attr.get(i));
                req.addRequestPayload(val);
            }
        }
        return req;
    }

    private String generateUniqueID(String app) {
        Date date = new Date();
        return Long.toString(date.getTime());
    }

    private String createFilterFromCriteria(String andFilter, RequestSearchCriteria criteria) throws SizeLimitExceededException {
        StringBuffer filter = new StringBuffer();
        char filter_char = '|';
        if (criteria != null && !criteria.isEmpty()) {
            String formatVal;
            String match;
            String key;
            Enumeration keys;
            if (RequestSearchCriteria.CRITERIA_MATCH_ALL.equalsIgnoreCase(criteria.getMatch())) {
                filter_char = '&';
            }
            if (andFilter != null) {
                filter.append("(&").append(andFilter);
            }
            filter.append("(").append(filter_char);
            Hashtable table = criteria.getStatusesMap();
            if (table != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    this.appendFilterComponent(filter, reqStatus, match, key);
                }
            }
            if ((table = criteria.getProcStatusMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    this.appendFilterComponent(filter, reqProcessingStatus, match, key);
                }
            }
            if ((table = criteria.getAppsMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    this.appendFilterComponent(filter, reqTargetApp, match, key);
                }
            }
            if ((table = criteria.getProvOpsMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    this.appendFilterComponent(filter, reqOpInfo, match, key);
                }
            }
            if ((table = criteria.getIDsMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    this.appendFilterComponent(filter, reqIDAttr, match, key);
                }
            }
            if ((table = criteria.getCreationDateMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    formatVal = this.formatKeyVal(reqCreationDate, key);
                    this.appendFilterComponent(filter, reqCreationDate, match, formatVal);
                }
            }
            if ((table = criteria.getLastModDateMap()) != null && (keys = table.keys()) != null) {
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    match = (String)table.get(key);
                    formatVal = this.formatKeyVal(reqLastModificationDate, key);
                    this.appendFilterComponent(filter, reqLastModificationDate, match, formatVal);
                }
            }
            if (andFilter != null) {
                filter.append(")");
            }
        } else if (andFilter != null && andFilter.length() > 0) {
            filter.append(andFilter);
        }
        if (filter.length() > this.MAX_FILTER_SIZE) {
            String msg = "Filter size exceeds " + this.MAX_FILTER_SIZE + " in RequestLDAPDAO.createFilterFromCriteria. Filter is: " + filter.toString();
            throw new SizeLimitExceededException(msg);
        }
        return filter.toString();
    }

    private void appendFilterComponent(StringBuffer buf, String attr, String match, String key) {
        if (buf != null && attr != null && match != null && key != null) {
            if (match.equalsIgnoreCase(RequestSearchCriteria.CRITERIA_NOT_EQUAL_TO)) {
                buf.append("(!(").append(attr).append("=").append(key).append("))");
            } else {
                buf.append("(").append(attr).append(match).append(key).append(")");
            }
        }
    }

    private String getKeyAttr(String key) {
        String rtval = null;
        if (key != null) {
            if (key.equalsIgnoreCase(Request.SRCH_REQUEST_STATUS)) {
                rtval = reqStatus;
            } else if (key.equalsIgnoreCase(Request.SRCH_REQUEST_PROC_STATUS)) {
                rtval = reqProcessingStatus;
            } else if (key.equalsIgnoreCase(Request.SRCH_REQUEST_CREATE_DATE)) {
                rtval = reqCreationDate;
            } else if (key.equalsIgnoreCase(Request.SRCH_REQUEST_OPERATION)) {
                rtval = reqOperation;
            } else if (key.equalsIgnoreCase(Request.SRCH_REQUEST_TARGET_APP)) {
                rtval = reqTargetApp;
            }
        }
        return rtval;
    }

    private String formatKeyVal(String key, String val) {
        return val;
    }
}

