/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.Date;
import java.util.List;
import oracle.idm.provisioning.approval.Request;
import oracle.idm.provisioning.approval.RequestProcessingHistory;

public class ModRequest {
    private String m_id;
    private String m_app;
    private Request m_partialRequest;
    private Date m_date;
    private boolean m_delApprUids;
    private boolean m_delApprGrps;
    private boolean m_delProcStatus;

    public ModRequest(String id, String app) {
        this.m_id = id;
        this.m_app = app;
        this.m_partialRequest = new Request();
        this.m_date = null;
        this.m_delApprUids = false;
        this.m_delApprGrps = false;
        this.m_delProcStatus = false;
    }

    public String getID() {
        return this.m_id;
    }

    public String getApp() {
        return this.m_app;
    }

    public String getStatus() {
        return this.m_partialRequest.getStatus();
    }

    public String getProcessingStatus() {
        return this.m_partialRequest.getProcessingStatus();
    }

    public List getProcessors() {
        return this.m_partialRequest.getProcessors();
    }

    public Date getCreationTime() {
        return this.m_date;
    }

    public int getCurrentApprovalLevel() {
        return this.m_partialRequest.getCurrentApprovalLevel();
    }

    public List getApproverUids() {
        return this.m_partialRequest.getApproverUids();
    }

    public List getApproverGroups() {
        return this.m_partialRequest.getApproverGroups();
    }

    public boolean deleteApproverUids() {
        return this.m_delApprUids;
    }

    public boolean deleteApproverGroups() {
        return this.m_delApprGrps;
    }

    public boolean deleteProcessingStatus() {
        return this.m_delProcStatus;
    }

    public void setStatus(String status) throws IllegalArgumentException {
        if (!Request.isStatusValid(status)) {
            String msg = "Invalid request status " + status;
            throw new IllegalArgumentException(msg);
        }
        this.m_partialRequest.setStatus(status);
    }

    public void setProcessingStatus(String status) throws IllegalArgumentException {
        if (!Request.isProcessingStatusValid(status)) {
            String msg = "Invalid notification status " + status;
            throw new IllegalArgumentException(msg);
        }
        this.m_partialRequest.setProcessingStatus(status);
    }

    public void setTime() {
        this.m_date = new Date();
    }

    public void addProcessor(RequestProcessingHistory proc) {
        if (proc != null) {
            this.m_partialRequest.addProcessor(proc);
        }
    }

    public void setCurrentApprovalLevel(int level) throws IllegalArgumentException {
        if (level <= 0) {
            String msg = "Invalid approval level " + level;
            throw new IllegalArgumentException(msg);
        }
        this.m_partialRequest.setCurrentApprovalLevel(level);
    }

    public void addApproverUid(String user) {
        if (user != null) {
            this.m_partialRequest.addApproverUid(user);
        }
    }

    public void addApproverGroup(String grp) {
        if (grp != null) {
            this.m_partialRequest.addApproverGroup(grp);
        }
    }

    public void setDeleteApproverUids(boolean del) {
        this.m_delApprUids = del;
    }

    public void setDeleteApproverGroups(boolean del) {
        this.m_delApprGrps = del;
    }

    public void setDeleteProcessingStatus(boolean del) {
        this.m_delProcStatus = del;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        strbuf.append(nl).append("------------ Mod Request ------------").append(nl).append("Id         : ").append(this.m_id).append(nl).append("App        : ").append(this.m_app).append(nl).append("Status     : ").append(this.m_partialRequest.getStatus()).append(nl).append("ProcStatus : ").append(this.m_partialRequest.getProcessingStatus()).append(nl).append("Curr Level : ").append(this.m_partialRequest.getCurrentApprovalLevel()).append(nl);
        return strbuf.toString();
    }
}

