/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingException;
import oracle.idm.provisioning.approval.ApprovalCheckContext;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.ApprovalProcessException;
import oracle.idm.provisioning.approval.ApprovalStrategy;
import oracle.idm.provisioning.approval.Approvers;
import oracle.idm.provisioning.approval.InvalidRequestException;
import oracle.idm.provisioning.approval.ModRequest;
import oracle.idm.provisioning.approval.Request;
import oracle.idm.provisioning.approval.RequestDAO;
import oracle.idm.provisioning.approval.RequestDAOFactory;
import oracle.idm.provisioning.approval.RequestOperationData;
import oracle.idm.provisioning.approval.RequestProcessingHistory;
import oracle.idm.provisioning.approval.RequestSearchCriteria;
import oracle.ldap.util.UtilDebug;

public class ExtProcApprovalStrategy
extends ApprovalStrategy {
    public ApprovalCheckContext checkForApproval(RequestOperationData opdata, Object dataCtx) throws NamingException, InvalidRequestException, ApprovalProcessException {
        ApprovalCheckContext rtval = null;
        UtilDebug.log(127, "ExtProcApprovalStrategy:checkForApproval", "Checking if approval is needed for request.");
        if (DATA_FROM_APPROVED_REQ.equalsIgnoreCase((String)dataCtx)) {
            rtval = new ApprovalCheckContext(null, false, ApprovalCheckContext.APPROVAL_NOT_NEEDED);
            return rtval;
        }
        if (opdata == null) {
            String msg = "Null request data passed to checkForApproval.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.checkForApproval:", msg);
            throw new InvalidRequestException(msg);
        }
        String app = opdata.getTargetApp();
        String op = opdata.getOperation();
        List objinfo = opdata.getObjectInfo();
        String objkey = opdata.getObjectKey();
        List pols = null;
        try {
            UtilDebug.log(127, "ExtProcApprovalStrategy.checkForApproval:", "Getting approval policies for app: " + app + ", operation: " + op);
            pols = this.getApprovalPolicies(app, op);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ExtProcApprovalStrategy.checkForApproval:", ex);
            throw new InvalidRequestException(ex.getMessage());
        }
        boolean match = false;
        ApprovalPolicy matchedPol = null;
        if (pols != null) {
            ListIterator iter = pols.listIterator();
            while (iter.hasNext()) {
                ApprovalPolicy pol = (ApprovalPolicy)iter.next();
                UtilDebug.log(127, "ExtProcApprovalStrategy.checkForApproval:", "Evaluating policy for match with request: , policy: " + pol.getName());
                match = this.isMatch(pol, opdata);
                if (!match) continue;
                matchedPol = pol;
                break;
            }
        }
        if (match) {
            UtilDebug.log(127, "ExtProcApprovalStrategy:checkForApproval", "Approval needed. Creating request.");
            if (app == null || op == null || objkey == null && objinfo == null) {
                StringBuffer info = null;
                if (info != null) {
                    ListIterator iter = objinfo.listIterator();
                    while (iter.hasNext()) {
                        info.append((String)iter.next()).append(", ");
                    }
                }
                String msg = "Invalid operation data, can not create request, app: " + app + ", op: " + op + ", object key: " + objkey + ", object info: " + info.toString();
                UtilDebug.log(127, "ExtProcApprovalStrategy.checkForApproval:", msg);
                throw new InvalidRequestException(msg);
            }
            Request req = new Request();
            req.setRequestOpData(opdata);
            req.setProcessingStatus(Request.CREATION_NOTIFICATION_PENDING);
            req.setTotalApprovalLevels(matchedPol.getApprovalLevels());
            req.setCurrentApprovalLevel(1);
            req.setApprovalPolicyKey(matchedPol.getKey());
            Approvers alist = this.getApproversForLevel(matchedPol.getKey(), 1);
            boolean gotapprovers = false;
            if (alist != null) {
                List roles;
                List rusers;
                List groups;
                List users = alist.getApproverUsers();
                if (users != null && users.size() > 0) {
                    req.setApproverUids(users);
                    gotapprovers = true;
                }
                if ((groups = alist.getApproverGroups()) != null && groups.size() > 0) {
                    req.setApproverGroups(groups);
                    gotapprovers = true;
                }
                if ((rusers = this.getUsersFromRoles(roles = alist.getApproverRoleNames(), objkey, objinfo)) != null) {
                    ListIterator iter = rusers.listIterator();
                    while (iter.hasNext()) {
                        String user = (String)iter.next();
                        if (user == null) continue;
                        req.addApproverUid(user);
                    }
                    gotapprovers = true;
                }
            }
            UtilDebug.log(127, "ExtProcApprovalStrategy:checkForApproval", "Request approvers: " + gotapprovers);
            String id = this.storeRequest(req);
            req.setID(id);
            UtilDebug.log(127, "ExtProcApprovalStrategy:checkForApproval", "Created request with id: " + id + ", app: " + app);
            rtval = new ApprovalCheckContext(req, true, ApprovalCheckContext.REQUEST_PENDING_FOR_APPROVAL);
        } else {
            rtval = new ApprovalCheckContext(null, false, ApprovalCheckContext.APPROVAL_NOT_NEEDED);
        }
        return rtval;
    }

    public Object processRequest(Object evt, String targetApp, String sourceApp, Object evtCtx) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        return null;
    }

    public ModRequest approveForLevel(String id, String app, String processor, int atlevel, int nextlevel) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        Request req = this.preProcessRequest(id, app, processor);
        ModRequest modreq = null;
        if (req != null) {
            int currlevel = req.getCurrentApprovalLevel();
            if (currlevel > atlevel) {
                String msg = "Processing error... Incoming approval level " + atlevel + " is > current level of request: " + currlevel;
                UtilDebug.log(127, "ExtProcApprovalStrategy.approveForLevel:", msg);
                throw new ApprovalProcessException(msg);
            }
            if (nextlevel < atlevel) {
                String msg = "Processing error... Incoming approval level " + atlevel + " is > next level for request: " + nextlevel;
                UtilDebug.log(127, "ExtProcApprovalStrategy.approveForLevel:", msg);
                throw new ApprovalProcessException(msg);
            }
            try {
                modreq = new ModRequest(id, app);
                Date date = new Date();
                RequestProcessingHistory proc = new RequestProcessingHistory(processor, Request.REQUEST_APPROVED, date);
                modreq.addProcessor(proc);
                modreq.setTime();
                ApprovalProcessException aex = null;
                int total = req.getTotalApprovalLevels();
                if (atlevel == total) {
                    modreq.setStatus(Request.REQUEST_APPROVED);
                    modreq.setProcessingStatus(Request.COMPLETION_NOTIFICATION_PENDING);
                }
                if (atlevel <= total) {
                    if (nextlevel <= total) {
                        modreq.setCurrentApprovalLevel(nextlevel);
                    }
                    String pol = req.getApprovalPolicyKey();
                    RequestOperationData opdata = req.getRequestOpData();
                    List objinfo = null;
                    String objkey = null;
                    if (opdata != null) {
                        objinfo = opdata.getObjectInfo();
                        objkey = opdata.getObjectKey();
                    }
                    Approvers al = null;
                    try {
                        al = this.getApproversForLevel(pol, nextlevel);
                    }
                    catch (Exception ex) {
                        aex = new ApprovalProcessException(ex.getMessage());
                    }
                    if (al != null) {
                        List grps;
                        List users = al.getApproverUsers();
                        if (users != null) {
                            ListIterator iter = users.listIterator();
                            while (iter.hasNext()) {
                                String user = (String)iter.next();
                                modreq.addApproverUid(user);
                            }
                        }
                        if ((grps = al.getApproverGroups()) != null) {
                            ListIterator iter = grps.listIterator();
                            while (iter.hasNext()) {
                                String grp = (String)iter.next();
                                modreq.addApproverGroup(grp);
                            }
                        } else {
                            modreq.setDeleteApproverGroups(true);
                        }
                        List roles = al.getApproverRoleNames();
                        List rusers = this.getUsersFromRoles(roles, objkey, objinfo);
                        if (rusers != null) {
                            ListIterator iter = rusers.listIterator();
                            while (iter.hasNext()) {
                                String roleuser = (String)iter.next();
                                modreq.addApproverUid(roleuser);
                            }
                        }
                        if (users == null && rusers == null) {
                            modreq.setDeleteApproverUids(true);
                        }
                    }
                } else {
                    String msg = "Processing error... Incoming approval level " + atlevel + " is greater than total approval levels " + total;
                    UtilDebug.log(127, "ExtProcApprovalStrategy.approveForLevel:", msg);
                    aex = new ApprovalProcessException(msg);
                    modreq.setStatus(Request.PROCESSING_ERROR);
                }
                RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
                String str = "Modifying request: " + modreq.toString();
                UtilDebug.log(127, "ExtProcApprovalStrategy.approveForLevel:", str);
                reqDao.modifyRequest(modreq);
                if (aex != null) {
                    String msg = "Propagating approval process exception: " + aex.getMessage();
                    UtilDebug.log(127, "ExtProcApprovalStrategy.approveForLevel:", msg);
                    throw aex;
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ApprovalProcessException(ex.getMessage());
            }
        }
        return modreq;
    }

    public void approveRequest(String id, String app, String processor) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        Request req = this.preProcessRequest(id, app, processor);
        if (req == null) {
            String msg = "Could not locate request: " + id + ", " + app + ", " + processor;
            throw new ApprovalProcessException(msg);
        }
        if (req != null) {
            try {
                ModRequest modreq = new ModRequest(id, app);
                modreq.setProcessingStatus(Request.COMPLETION_NOTIFICATION_PENDING);
                RequestProcessingHistory proc = new RequestProcessingHistory(processor, Request.REQUEST_APPROVED, new Date());
                modreq.addProcessor(proc);
                modreq.setTime();
                modreq.setStatus(Request.REQUEST_APPROVED);
                RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
                String str = "Modifying request: " + modreq.toString();
                UtilDebug.log(127, "ExtProcApprovalStrategy.approveRequest:", str);
                reqDao.modifyRequest(modreq);
            }
            catch (IllegalArgumentException ex) {
                throw new ApprovalProcessException(ex.getMessage());
            }
        }
    }

    public void rejectRequest(String id, String app, String processor) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        Request req = this.preProcessRequest(id, app, processor);
        if (req != null) {
            try {
                ModRequest modreq = new ModRequest(id, app);
                modreq.setProcessingStatus(Request.COMPLETION_NOTIFICATION_PENDING);
                RequestProcessingHistory proc = new RequestProcessingHistory(processor, Request.REQUEST_REJECTED, new Date());
                modreq.addProcessor(proc);
                modreq.setTime();
                modreq.setStatus(Request.REQUEST_REJECTED);
                RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
                String str = "Modifying request: " + modreq.toString();
                UtilDebug.log(127, "ExtProcApprovalStrategy.rejectRequest:", str);
                reqDao.modifyRequest(modreq);
            }
            catch (IllegalArgumentException ex) {
                throw new ApprovalProcessException(ex.getMessage());
            }
        }
    }

    public List getRequestsToNotify(String app, Object ctx) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        throw new ApprovalProcessException("External Approval: Method not supported.");
    }

    public void updateNotifiedRequest(String id, String app) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        throw new ApprovalProcessException("External Approval: Method not supported.");
    }

    public List getRequestsForUser(String user, RequestSearchCriteria criteria, String userrole) throws NamingException, ApprovalProcessException {
        List rtval = null;
        if (ApprovalStrategy.ORIGINATOR_ROLE.equalsIgnoreCase(userrole)) {
            rtval = this.getCreatedRequests(user, criteria, Request.REQUEST_OPERATION_DATA);
        } else if (ApprovalStrategy.APPROVER_ROLE.equalsIgnoreCase(userrole)) {
            if (criteria == null || criteria.isEmpty()) {
                rtval = this.getPendingRequestsToApprove(user, Request.REQUEST_OPERATION_DATA);
            }
        } else {
            String msg = "Unknown role: " + userrole + " to ExtProcApprovalStrategy.getRequestsForUser.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.getRequestsForUser:", msg);
            throw new ApprovalProcessException(msg);
        }
        return rtval;
    }

    public Request getRequest(String user, String id, String app) throws NamingException, ApprovalProcessException {
        Request rtval = this.getRequest(id, app, Request.REQUEST_ALL_DATA);
        boolean allow = this.checkUserAccess(user, rtval);
        if (!allow) {
            String msg = "Only a request creator, approver or administrator can access this request.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.getRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        rtval.setApprovalPolicyKey(null);
        return rtval;
    }

    public Approvers getApproversForLevel(String user, String id, String app, int level) throws NamingException, ApprovalProcessException {
        if (user == null || id == null || app == null || level <= 0) {
            String msg = "Invalid arguments toExtProcApprovalStrategy.getApprovers: user: " + user + ", id: " + id + ", app: " + app + ", level:" + level;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getApprovers:", msg);
            throw new IllegalArgumentException(msg);
        }
        Request req = this.getRequest(id, app, Request.REQUEST_APPROVAL_DATA);
        if (req == null) {
            String msg = "Can not find request, id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getApprovers:", msg);
            throw new ApprovalProcessException(msg);
        }
        Approvers rtval = null;
        boolean access = this.checkUserAccess(user, req);
        if (!access) {
            String msg = "Invalid access. Only request creator, approver or administrator can access this information.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.getApprovers:", msg);
            throw new ApprovalProcessException(msg);
        }
        String pol = req.getApprovalPolicyKey();
        rtval = this.getApproversForLevel(pol, level);
        return rtval;
    }

    public List getAllApprovers(String user, String id, String app) throws NamingException, ApprovalProcessException {
        if (user == null || id == null || app == null) {
            String msg = "Invalid arguments toExtProcApprovalStrategy.getApprovers: user: " + user + ", id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getAllApprovers:", msg);
            throw new IllegalArgumentException(msg);
        }
        Request req = this.getRequest(id, app, Request.REQUEST_APPROVAL_DATA);
        if (req == null) {
            String msg = "Can not find request, id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getAllApprovers:", msg);
            throw new ApprovalProcessException(msg);
        }
        List rtval = null;
        boolean access = this.checkUserAccess(user, req);
        if (!access) {
            String msg = "Invalid access. Only request creator, approver or administrator can access this information.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.getAllApprovers:", msg);
            throw new ApprovalProcessException(msg);
        }
        String pol = req.getApprovalPolicyKey();
        rtval = this.getApprovers(pol);
        Collections.sort(rtval);
        return rtval;
    }

    public List getAllowedActions(String user, String id, String app) throws NamingException, ApprovalProcessException {
        if (user == null || id == null || app == null) {
            String msg = "Invalid arguments toExtProcApprovalStrategy.getAllowedActions: user: " + user + ", id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getAllowedActions:", msg);
            throw new IllegalArgumentException(msg);
        }
        Request req = this.getRequest(id, app, Request.REQUEST_ALL_DATA);
        if (req == null) {
            String msg = "Can not find request, id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.getAllowedActions:", msg);
            throw new ApprovalProcessException(msg);
        }
        List rtval = this.getAllActions(user, req);
        return rtval;
    }

    protected Request preProcessRequest(String id, String app, String processor) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        if (processor == null || id == null || app == null) {
            String msg = "Invalid arguments toExtProcApprovalStrategy.processRequest: processor: " + processor + ", id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.preProcessRequest:", msg);
            throw new IllegalArgumentException(msg);
        }
        Request req = this.getRequest(id, app, Request.REQUEST_ALL_DATA);
        if (req == null) {
            String msg = "Can not find request to approve, id: " + id + ", app: " + app;
            UtilDebug.log(127, "ExtProcApprovalStrategy.processRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        String status = req.getStatus();
        if (status.equalsIgnoreCase(Request.REQUEST_CANCELLED) || status.equalsIgnoreCase(Request.REQUEST_REJECTED) || status.equalsIgnoreCase(Request.REQUEST_APPROVED)) {
            String msg = "Can not process a completed request, id: " + id + ", app: " + app + ", request status: " + status;
            UtilDebug.log(127, "ExtProcApprovalStrategy.processRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        boolean valid = this.isValidApprover(req, processor);
        if (!valid) {
            String msg = "Only valid approver or administrator can approve or reject a request.";
            UtilDebug.log(127, "ExtProcApprovalStrategy.preProcessRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        return req;
    }

    private List getUsersFromRoles(List roles, String objkey, List objinfo) {
        ArrayList<String> rtval = null;
        if (roles != null && roles.size() > 0) {
            ListIterator iter = roles.listIterator();
            while (iter.hasNext()) {
                String role = (String)iter.next();
                try {
                    String user = this.resolveApproverRole(role, objkey, objinfo);
                    if (user == null) continue;
                    if (rtval == null) {
                        rtval = new ArrayList<String>();
                    }
                    rtval.add(user);
                }
                catch (Exception ex) {
                    String msg = "Error while resolving role: " + role + ", error: " + ex.getMessage();
                    UtilDebug.log(127, "ExtProcApprovalStrategy:getUsersFromRoles", msg);
                }
            }
        }
        return rtval;
    }
}

