/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.idm.provisioning.approval.Approvers;
import oracle.idm.provisioning.approval.ApproversDAO;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;

public class ApproversLDAPDAO
extends ApproversDAO {
    private static String objClassAttr = "objectclass";
    private static String approverListClass = "orclapproverlist";
    private static String topClass = "top";
    private static String basicApproversFilter = "(objectclass=orclapproverlist)";
    private static String alName = "cn";
    private static String alApproverUidAttr = "orclprovapproveruid";
    private static String alApproverGroupAttr = "orclprovapprovergroupuid";
    private static String alApproverRoleAttr = "orclprovapproverrole";
    private static String alApproverLevelAttr = "orclapproverlevel";
    private static String alDescription = "orclapprovaldescription";
    public DirContext m_dirCtx;

    public ApproversLDAPDAO(DirContext ctx) {
        this.m_dirCtx = ctx;
    }

    public List getApproversUids(String policyUid) throws NamingException, IllegalArgumentException {
        ArrayList<String> rtval = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversUid:", nex);
            throw nex;
        }
        if (policyUid != null) {
            String[] attrs = new String[]{};
            SearchControls ctl = new SearchControls();
            ctl.setSearchScope(1);
            ctl.setReturningAttributes(attrs);
            NamingEnumeration<SearchResult> results = null;
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversUid:", "Searching with base: " + policyUid + ", filter: " + basicApproversFilter);
            results = this.m_dirCtx.search(policyUid, basicApproversFilter, ctl);
            if (results != null) {
                rtval = new ArrayList<String>();
                while (results.hasMore()) {
                    SearchResult res = (SearchResult)results.nextElement();
                    String ap = res.getName() + "," + policyUid;
                    rtval.add(ap);
                }
                UtilDebug.log(127, "ApproversLDAPDAO.getApproversUids:", "Number of results fetched: " + rtval.size());
            }
        } else {
            IllegalArgumentException ex = new IllegalArgumentException("Null policy uid.");
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversUids:", ex);
            throw ex;
        }
        return rtval;
    }

    public List getApprovers(String policyUid) throws NamingException, IllegalArgumentException {
        ArrayList<Approvers> list = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.getApprovers:", nex);
            throw nex;
        }
        if (policyUid != null) {
            SearchControls ctl = new SearchControls();
            ctl.setSearchScope(1);
            NamingEnumeration<SearchResult> results = null;
            UtilDebug.log(127, "ApproversLDAPDAO.getApprovers:", "Searching with base: " + policyUid + ", filter: " + basicApproversFilter);
            results = this.m_dirCtx.search(policyUid, basicApproversFilter, ctl);
            if (results != null) {
                list = new ArrayList<Approvers>();
                Approvers aplist = null;
                while (results.hasMore()) {
                    SearchResult res = (SearchResult)results.nextElement();
                    aplist = this.createApproversObject(res);
                    list.add(aplist);
                }
                UtilDebug.log(127, "ApproversLDAPDAO.getApprovers:", "Number of results fetched: " + list.size());
            }
        } else {
            IllegalArgumentException ex = new IllegalArgumentException("Null policy uid.");
            UtilDebug.log(127, "ApproversLDAPDAO.getApprovers:", ex);
            throw ex;
        }
        return list;
    }

    public Approvers getApproversForLevel(String policyUid, int level) throws NamingException, IllegalArgumentException {
        Approvers rtval = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversForLevel:", nex);
            throw nex;
        }
        if (policyUid != null && level > 0) {
            String filter = "(&(" + objClassAttr + "=" + approverListClass + ")(" + alApproverLevelAttr + "=" + level + "))";
            SearchControls ctl = new SearchControls();
            ctl.setSearchScope(1);
            NamingEnumeration<SearchResult> results = null;
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversForLevel:", "Searching with base: " + policyUid + ", filter: " + filter);
            results = this.m_dirCtx.search(policyUid, filter, ctl);
            if (results != null) {
                SearchResult res = null;
                if (results.hasMore()) {
                    res = (SearchResult)results.nextElement();
                }
                if (results.hasMore()) {
                    NamingException nex = new NamingException("Multiple approver lists for same level, do not know how to proceed.");
                    UtilDebug.log(127, "ApproversLDAPDAO.getApproversForLevel:", nex);
                    throw nex;
                }
                rtval = this.createApproversObject(res);
            }
        } else {
            String msg = "Invalid input, policyUid: " + policyUid + ", level: " + level;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.getApproversForLevel:", ex);
            throw ex;
        }
        return rtval;
    }

    public List modifyApprovers(String policyuid, Approvers newappr, boolean addIfNotPresent) throws NamingException, IllegalArgumentException {
        ListIterator iter;
        BasicAttribute attr;
        ArrayList<String> rtval = new ArrayList<String>();
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", nex);
            throw nex;
        }
        if (policyuid == null || newappr == null) {
            String msg = "Invalid input, policyUid: " + policyuid + ", or null set of approvers.";
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", ex);
            throw ex;
        }
        int level = newappr.getLevel();
        if (level <= 0) {
            String msg = "Invalid level " + level;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", ex);
            throw ex;
        }
        Approvers oldappr = null;
        try {
            oldappr = this.getApproversForLevel(policyuid, level);
        }
        catch (NameNotFoundException nex) {
            // empty catch block
        }
        if (oldappr == null) {
            if (!addIfNotPresent) {
                String msg = "Approvers for level " + level + " do not exist for policy " + policyuid;
                NamingException ex = new NamingException(msg);
                UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", ex);
                throw ex;
            }
            this.addApprovers(policyuid, newappr);
            return null;
        }
        ArrayList<ModificationItem> attrArray = new ArrayList<ModificationItem>();
        String olddescr = oldappr.getDescription();
        String newdescr = newappr.getDescription();
        if (newdescr != null) {
            if (!newdescr.equalsIgnoreCase(olddescr)) {
                attr = new BasicAttribute(alDescription, newdescr);
                attrArray.add(new ModificationItem(2, attr));
            }
        } else if (olddescr != null) {
            attr = new BasicAttribute(alDescription);
            attrArray.add(new ModificationItem(3, attr));
        }
        List oldusers = oldappr.getApproverUsers();
        List oldgrps = oldappr.getApproverGroups();
        List oldroles = oldappr.getApproverRoleNames();
        List newusers = newappr.getApproverUsers();
        List newgrps = newappr.getApproverGroups();
        List newroles = newappr.getApproverRoleNames();
        boolean chguser = false;
        boolean chggrp = false;
        boolean chgrole = false;
        int newsize = 0;
        int oldsize = 0;
        newsize = newusers != null ? newusers.size() : 0;
        int n = oldsize = oldusers != null ? oldusers.size() : 0;
        if (newsize != oldsize) {
            chguser = true;
        } else {
            boolean match = false;
            try {
                match = newusers.containsAll(oldusers);
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = chguser = !match;
        }
        if (chguser) {
            BasicAttribute attr2 = new BasicAttribute(alApproverUidAttr);
            if (newsize == 0) {
                attrArray.add(new ModificationItem(3, attr2));
            } else {
                iter = newusers.listIterator();
                while (iter.hasNext()) {
                    String user = (String)iter.next();
                    attr2.add(user);
                }
                attrArray.add(new ModificationItem(2, attr2));
            }
            rtval.add("user");
        }
        newsize = newgrps != null ? newgrps.size() : 0;
        int n2 = oldsize = oldgrps != null ? oldgrps.size() : 0;
        if (newsize != oldsize) {
            chggrp = true;
        } else {
            boolean match = false;
            try {
                match = newgrps.containsAll(oldgrps);
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = chggrp = !match;
        }
        if (chggrp) {
            BasicAttribute attr3 = new BasicAttribute(alApproverGroupAttr);
            if (newsize == 0) {
                attrArray.add(new ModificationItem(3, attr3));
            } else {
                iter = newgrps.listIterator();
                while (iter.hasNext()) {
                    String grp = (String)iter.next();
                    attr3.add(grp);
                    attrArray.add(new ModificationItem(2, attr3));
                }
            }
            rtval.add("group");
        }
        newsize = newroles != null ? newroles.size() : 0;
        int n3 = oldsize = oldroles != null ? oldroles.size() : 0;
        if (newsize != oldsize) {
            chgrole = true;
        } else {
            boolean match = false;
            try {
                match = newroles.containsAll(oldroles);
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = chgrole = !match;
        }
        if (chgrole) {
            BasicAttribute attr4 = new BasicAttribute(alApproverRoleAttr);
            if (newsize == 0) {
                attrArray.add(new ModificationItem(3, attr4));
            } else {
                iter = newroles.listIterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    attr4.add(role);
                    attrArray.add(new ModificationItem(2, attr4));
                }
            }
            rtval.add("manager");
        }
        if (attrArray.size() > 0) {
            ModificationItem[] mods = attrArray.toArray(new ModificationItem[0]);
            String uid = alName + "=" + oldappr.getName() + "," + policyuid;
            UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", "Modifying approvers: " + uid);
            this.m_dirCtx.modifyAttributes(uid, mods);
        } else {
            UtilDebug.log(127, "ApproversLDAPDAO.modifyApprovers:", "Modifying approvers: no information changed.");
        }
        return rtval;
    }

    public void addApprovers(String policyuid, Approvers approvers) throws NamingException, IllegalArgumentException {
        BasicAttribute attr;
        ListIterator iter;
        BasicAttribute attr2;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.addApprovers:", nex);
            throw nex;
        }
        if (policyuid == null || approvers == null) {
            String msg = "Invalid input, policyuid: " + policyuid + ", or null set of approvers.";
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.addApprovers:", ex);
            throw ex;
        }
        int level = approvers.getLevel();
        if (level <= 0) {
            String msg = "Invalid level " + level;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.addApprovers:", ex);
            throw ex;
        }
        String uid = this.getApproversUid(policyuid, level);
        if (uid != null) {
            String msg = "Approvers for level " + level + " already exist for policy " + policyuid;
            NamingException ex = new NamingException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.addApprovers:", ex);
            throw ex;
        }
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute lattr = new BasicAttribute(alApproverLevelAttr);
        StringBuffer buf = new StringBuffer();
        buf.append(level);
        lattr.add(buf.toString());
        attrs.put(lattr);
        BasicAttribute oattr = new BasicAttribute(objClassAttr);
        oattr.add(approverListClass);
        oattr.add(topClass);
        attrs.put(oattr);
        String descr = approvers.getDescription();
        if (descr != null) {
            BasicAttribute dattr = new BasicAttribute(alDescription);
            attrs.put(dattr);
        }
        List users = approvers.getApproverUsers();
        List grps = approvers.getApproverGroups();
        List roles = approvers.getApproverRoleNames();
        if (users != null && users.size() > 0) {
            attr2 = new BasicAttribute(alApproverUidAttr);
            iter = users.listIterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                attr2.add(user);
            }
            attrs.put(attr2);
        }
        if (grps != null && grps.size() > 0) {
            attr2 = new BasicAttribute(alApproverGroupAttr);
            iter = grps.listIterator();
            while (iter.hasNext()) {
                String grp = (String)iter.next();
                attr2.add(grp);
            }
            attrs.put(attr2);
        }
        if (roles != null && roles.size() > 0) {
            attr2 = new BasicAttribute(alApproverRoleAttr);
            iter = roles.listIterator();
            while (iter.hasNext()) {
                String role = (String)iter.next();
                attr2.add(role);
            }
            attrs.put(attr2);
        }
        String name = approvers.getName();
        StringBuffer dn = new StringBuffer();
        dn.append(alName).append("=");
        if (name != null) {
            dn.append(name);
            attr = new BasicAttribute(alName, name);
            attrs.put(attr);
        } else {
            dn.append(level);
            attr = new BasicAttribute(alName, buf.toString());
            attrs.put(attr);
        }
        dn.append(",").append(policyuid);
        UtilDebug.log(127, "ApproversLDAPDAO.addApprovers:", "Adding approvers: " + dn);
        DirContext result = this.m_dirCtx.createSubcontext(dn.toString(), (Attributes)attrs);
    }

    public void deleteApprovers(String policyuid, String name, int level) throws NamingException, IllegalArgumentException {
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.deleteApprovers:", nex);
            throw nex;
        }
        if (policyuid == null) {
            String msg = "Invalid policyUid: " + policyuid;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApproversLDAPDAO.deleteApprovers:", ex);
            throw ex;
        }
        String uid = null;
        if (name == null) {
            uid = this.getApproversUid(policyuid, level);
            if (uid == null) {
                String msg = "Approvers for level " + level + " do not exist for policy " + policyuid;
                NamingException ex = new NamingException(msg);
                UtilDebug.log(127, "ApproversLDAPDAO.deleteApprovers:", ex);
                throw ex;
            }
        } else {
            uid = alName + "=" + name + "," + policyuid;
        }
        this.deleteApprovers(uid);
    }

    public void deleteApprovers(String approversuid) throws NamingException, IllegalArgumentException {
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApproversLDAPDAO.deleteApprovers:", nex);
            throw nex;
        }
        UtilDebug.log(127, "ApproversLDAPDAO.deleteApprovers:", "Deleting approvers: " + approversuid);
        this.m_dirCtx.destroySubcontext(approversuid);
    }

    private Approvers createApproversObject(SearchResult res) throws NamingException {
        Approvers rtval = null;
        if (res != null) {
            rtval = new Approvers();
            Attributes attrs = null;
            Attribute attr = null;
            String attrName = null;
            attrs = res.getAttributes();
            NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
            while (namingEnumeration.hasMore()) {
                attr = namingEnumeration.next();
                attrName = attr.getID();
                if (attrName.equalsIgnoreCase(alName)) {
                    rtval.setName((String)attr.get(0));
                    continue;
                }
                if (attrName.equalsIgnoreCase(alDescription)) {
                    rtval.setDescription((String)attr.get(0));
                    continue;
                }
                if (attrName.equalsIgnoreCase(alApproverUidAttr)) {
                    for (int i = 0; i < attr.size(); ++i) {
                        String user = (String)attr.get(i);
                        rtval.addUserTrustee(Util.normalizeDN(user));
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(alApproverGroupAttr)) {
                    for (int i = 0; i < attr.size(); ++i) {
                        String grp = (String)attr.get(i);
                        rtval.addGroupTrustee(Util.normalizeDN(grp));
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(alApproverRoleAttr)) {
                    for (int i = 0; i < attr.size(); ++i) {
                        rtval.addApproverRoleByName((String)attr.get(i));
                    }
                    continue;
                }
                if (!attrName.equalsIgnoreCase(alApproverLevelAttr)) continue;
                try {
                    rtval.setLevel(Integer.parseInt((String)attr.get(0)));
                }
                catch (NumberFormatException e) {
                    rtval.setLevel(0);
                }
            }
        }
        return rtval;
    }

    private String getApproversUid(String policyuid, int level) throws NamingException {
        String rtval = null;
        String[] attrs = new String[]{};
        String filter = "(&(" + objClassAttr + "=" + approverListClass + ")(" + alApproverLevelAttr + "=" + level + "))";
        SearchControls ctl = new SearchControls();
        ctl.setSearchScope(1);
        ctl.setReturningAttributes(attrs);
        NamingEnumeration<SearchResult> results = null;
        UtilDebug.log(127, "ApproversLDAPDAO.getApproversUid:", "Searching with base: " + policyuid + ", filter: " + filter);
        try {
            results = this.m_dirCtx.search(policyuid, filter, ctl);
        }
        catch (NameNotFoundException nex) {
            // empty catch block
        }
        if (results != null) {
            SearchResult res = null;
            if (results.hasMore()) {
                res = (SearchResult)results.nextElement();
                if (results.hasMore()) {
                    NamingException nex = new NamingException("Multiple approver lists for same level, do not know how to proceed.");
                    UtilDebug.log(127, "ApproversLDAPDAO.getApproversUid:", nex);
                    throw nex;
                }
                rtval = res.getName() + "," + policyuid;
            }
        }
        return rtval;
    }
}

