/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.idm.provisioning.approval.ApprovalCheckContext;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.ApprovalPolicyDAO;
import oracle.idm.provisioning.approval.ApprovalPolicyDAOFactory;
import oracle.idm.provisioning.approval.ApprovalProcessException;
import oracle.idm.provisioning.approval.Approvers;
import oracle.idm.provisioning.approval.ApproversDAO;
import oracle.idm.provisioning.approval.ApproversDAOFactory;
import oracle.idm.provisioning.approval.InvalidRequestException;
import oracle.idm.provisioning.approval.ModRequest;
import oracle.idm.provisioning.approval.Request;
import oracle.idm.provisioning.approval.RequestDAO;
import oracle.idm.provisioning.approval.RequestDAOFactory;
import oracle.idm.provisioning.approval.RequestOperationData;
import oracle.idm.provisioning.approval.RequestProcessingHistory;
import oracle.idm.provisioning.approval.RequestSearchCriteria;
import oracle.ldap.util.Group;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

public abstract class ApprovalStrategy {
    public static String SYSTEM_APPROVER = "SYSTEM_APPROVER";
    public static String CONTEXT_KEY_DEBUG = "DEBUG";
    public static String CONTEXT_KEY_SESSION = "SESSION";
    public static String ORIGINATOR_ROLE = "requestor";
    public static String APPROVER_ROLE = "approver";
    public static String USER_ACTION_APPROVE = "approve";
    public static String USER_ACTION_REJECT = "reject";
    public static String USER_ACTION_CANCEL = "cancel";
    public static String DATA_FROM_APPROVED_REQ = "approved_req";
    protected static String requestBase = "cn=requests, cn=provisioning, cn=directory integration platform, cn=products, cn=oraclecontext";
    private static String policyBase = "cn=applications, cn=provisioning, cn=directory integration platform, cn=products, cn=oraclecontext";
    protected DirContext m_dirctx = null;
    protected boolean m_cache = false;
    protected Hashtable m_cachedPolicies = null;
    protected String m_source = null;
    private String MANAGER_ATTR = "manager";

    public abstract ApprovalCheckContext checkForApproval(RequestOperationData var1, Object var2) throws NamingException, InvalidRequestException, ApprovalProcessException;

    public abstract Object processRequest(Object var1, String var2, String var3, Object var4) throws IllegalArgumentException, NamingException, ApprovalProcessException;

    public abstract ModRequest approveForLevel(String var1, String var2, String var3, int var4, int var5) throws IllegalArgumentException, NamingException, ApprovalProcessException;

    public abstract void approveRequest(String var1, String var2, String var3) throws IllegalArgumentException, NamingException, ApprovalProcessException;

    public abstract void rejectRequest(String var1, String var2, String var3) throws IllegalArgumentException, NamingException, ApprovalProcessException;

    public abstract List getRequestsToNotify(String var1, Object var2) throws IllegalArgumentException, NamingException, ApprovalProcessException;

    public abstract void updateNotifiedRequest(String var1, String var2) throws NamingException, ApprovalProcessException;

    public abstract List getRequestsForUser(String var1, RequestSearchCriteria var2, String var3) throws NamingException, ApprovalProcessException;

    public abstract Request getRequest(String var1, String var2, String var3) throws NamingException, ApprovalProcessException;

    public abstract Approvers getApproversForLevel(String var1, String var2, String var3, int var4) throws NamingException, ApprovalProcessException;

    public abstract List getAllApprovers(String var1, String var2, String var3) throws NamingException, ApprovalProcessException;

    public abstract List getAllowedActions(String var1, String var2, String var3) throws NamingException, ApprovalProcessException;

    public void setDirectoryCtx(DirContext ctx) {
        this.m_dirctx = ctx;
    }

    public void cachePolicies(boolean mode) {
        this.m_cache = mode;
        if (this.m_cache) {
            if (this.m_cachedPolicies == null) {
                this.m_cachedPolicies = new Hashtable(5);
            } else {
                this.m_cachedPolicies.clear();
            }
        } else if (this.m_cachedPolicies != null) {
            this.m_cachedPolicies.clear();
            this.m_cachedPolicies = null;
        }
        UtilDebug.log(127, "ApprovalStrategy.cachePolicies:", "Changed cache mode to " + mode);
    }

    public boolean clearCache(String key) {
        boolean ret = true;
        if (key == null) {
            this.m_cachedPolicies.clear();
        } else {
            ArrayList toss = (ArrayList)this.m_cachedPolicies.remove(key);
            if (toss == null) {
                ret = false;
            }
        }
        return ret;
    }

    public void setApprovalStrategyContext(String key, Object ctx) {
    }

    public String getRequestStatus(String id, String app) throws NamingException, IllegalArgumentException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        String status = reqDao.getRequestStatus(id, app);
        return status;
    }

    public void cancelRequest(String id, String app, String processor) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        if (processor == null || id == null || app == null) {
            String msg = "Invalid arguments toApprovalStrategy.cancelRequest: processor: " + processor + ", id: " + id + ", app: " + app;
            UtilDebug.log(127, "ApprovalStrategy.cancelRequest:", msg);
            throw new IllegalArgumentException(msg);
        }
        Request req = this.getRequest(id, app, Request.REQUEST_ALL_DATA);
        if (req == null) {
            String msg = "Can not find request to cancel, id: " + id + ", app: " + app;
            UtilDebug.log(127, "ApprovalStrategy.cancelRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        List list = this.getAllActions(processor, req);
        boolean changest = false;
        try {
            changest = list.contains(USER_ACTION_CANCEL);
        }
        catch (Exception ex) {
            changest = false;
        }
        if (!changest) {
            String msg = "Can not cancel request id: " + id + ", app: " + app + " because it is either not in a pending state or because the user does not have necessary privileges.";
            UtilDebug.log(127, "ApprovalStrategy.cancelRequest:", msg);
            throw new ApprovalProcessException(msg);
        }
        if (changest) {
            try {
                ModRequest modreq = new ModRequest(id, app);
                modreq.setStatus(Request.REQUEST_CANCELLED);
                modreq.setDeleteProcessingStatus(true);
                RequestProcessingHistory proc = new RequestProcessingHistory(processor, Request.REQUEST_CANCELLED, new Date());
                RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
                reqDao.modifyRequest(modreq);
            }
            catch (IllegalArgumentException ex) {
                throw new ApprovalProcessException(ex.getMessage());
            }
        }
    }

    protected Request getRequest(String id, String app, int flags) throws IllegalArgumentException, NamingException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        Request req = reqDao.getRequest(id, app, flags);
        return req;
    }

    protected boolean isApprovalNeeded(RequestOperationData req) throws NamingException, InvalidRequestException {
        boolean ret = false;
        List pols = null;
        if (req == null) {
            String msg = "Null request passed to ApprovalStrategy:isApprovalNeeded.";
            UtilDebug.log(127, "ApprovalStrategy.isApprovalNeeded:", msg);
            throw new InvalidRequestException(msg);
        }
        try {
            String app = req.getTargetApp();
            String op = req.getOperation();
            UtilDebug.log(127, "ApprovalStrategy.isApprovalNeeded:", "Getting approval policies for app: " + app + ", operation: " + op);
            pols = this.getApprovalPolicies(app, op);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalStrategy.isApprovalNeeded:", ex);
            throw new InvalidRequestException(ex.getMessage());
        }
        ret = this.isApprovalNeeded(req, pols);
        return ret;
    }

    protected boolean checkUserAccess(String user, Request req) throws NamingException, InvalidRequestException {
        String normcre;
        String normproc;
        if (req == null || user == null) {
            UtilDebug.log(127, "ApprovalStrategy.checkUserAccess:", "Invalid request or user: " + user);
            return false;
        }
        if (user.equalsIgnoreCase(SYSTEM_APPROVER)) {
            UtilDebug.log(127, "ApprovalStrategy.checkUserAccess:", "SYSTEM_APPROVER is valid approver.");
            return true;
        }
        boolean ret = false;
        String creator = req.getOriginator();
        if (creator != null && (normproc = Util.normalizeDN(user)).equalsIgnoreCase(normcre = Util.normalizeDN(creator))) {
            ret = true;
        }
        if (!ret) {
            ret = this.isValidApprover(req, user);
        }
        return ret;
    }

    protected boolean isValidApprover(Request req, String approverDN) throws NamingException, InvalidRequestException {
        List groups;
        List approvers;
        if (req == null || approverDN == null) {
            UtilDebug.log(127, "ApprovalStrategy.isValidApprover:", "Invalid request or approver: " + approverDN);
            return false;
        }
        if (approverDN.equalsIgnoreCase(SYSTEM_APPROVER)) {
            UtilDebug.log(127, "ApprovalStrategy.isValidApprover:", "SYSTEM_APPROVER is valid approver.");
            return true;
        }
        boolean ret = false;
        ret = this.isAdmin(approverDN);
        if (!ret && (approvers = req.getApproverUids()) != null) {
            String normApp = Util.normalizeDN(approverDN);
            ListIterator iter = approvers.listIterator();
            while (iter.hasNext()) {
                String user = Util.normalizeDN((String)iter.next());
                if (!normApp.equalsIgnoreCase(user)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && (groups = req.getApproverGroups()) != null) {
            ListIterator iter = groups.listIterator();
            while (iter.hasNext()) {
                String grpDN = (String)iter.next();
                try {
                    Group grp = new Group(Util.IDTYPE_DN, grpDN);
                    ret = grp.isMember(this.m_dirctx, approverDN, true);
                }
                catch (UtilException ex) {
                    UtilDebug.log(127, "ApprovalStrategy.isValidApprover:", "Exception while resolveing group membership for " + approverDN + ", group: " + grpDN + ", request: " + req.getID() + ", exception: " + ex.getMessage());
                }
                if (!ret) continue;
                break;
            }
        }
        if (ret) {
            UtilDebug.log(127, "ApprovalStrategy.isValidApprover:", "Valid approver: " + approverDN + ", request: " + req.getID());
        }
        return ret;
    }

    protected List getCreatedRequests(String user, RequestSearchCriteria criteria, int flags) throws NamingException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        List rtval = reqDao.getCreatedRequests(user, criteria, flags);
        return rtval;
    }

    protected List getRequestsWCriteria(RequestSearchCriteria criteria, int flags) throws NamingException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        List rtval = reqDao.getRequestsWCriteria(criteria, flags);
        return rtval;
    }

    protected List getPendingRequestsToApprove(String user, int flags) throws NamingException, ApprovalProcessException {
        ArrayList<String> usergrps = null;
        String[] attrs = new String[]{"dn"};
        PropertySetCollection psc = null;
        try {
            psc = Util.getGroupMembership(this.m_dirctx, user, attrs, true);
        }
        catch (UtilException ex) {
            UtilDebug.log(127, "ApprovalStrategy.isValidApprover:", "Exception while getting group membership for user: " + user + ", exception: " + ex.getMessage());
            throw new ApprovalProcessException(ex.getMessage());
        }
        int pssize = psc.size();
        if (pssize > 0) {
            usergrps = new ArrayList<String>();
            for (int i = 0; i < pssize; ++i) {
                PropertySet pset = psc.getPropertySet(i);
                usergrps.add(pset.getDN());
            }
        }
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        List rtval = reqDao.getPendingRequestsToApprove(user, usergrps, flags);
        return rtval;
    }

    protected List getRequestsWProcStatus(String app, String procstatus) throws NamingException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        List list = reqDao.getRequestsWProcStatus(app, procstatus);
        return list;
    }

    protected boolean isApprovalNeeded(RequestOperationData req, List policies) throws NamingException {
        boolean ret = false;
        if (req == null) {
            return false;
        }
        if (policies != null) {
            ListIterator iter = policies.listIterator();
            while (iter.hasNext()) {
                ApprovalPolicy pol = (ApprovalPolicy)iter.next();
                UtilDebug.log(127, "ApprovalStrategy.isApprovalNeeded:", "Evaluating policy for match with request: , policy: " + pol.getName());
                ret = this.isMatch(pol, req);
                if (!ret) continue;
                break;
            }
        }
        return ret;
    }

    protected boolean isComplete(String status) {
        boolean ret = false;
        if (Request.REQUEST_APPROVED.equalsIgnoreCase(status) || Request.REQUEST_REJECTED.equalsIgnoreCase(status) || Request.REQUEST_CANCELLED.equalsIgnoreCase(status)) {
            ret = true;
        }
        return ret;
    }

    protected Approvers getApproversForLevel(String policyUid, int level) throws NamingException, IllegalArgumentException {
        ApproversDAO apDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        Approvers alist = apDao.getApproversForLevel(policyUid, level);
        return alist;
    }

    protected List getApprovers(String policyUid) throws NamingException, IllegalArgumentException {
        ApproversDAO apDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        List alist = apDao.getApprovers(policyUid);
        return alist;
    }

    protected List getApprovalPolicies(String toApp, String operation) throws NamingException, IllegalArgumentException {
        ArrayList<ApprovalPolicy> pols = null;
        if (toApp == null) {
            UtilDebug.log(127, "ApprovalStrategy:getApprovalPolicies", "Null application name. Can not proceed.");
            return null;
        }
        if (this.m_cache) {
            UtilDebug.log(127, "ApprovalStrategy:getApprovalPolicies", "Cache on, looking up policies in cache for app: " + toApp);
            ArrayList hashVal = (ArrayList)this.m_cachedPolicies.get(toApp);
            boolean add2cache = false;
            if (hashVal == null) {
                UtilDebug.log(127, "ApprovalStrategy:getApprovalPolicies", "Cache miss, fetching policies from the directory for app: " + toApp);
                ApprovalPolicyDAO acDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
                hashVal = acDao.getApprovalPolicies(toApp, null);
                if (hashVal == null) {
                    hashVal = new ArrayList();
                }
                add2cache = true;
            }
            if (operation == null) {
                if (hashVal.size() > 0) {
                    pols = new ArrayList<ApprovalPolicy>(hashVal);
                }
            } else {
                ListIterator itr = hashVal.listIterator();
                while (itr.hasNext()) {
                    ApprovalPolicy pol = (ApprovalPolicy)itr.next();
                    List ops = pol.getOperations();
                    if (!ops.contains(operation)) continue;
                    if (pols == null) {
                        pols = new ArrayList();
                    }
                    pols.add(pol);
                }
            }
            if (add2cache) {
                this.m_cachedPolicies.put(toApp, hashVal);
            }
        } else {
            UtilDebug.log(127, "ApprovalStrategy:getApprovalPolicies", "Fetching policies from the directory for app: " + toApp);
            ApprovalPolicyDAO acDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
            pols = acDao.getApprovalPolicies(toApp, operation);
        }
        return pols;
    }

    protected String storeRequest(Request req) throws InvalidRequestException, NamingException, ApprovalProcessException {
        RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
        String id = reqDao.createRequest(req);
        return id;
    }

    protected void changeRequestStatus(String id, String app, String status, String approver) throws InvalidRequestException, NamingException, ApprovalProcessException {
        try {
            ModRequest modreq = new ModRequest(id, app);
            modreq.setStatus(status);
            RequestProcessingHistory proc = new RequestProcessingHistory(approver, status, new Date());
            RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
            reqDao.modifyRequest(modreq);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidRequestException(ex.getMessage());
        }
    }

    protected void changeRequestProcessingStatus(String id, String app, String status) throws InvalidRequestException, NamingException, ApprovalProcessException {
        try {
            ModRequest modreq = new ModRequest(id, app);
            if (status != null) {
                modreq.setProcessingStatus(status);
            } else {
                modreq.setDeleteProcessingStatus(true);
            }
            RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
            reqDao.modifyRequest(modreq);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidRequestException(ex.getMessage());
        }
    }

    protected void changeRequestStatuses(String id, String app, String status, String approver, String procstatus) throws InvalidRequestException, NamingException, ApprovalProcessException {
        try {
            ModRequest modreq = new ModRequest(id, app);
            modreq.setStatus(status);
            if (procstatus != null) {
                modreq.setProcessingStatus(procstatus);
            } else {
                modreq.setDeleteProcessingStatus(true);
            }
            RequestProcessingHistory proc = new RequestProcessingHistory(approver, status, new Date());
            RequestDAO reqDao = RequestDAOFactory.getDAO(this.m_dirctx, requestBase);
            reqDao.modifyRequest(modreq);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidRequestException(ex.getMessage());
        }
    }

    protected boolean isAdmin(String user) {
        boolean rtval = false;
        return rtval;
    }

    protected boolean isMatch(ApprovalPolicy pol, RequestOperationData opdata) throws NamingException {
        String filter;
        if (pol == null || opdata == null) {
            UtilDebug.log(127, "ApprovalStrategy:isMatch", "Invalid input, will not match policy to request.");
            return false;
        }
        List polOps = pol.getOperations();
        List polAttrs = pol.getOpAttrs();
        if (polOps != null && !polOps.contains(opdata.getOperation())) {
            return false;
        }
        if (polAttrs != null && polAttrs.size() > 0) {
            List reqattrs = opdata.getUniqueRequestAttrs();
            boolean match = false;
            if (reqattrs != null) {
                ListIterator itr = polAttrs.listIterator();
                while (itr.hasNext()) {
                    String attr = (String)itr.next();
                    if (!reqattrs.contains(attr)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                return false;
            }
        }
        if ((filter = pol.getObjectFilter()) != null) {
            String objdn = opdata.getObjectKey();
            if (objdn == null) {
                return false;
            }
            SearchControls ctl = new SearchControls();
            ctl.setSearchScope(0);
            NamingEnumeration<SearchResult> results = this.m_dirctx.search(objdn, filter, ctl);
            if (results == null) {
                return false;
            }
        }
        UtilDebug.log(127, "ApprovalStrategy:isMatch", "Policy matches request, policy: " + pol.getName());
        return true;
    }

    protected String resolveApproverRole(String name, String userKey, List userInfo) throws NamingException, ApprovalProcessException {
        if (name == null) {
            throw new ApprovalProcessException("Null role to ApprovalStrategy:resolveApproverRole.");
        }
        String rtval = null;
        if (userKey != null) {
            int mgrlevel = 0;
            try {
                mgrlevel = Approvers.getRoleLevel(name);
            }
            catch (NumberFormatException nex) {
                throw new ApprovalProcessException(nex.getMessage());
            }
            catch (IllegalArgumentException iex) {
                throw new ApprovalProcessException(iex.getMessage());
            }
            String mgr = null;
            String user = userKey;
            for (int i = 0; i < mgrlevel; ++i) {
                mgr = this.getManager(user);
                if (mgr == null) {
                    String msg = "Manager not found for user: " + userKey + " for level: " + (i + 1);
                    throw new ApprovalProcessException(msg);
                }
                user = mgr;
            }
            rtval = mgr;
        }
        return rtval;
    }

    protected List getAllActions(String user, Request req) throws NamingException, ApprovalProcessException {
        if (user == null) {
            String msg = "Invalid user toApprovalStrategy.getAllActions: user: " + user;
            UtilDebug.log(127, "ApprovalStrategy.getAllowedActions:", msg);
            throw new IllegalArgumentException(msg);
        }
        if (req == null) {
            String msg = "Null request.";
            UtilDebug.log(127, "ApprovalStrategy.getAllActions:", msg);
            throw new ApprovalProcessException(msg);
        }
        ArrayList<String> rtval = new ArrayList<String>();
        String status = req.getStatus();
        if (!status.equalsIgnoreCase(Request.REQUEST_PENDING_APPROVAL)) {
            return rtval;
        }
        if (this.isAdmin(user)) {
            rtval.add(USER_ACTION_APPROVE);
            rtval.add(USER_ACTION_REJECT);
            rtval.add(USER_ACTION_CANCEL);
        } else {
            String normcre;
            String normproc;
            String creator = req.getOriginator();
            if (creator != null && (normproc = Util.normalizeDN(user)).equalsIgnoreCase(normcre = Util.normalizeDN(creator))) {
                rtval.add(USER_ACTION_CANCEL);
            }
            if (this.isValidApprover(req, user)) {
                rtval.add(USER_ACTION_APPROVE);
                rtval.add(USER_ACTION_REJECT);
            }
        }
        return rtval;
    }

    private String getManager(String user) throws NamingException, ApprovalProcessException {
        Attribute attr;
        String[] mgrattrs;
        Attributes attrs;
        String rtval = null;
        if (user != null && (attrs = this.m_dirctx.getAttributes(user, mgrattrs = new String[]{this.MANAGER_ATTR})) != null && (attr = attrs.get(this.MANAGER_ATTR)) != null) {
            if (attr.size() > 1) {
                String msg = "Multiple managers detected for user: " + user + ". Don't know how to proceed.";
                throw new ApprovalProcessException(msg);
            }
            rtval = (String)attr.get(0);
        }
        return rtval;
    }
}

