/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.idm.policy.IPolicy;
import oracle.idm.policy.IPolicyTrusteeCollection;
import oracle.idm.policy.PolicyException;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.ApprovalPolicyDAO;
import oracle.idm.provisioning.approval.ApprovalPolicyDAOFactory;
import oracle.idm.provisioning.approval.Approvers;
import oracle.idm.provisioning.approval.ApproversDAO;
import oracle.idm.provisioning.approval.ApproversDAOFactory;
import oracle.ldap.util.UtilDebug;

public class ApprovalPolicyManager {
    private static String policyBase = "cn=applications, cn=provisioning, cn=directory integration platform, cn=products, cn=oraclecontext";
    private DirContext m_dirctx = null;

    public void setDirContext(DirContext ctx) {
        if (ctx != null) {
            this.m_dirctx = ctx;
        }
    }

    public List getApprovalPolicies(String app) throws NamingException, PolicyException {
        ApprovalPolicyDAO acDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
        List rtval = null;
        try {
            rtval = acDao.getApprovalPolicies(app, null);
            if (rtval != null) {
                ListIterator iter = rtval.listIterator();
                while (iter.hasNext()) {
                    ApprovalPolicy ap = (ApprovalPolicy)iter.next();
                    List approvers = this.getApprovers(ap.getKey());
                    if (approvers == null) continue;
                    ap.setApprovers(approvers);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:getApprovalPolicies:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        return rtval;
    }

    public ApprovalPolicy getApprovalPolicy(String id) throws NamingException, PolicyException {
        ApprovalPolicyDAO acDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
        ApprovalPolicy rtval = null;
        try {
            List approvers;
            rtval = acDao.getApprovalPolicy(id);
            if (rtval != null && (approvers = this.getApprovers(rtval.getKey())) != null) {
                rtval.setApprovers(approvers);
            }
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:getApprovalPolicy:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        return rtval;
    }

    public List getApprovers(String policyid) throws NamingException, PolicyException {
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        List rtval = null;
        try {
            rtval = aDao.getApprovers(policyid);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:getApprovers:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        return rtval;
    }

    public List getApproversByProperty(String policyid, String propname, String val) throws NamingException, PolicyException {
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        ArrayList<Approvers> rtval = null;
        int level = 0;
        if (propname != null && propname.equalsIgnoreCase("approval_level")) {
            try {
                level = Integer.parseInt(val);
            }
            catch (NumberFormatException nex) {
                String msg = "Invalid value for approval level: " + val + ", expected an integer.";
                UtilDebug.log(127, "ApprovalPolicyManager:getTrusteeCollectionByProperty:", msg);
                throw new PolicyException(msg);
            }
        } else {
            String msg = "Invalid property " + propname + ".";
            UtilDebug.log(127, "ApprovalPolicyManager:getTrusteeCollectionByProperty:", msg);
            throw new PolicyException(msg);
        }
        try {
            Approvers pt = aDao.getApproversForLevel(policyid, level);
            rtval = new ArrayList<Approvers>();
            rtval.add(pt);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:getTrusteeCollectionByProperty:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        return rtval;
    }

    public void modifyTrustees(String policyid, IPolicyTrusteeCollection trustees, boolean addIfNew) throws NamingException, PolicyException {
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        Approvers approvers = new Approvers();
        List moditems = null;
        try {
            approvers.copyTrusteeCollection(trustees);
            moditems = aDao.modifyApprovers(policyid, approvers, addIfNew);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:modifyApprovers:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        if (moditems == null || moditems.size() > 0) {
            // empty if block
        }
    }

    public void addTrustees(String policyid, IPolicyTrusteeCollection trustees) throws NamingException, PolicyException {
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        Approvers approvers = new Approvers();
        try {
            approvers.copyTrusteeCollection(trustees);
            aDao.addApprovers(policyid, approvers);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:addApprovers:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
    }

    public void deleteTrustees(String policyid, IPolicyTrusteeCollection trustees) throws NamingException, PolicyException {
        String level = trustees.getProperty("approval_level");
        int ilevel = 0;
        try {
            ilevel = Integer.parseInt(level);
        }
        catch (NumberFormatException next) {
            String msg = "Invalid level " + level;
            NamingException ex = new NamingException(msg);
            UtilDebug.log(127, "ApprovalPolicyManager.deleteTrustees:", ex);
            throw ex;
        }
        String name = trustees.getName();
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        try {
            aDao.deleteApprovers(policyid, name, ilevel);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:deleteApprovers:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
    }

    public void modifyApprovalPolicy(IPolicy policy) throws PolicyException, NamingException {
        int numtrustees;
        if (policy == null) {
            String msg = "Null policy while modifying approval policy.";
            UtilDebug.log(127, "ApprovalPolicyManager:modifyApprovalPolicy:", msg);
            throw new PolicyException(msg);
        }
        ApprovalPolicy pol = new ApprovalPolicy();
        pol.copyPolicy(policy);
        List trustees = policy.getAllTrustees();
        int levels = pol.getApprovalLevels();
        if (levels <= 0) {
            String msg = "Invalid number of apporval levels: " + levels;
            UtilDebug.log(127, "ApprovalPolicyManager:modifyApprovalPolicy:", msg);
            throw new PolicyException(msg);
        }
        int n = numtrustees = trustees == null ? 0 : trustees.size();
        if (numtrustees != levels) {
            String msg = "Number of trustees does not match approval levels levels: " + levels + ", number of trustees: " + numtrustees;
            UtilDebug.log(127, "ApprovalPolicyManager:modifyApprovalPolicy:", msg);
            throw new PolicyException(msg);
        }
        ApprovalPolicyDAO apDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
        ApprovalPolicy oldpol = null;
        try {
            oldpol = apDao.modifyPolicy(pol);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:modifyApprovalPolicy:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        int newlevel = pol.getApprovalLevels();
        int oldlevel = oldpol == null ? newlevel : oldpol.getApprovalLevels();
        String poluid = pol.getKey();
        if (oldlevel > newlevel) {
            ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
            for (int i = newlevel + 1; i <= oldlevel; ++i) {
                aDao.deleteApprovers(poluid, null, i);
            }
        }
        if (trustees != null) {
            ListIterator iter = trustees.listIterator();
            while (iter.hasNext()) {
                IPolicyTrusteeCollection trustee = (IPolicyTrusteeCollection)iter.next();
                this.modifyTrustees(poluid, trustee, true);
            }
        }
        if (oldlevel != newlevel) {
            // empty if block
        }
        if (oldlevel > newlevel) {
            // empty if block
        }
    }

    public void deleteApprovalPolicy(String policyid) throws NamingException, PolicyException {
        if (policyid != null) {
            ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
            List al = aDao.getApproversUids(policyid);
            ListIterator iter = al.listIterator();
            while (iter.hasNext()) {
                String ap = (String)iter.next();
                aDao.deleteApprovers(ap);
            }
            ApprovalPolicyDAO apDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
            apDao.deletePolicy(policyid);
        } else {
            UtilDebug.log(127, "ApprovalPolicyManager:deleteApprovalPolicy:", "Null policyuid, nothing to be done.");
        }
    }

    public String createApprovalPolicy(String app, IPolicy policy, List trustees) throws NamingException, PolicyException {
        if (policy == null || trustees == null) {
            String msg = "Null policy or trustees while creating approval policy.";
            UtilDebug.log(127, "ApprovalPolicyManager:createApprovalPolicy:", msg);
            throw new PolicyException(msg);
        }
        ApprovalPolicy pol = new ApprovalPolicy();
        pol.copyPolicy(policy);
        if (pol.getApprovalLevels() != trustees.size()) {
            String msg = "Number of trustees " + trustees.size() + " does not match approval levels specified in policy: " + pol.getApprovalLevels();
            UtilDebug.log(127, "ApprovalPolicyManager:createApprovalPolicy:", msg);
            throw new PolicyException(msg);
        }
        ApprovalPolicyDAO apDao = ApprovalPolicyDAOFactory.getDAO(this.m_dirctx, policyBase);
        String policyuid = null;
        try {
            policyuid = apDao.createPolicy(app, pol);
        }
        catch (IllegalArgumentException ex) {
            UtilDebug.log(127, "ApprovalPolicyManager:createApprovalPolicy:", ex.getMessage());
            throw new PolicyException(ex.getMessage());
        }
        ApproversDAO aDao = ApproversDAOFactory.getDAO(this.m_dirctx);
        ListIterator iter = trustees.listIterator();
        while (iter.hasNext()) {
            IPolicyTrusteeCollection ap = (IPolicyTrusteeCollection)iter.next();
            Approvers approvers = new Approvers();
            try {
                approvers.copyTrusteeCollection(ap);
                aDao.addApprovers(policyuid, approvers);
            }
            catch (IllegalArgumentException ex) {
                UtilDebug.log(127, "ApprovalPolicyManager:createApprovalPolicy:", ex.getMessage());
                throw new PolicyException(ex.getMessage());
            }
        }
        return policyuid;
    }

    public void validatePolicy(IPolicy policy) throws PolicyException {
        int opnums;
        if (policy == null) {
            String msg = "Null policy.";
            UtilDebug.log(127, "ApprovalPolicyManager:validatePolicy:", msg);
            throw new PolicyException(msg);
        }
        ApprovalPolicy pol = new ApprovalPolicy();
        pol.copyPolicy(policy);
        if (pol.getName() == null) {
            String msg = "Policy name is null.";
            UtilDebug.log(127, "ApprovalPolicyManager:validatePolicy:", msg);
            throw new PolicyException(msg);
        }
        String filter = pol.getObjectFilter();
        List attrs = pol.getOpAttrs();
        int attrnums = attrs == null ? 0 : attrs.size();
        List ops = pol.getOperations();
        int n = opnums = ops == null ? 0 : ops.size();
        if (filter == null && attrnums == 0 && opnums == 0) {
            String msg = "No criteria (object filter, list operations or attributes) for policy";
            UtilDebug.log(127, "ApprovalPolicyManager:validatePolicy:", msg);
            throw new PolicyException(msg);
        }
    }

    public void validateTrusteeCollection(List trustees) throws PolicyException {
        if (trustees == null || trustees.size() <= 0) {
            String msg = "Null or empty trustee list.";
            UtilDebug.log(127, "ApprovalPolicyManager:validateTrusteeCollection:", msg);
            throw new PolicyException(msg);
        }
        ListIterator iter = trustees.listIterator();
        while (iter.hasNext()) {
            IPolicyTrusteeCollection ap = (IPolicyTrusteeCollection)iter.next();
            Approvers approvers = new Approvers();
            try {
                int rolesize;
                approvers.copyTrusteeCollection(ap);
                List users = approvers.getApproverUsers();
                List grps = approvers.getApproverGroups();
                List roles = approvers.getApproverRoleNames();
                int usersize = users == null ? 0 : users.size();
                int grpsize = grps == null ? 0 : grps.size();
                int n = rolesize = roles == null ? 0 : roles.size();
                if (usersize != 0 || grpsize != 0 || rolesize != 0) continue;
                String msg = "Approver list must contain at least one trustee";
                UtilDebug.log(127, "ApprovalPolicyManager:validateTrusteeCollection:", msg);
                throw new PolicyException(msg);
            }
            catch (IllegalArgumentException ex) {
                UtilDebug.log(127, "ApprovalPolicyManager:validateTrusteeCollection:", ex.getMessage());
                throw new PolicyException(ex.getMessage());
            }
        }
    }
}

