/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oracle.idm.policy.IPolicy;
import oracle.idm.policy.IPolicyTrusteeCollection;
import oracle.idm.provisioning.approval.Approvers;
import oracle.ldap.util.UtilDebug;

public class ApprovalPolicy
implements IPolicy {
    public static final String ALL_OPERATIONS = "all";
    public static final String DEFAULT_APPROVAL_PROCESS = "OIMApprovalProcess";
    private String m_name = null;
    private String m_key = null;
    private ArrayList m_operations = new ArrayList();
    private ArrayList m_opAttrs = new ArrayList();
    private String m_objectFilter = null;
    private String m_description = null;
    private int m_approvalLevels = 1;
    private String m_approvalProcess;
    private ArrayList m_approvers = null;

    public void copyPolicy(IPolicy pol) throws IllegalArgumentException {
        List lproc;
        List lfil;
        List lattrs;
        if (pol == null) {
            String msg = "Null policy.";
            UtilDebug.log(127, "ApprovalPolicy:copyPolicy:", msg);
            throw new IllegalArgumentException(msg);
        }
        this.m_name = pol.getName();
        this.m_key = pol.getKey();
        List ll = pol.getPropertyCollection("approval_levels");
        int level = 1;
        if (ll != null) {
            try {
                level = Integer.parseInt((String)ll.get(0));
            }
            catch (NumberFormatException ex) {
                String msg = "Invalid value for POLICY_PROPERTY_APPROVAL_LEVELS" + (String)ll.get(0) + ", can not proceed further. Exception: " + ex.getMessage();
                UtilDebug.log(127, "ApprovalPolicy:copyPolicy:", msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.setApprovalLevels(level);
        List lops = pol.getPropertyCollection("approval_operations");
        if (lops != null) {
            ListIterator iter = lops.listIterator();
            while (iter.hasNext()) {
                String op = (String)iter.next();
                this.addOperation(op);
            }
        }
        if ((lattrs = pol.getPropertyCollection("approval_attributes")) != null) {
            ListIterator iter = lattrs.listIterator();
            while (iter.hasNext()) {
                String attr = (String)iter.next();
                this.addOpAttr(attr);
            }
        }
        if ((lfil = pol.getPropertyCollection("approval_filter")) != null) {
            this.setObjectFilter((String)lfil.get(0));
        }
        if ((lproc = pol.getPropertyCollection("approval_process")) != null) {
            this.setApprovalProcess((String)lproc.get(0));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getKey() {
        return this.m_key;
    }

    public List getOperations() {
        return this.m_operations;
    }

    public List getOpAttrs() {
        return this.m_opAttrs;
    }

    public String getObjectFilter() {
        return this.m_objectFilter;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getApprovalProcess() {
        return this.m_approvalProcess;
    }

    public int getApprovalLevels() {
        return this.m_approvalLevels;
    }

    public List getPropertyCollection(String prop) {
        ArrayList<String> ret = null;
        if (prop != null) {
            if (prop.equalsIgnoreCase("approval_operations")) {
                ret = this.m_operations;
            } else if (prop.equalsIgnoreCase("approval_attributes")) {
                ret = this.m_opAttrs;
            } else if (prop.equalsIgnoreCase("approval_filter")) {
                ret = new ArrayList<String>();
                ret.add(this.m_objectFilter);
            } else if (prop.equalsIgnoreCase("approval_process")) {
                ret = new ArrayList();
                ret.add(this.m_approvalProcess);
            } else if (prop.equalsIgnoreCase("approval_levels")) {
                ret = new ArrayList();
                StringBuffer buf = new StringBuffer();
                buf.append(this.m_approvalLevels);
                ret.add(buf.toString());
            }
        }
        return ret;
    }

    public List getAllTrustees() {
        return this.m_approvers;
    }

    public IPolicyTrusteeCollection getTrusteesByProperty(String prop, String val) {
        Approvers rtval = null;
        if (prop != null && val != null && prop.equalsIgnoreCase("approval_level")) {
            int vallevel = 0;
            try {
                vallevel = Integer.parseInt(val);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (vallevel > 0 && this.m_approvers != null) {
                ListIterator iter = this.m_approvers.listIterator();
                while (iter.hasNext()) {
                    Approvers ap = (Approvers)iter.next();
                    if (ap.getLevel() != vallevel) continue;
                    rtval = ap;
                    break;
                }
            }
        }
        return rtval;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setApprovers(List approvers) {
        if (this.m_approvers != null) {
            this.m_approvers.clear();
        } else {
            this.m_approvers = new ArrayList();
        }
        if (approvers != null) {
            this.m_approvers.addAll(approvers);
        }
    }

    public void setOpAttrs(List attrs) {
        if (this.m_opAttrs != null) {
            this.m_opAttrs.clear();
        } else {
            this.m_opAttrs = new ArrayList();
        }
        if (attrs != null) {
            this.m_opAttrs.addAll(attrs);
        }
    }

    public void setOperations(List ops) {
        if (this.m_operations != null) {
            this.m_operations.clear();
        } else {
            this.m_operations = new ArrayList();
        }
        if (ops != null) {
            this.m_operations.addAll(ops);
        }
    }

    public void addOperation(String op) {
        if (op != null) {
            this.m_operations.add(op);
        }
    }

    public void addOpAttr(String attr) {
        if (attr != null) {
            this.m_opAttrs.add(attr);
        }
    }

    public void setObjectFilter(String filter) {
        this.m_objectFilter = filter;
    }

    public void setDescription(String descr) {
        this.m_description = descr;
    }

    public void setApprovalProcess(String proc) {
        this.m_approvalProcess = proc;
    }

    public void setApprovalLevels(int levels) throws IllegalArgumentException {
        if (levels <= 0) {
            String msg = "ApprovalPolicy.setApprovalLevels: Approval levels must be > 0.";
            throw new IllegalArgumentException(msg);
        }
        this.m_approvalLevels = levels;
    }

    public void addProperty(String name, String val) {
        if (name != null) {
            if (name.equalsIgnoreCase("approval_operations")) {
                this.addOperation(val);
            } else if (name.equalsIgnoreCase("approval_attributes")) {
                this.addOpAttr(val);
            } else if (name.equalsIgnoreCase("approval_filter")) {
                this.setObjectFilter(val);
            } else if (name.equalsIgnoreCase("approval_process")) {
                this.setApprovalProcess(val);
            } else if (name.equalsIgnoreCase("approval_levels")) {
                int levels = 0;
                try {
                    levels = Integer.parseInt(val);
                    this.setApprovalLevels(levels);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
    }

    public List getPropertyNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("approval_operations");
        ret.add("approval_attributes");
        ret.add("approval_filter");
        ret.add("approval_process");
        ret.add("approval_levels");
        return ret;
    }
}

