/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLConnection;
import oracle.xml.xsql.XSQLConnectionManager;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLConnectionManagerStatus;
import oracle.xml.xsql.XSQLDocHandler;
import oracle.xml.xsql.XSQLDocumentSerializer;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLLogger;
import oracle.xml.xsql.XSQLLoggerFactory;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLStylesheetPI;
import oracle.xml.xsql.XSQLStylesheetProcessor;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLPageProcessor {
    public static final String XSLMIME = "text/xsl";
    public static final String JAVAMIME = "application/java";
    XSQLPage requestedPage = null;
    XSQLPageRequest env = null;
    XSQLConnection conn = null;
    XSQLConnectionManager mgr = null;
    Document XMLDoc = null;
    String connectionName = null;
    XSQLLoggerFactory loggerFactory = null;
    XSQLLogger logger = null;
    boolean isLogging = false;

    public XSQLPageProcessor(XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
    }

    public static String getVersion() {
        return XMLParser.getReleaseVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() throws SAXParseException, FileNotFoundException {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        XSQLPage xSQLPage = null;
        try {
            XSQLConfigManager.insureConfigurationIsLoaded(this.env);
            if (!this.env.isIncludedRequest()) {
                object3 = XSQLConfigManager.getManager();
                this.isLogging = ((XSQLConfigManager)object3).isCustomLoggerFactoryProvided();
                if (this.isLogging) {
                    this.loggerFactory = ((XSQLConfigManager)object3).getLoggerFactory();
                }
            }
            this.fireStartLogEvent();
            xSQLPage = this.env.getXSQLPage();
        }
        catch (SAXParseException sAXParseException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            throw sAXParseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            throw fileNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            throw runtimeException;
        }
        object3 = null;
        String string3 = this.env.getUserAgent();
        String string4 = this.env.getParameter("dumppool");
        String string5 = this.env.getParameter("xml-stylesheet");
        String string6 = this.env.getParameter("transform");
        boolean bl = false;
        if (string4 != null && string4.equalsIgnoreCase("y")) {
            XSQLConnectionManagerFactory xSQLConnectionManagerFactory = this.env.getConnectionManagerFactory();
            XSQLConnectionManager xSQLConnectionManager = xSQLConnectionManagerFactory.create();
            if (xSQLConnectionManager instanceof XSQLConnectionManagerStatus) {
                ((XSQLConnectionManagerStatus)((Object)xSQLConnectionManager)).showStatus(this.env);
            }
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        if (string5 != null && string5.equalsIgnoreCase("none")) {
            bl = true;
            string5 = "";
            string6 = "";
        }
        try {
            object3 = new XSQLDocHandler(this.env, xSQLPage, string5, string6);
        }
        catch (SAXParseException sAXParseException) {
            this.env.signalError(25005, null, new Object[]{sAXParseException});
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        catch (SAXException sAXException) {
            this.env.signalError(25005, null, null);
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        catch (RuntimeException runtimeException) {
            this.env.signalError(25017, null, new Object[]{runtimeException});
            throw runtimeException;
        }
        try {
            this.env.setErrorHandlerClass(((XSQLDocHandler)object3).getErrorHandlerClass());
            this.env.setConnectionName(((XSQLDocHandler)object3).getConnectionName());
            this.XMLDoc = ((XSQLDocHandler)object3).getDocument();
        }
        catch (SQLException sQLException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        catch (DOMException dOMException) {
            this.env.signalError(25014, null, null);
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            throw xSQLInitializationException;
        }
        catch (Throwable throwable) {
            this.env.signalError(25017, null, new Object[]{throwable});
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return;
        }
        Object object4 = null;
        Enumeration enumeration = ((XSQLDocHandler)object3).getDocumentPIs().elements();
        boolean bl2 = ((XSQLDocHandler)object3).getAllowClientStyle();
        if (!bl || !bl2) {
            while (enumeration.hasMoreElements()) {
                object2 = (XSQLStylesheetPI)enumeration.nextElement();
                object = ((XSQLStylesheetPI)object2).getType();
                string2 = ((XSQLStylesheetPI)object2).getSerializer(this.env);
                if ((object != null || string2 == null) && (object == null || !((String)object).equals(XSLMIME))) continue;
                string = ((XSQLStylesheetPI)object2).getMedia();
                if (string != null && !string.equals("")) {
                    if (string3.toUpperCase().indexOf(string.toUpperCase()) < 0) continue;
                    object4 = object2;
                    break;
                }
                object4 = object2;
                break;
            }
        }
        object2 = ((XMLDocument)this.XMLDoc).getEncoding();
        if (object4 != null) {
            object = ((XSQLStylesheetPI)object4).getHref(this.env);
            string2 = ((XSQLStylesheetPI)object4).getSerializer(this.env);
            string = ((XSQLStylesheetPI)object4).getType();
            if (object != null && !((String)object).equals("") || string == null && string2 != null) {
                boolean bl3;
                boolean bl4 = ((XSQLStylesheetPI)object4).isClient();
                boolean bl5 = bl3 = string != null && string.equals(XSLMIME) && bl4 && string2 == null;
                if (bl3) {
                    this.XMLDoc = ((XSQLStylesheetPI)object4).addToProlog(this.XMLDoc, this.env);
                    this.env.setContentType("text/xml; charset=" + (String)object2);
                } else {
                    try {
                        if (string != null && string.equals(XSLMIME)) {
                            if (XSQLUtil.untrustedAbsoluteStylesheetURL((String)object)) {
                                this.env.signalError(25026, null, null);
                                this.env.requestProcessed();
                                this.fireEndLogEvent();
                                return;
                            }
                            String string7 = this.env.translateURL((String)object);
                            if (string7 == null) {
                                this.env.signalError(25028, new String[]{object}, null);
                                this.env.requestProcessed();
                                this.fireEndLogEvent();
                                return;
                            }
                            this.env.setStylesheetURI((String)object);
                            if (string2 == null) {
                                XSQLStylesheetProcessor.processToWriter(this.XMLDoc, string7, this.env);
                            }
                            Document document = XSQLStylesheetProcessor.processToDocument(this.XMLDoc, string7, this.env);
                            XSQLDocumentSerializer xSQLDocumentSerializer = XSQLUtil.createSerializer(string2, this.env);
                            if (xSQLDocumentSerializer == null) {
                                this.env.requestProcessed();
                                this.fireEndLogEvent();
                                return;
                            }
                            try {
                                xSQLDocumentSerializer.serialize(document, this.env);
                            }
                            catch (Throwable throwable) {
                                this.env.signalError(25017, null, new Object[]{throwable});
                                this.env.requestProcessed();
                                this.fireEndLogEvent();
                                return;
                            }
                        }
                        XSQLDocumentSerializer xSQLDocumentSerializer = XSQLUtil.createSerializer(string2, this.env);
                        if (xSQLDocumentSerializer != null) {
                            try {
                                xSQLDocumentSerializer.serialize(this.XMLDoc, this.env);
                            }
                            catch (Throwable throwable) {
                                this.env.signalError(25017, null, new Object[]{throwable});
                                this.env.requestProcessed();
                                this.fireEndLogEvent();
                                return;
                            }
                        }
                        this.env.requestProcessed();
                        this.fireEndLogEvent();
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    catch (SAXParseException sAXParseException) {}
                    catch (XSLException xSLException) {}
                    finally {
                        this.env.requestProcessed();
                        this.fireEndLogEvent();
                        return;
                    }
                }
            }
        } else {
            this.env.setContentType("text/xml; charset=" + (String)object2);
        }
        if (this.env.isUseOutputStream()) {
            object = this.env.getOutputStream();
            XSQLParserHelper.print(this.XMLDoc, (OutputStream)object);
        } else {
            object = this.env.getWriter();
            XSQLParserHelper.print(this.XMLDoc, (PrintWriter)object);
        }
        this.env.requestProcessed();
        this.fireEndLogEvent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document processToXML() throws SAXParseException, FileNotFoundException {
        String string;
        Object object;
        Object object2;
        Document document = null;
        XSQLPage xSQLPage = null;
        try {
            if (!this.env.isIncludedRequest()) {
                XSQLConfigManager.insureConfigurationIsLoaded(this.env);
                object2 = XSQLConfigManager.getManager();
                this.isLogging = ((XSQLConfigManager)object2).isCustomLoggerFactoryProvided();
                if (this.isLogging) {
                    this.loggerFactory = ((XSQLConfigManager)object2).getLoggerFactory();
                }
            }
            this.fireStartLogEvent();
            xSQLPage = this.env.getXSQLPage();
        }
        catch (Exception exception) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        object2 = null;
        String string2 = this.env.getUserAgent();
        String string3 = this.env.getParameter("xml-stylesheet");
        String string4 = this.env.getParameter("transform");
        boolean bl = false;
        if (string3 != null && string3.equalsIgnoreCase("none")) {
            bl = true;
            string3 = "";
            string4 = "";
        }
        try {
            object2 = new XSQLDocHandler(this.env, xSQLPage, string3, string4);
        }
        catch (SAXParseException sAXParseException) {
            this.env.signalError(25005, null, new Object[]{sAXParseException});
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        catch (SAXException sAXException) {
            this.env.signalError(25005, null, null);
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        try {
            this.env.setErrorHandlerClass(((XSQLDocHandler)object2).getErrorHandlerClass());
            this.env.setConnectionName(((XSQLDocHandler)object2).getConnectionName());
            this.XMLDoc = ((XSQLDocHandler)object2).getDocument();
        }
        catch (SQLException sQLException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        catch (DOMException dOMException) {
            this.env.signalError(25014, null, null);
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        catch (XSQLInitializationException xSQLInitializationException) {
            this.env.requestProcessed();
            this.fireEndLogEvent();
            throw xSQLInitializationException;
        }
        catch (RuntimeException runtimeException) {
            this.env.signalError(25017, null, new Object[]{runtimeException});
            this.env.requestProcessed();
            this.fireEndLogEvent();
            return null;
        }
        Object object3 = null;
        Enumeration enumeration = ((XSQLDocHandler)object2).getDocumentPIs().elements();
        boolean bl2 = ((XSQLDocHandler)object2).getAllowClientStyle();
        if (!bl || !bl2) {
            while (enumeration.hasMoreElements()) {
                object = (XSQLStylesheetPI)enumeration.nextElement();
                string = ((XSQLStylesheetPI)object).getType();
                if (string == null || !string.equals(XSLMIME) && !string.equals(JAVAMIME)) continue;
                String string5 = ((XSQLStylesheetPI)object).getMedia();
                if (string5 != null && !string5.equals("")) {
                    if (string2.toUpperCase().indexOf(string5.toUpperCase()) < 0) continue;
                    object3 = object;
                    break;
                }
                object3 = object;
                break;
            }
        }
        if (object3 != null && (object = ((XSQLStylesheetPI)object3).getHref(this.env)) != null && !((String)object).equals("")) {
            boolean bl3;
            string = ((XSQLStylesheetPI)object3).getType();
            boolean bl4 = bl3 = string.equals(XSLMIME) && ((XSQLStylesheetPI)object3).isClient();
            if (bl3) {
                this.XMLDoc = ((XSQLStylesheetPI)object3).addToProlog(this.XMLDoc, this.env);
            } else {
                try {
                    if (string.equals(XSLMIME)) {
                        if (XSQLUtil.untrustedAbsoluteStylesheetURL((String)object)) {
                            this.env.signalError(25026, null, null);
                            this.env.requestProcessed();
                            this.fireEndLogEvent();
                            return null;
                        }
                        String string6 = this.env.translateURL((String)object);
                        if (string6 == null) {
                            this.env.signalError(25028, new String[]{object}, null);
                            this.env.requestProcessed();
                            this.fireEndLogEvent();
                            return null;
                        }
                        this.env.setStylesheetURI((String)object);
                        document = XSQLStylesheetProcessor.processToDocument(this.XMLDoc, string6, this.env);
                    } else if (!string.equals(JAVAMIME)) {
                        // empty if block
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.env.requestProcessed();
                    this.fireEndLogEvent();
                    return null;
                }
                catch (SAXParseException sAXParseException) {
                    this.env.requestProcessed();
                    this.fireEndLogEvent();
                    return null;
                }
                catch (XSLException xSLException) {
                    this.env.requestProcessed();
                    this.fireEndLogEvent();
                    return null;
                }
                catch (Exception exception) {
                    this.env.requestProcessed();
                    this.fireEndLogEvent();
                    return null;
                }
                this.env.requestProcessed();
                this.fireEndLogEvent();
                return document;
            }
        }
        document = this.XMLDoc;
        this.env.requestProcessed();
        this.fireEndLogEvent();
        return document;
    }

    void fireStartLogEvent() {
        if (this.isLogging && !this.env.isIncludedRequest()) {
            try {
                this.logger = this.loggerFactory.create(this.env);
                this.logger.logRequestStart(this.env);
            }
            catch (Exception exception) {
                System.err.println("Custom logger threw exception in fireStartLogEvent!");
                exception.printStackTrace(System.err);
            }
        }
    }

    void fireEndLogEvent() {
        if (this.isLogging && !this.env.isIncludedRequest()) {
            try {
                this.logger.logRequestEnd(this.env);
            }
            catch (Exception exception) {
                System.err.println("Custom logger threw exception in fireEndLogEvent!");
                exception.printStackTrace(System.err);
            }
        }
    }
}

