/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedDirectory;
import oracle.ide.boot.JarDirs;

final class SharedDirectoryByPackage
extends SharedDirectory {
    private int[] _hashes;

    SharedDirectoryByPackage(File existingCanonicalFile, URL location) {
        super(existingCanonicalFile, location);
        this.readPackageList(existingCanonicalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readPackageList(File classesDir) {
        block23: {
            BufferedReader br = null;
            ArrayList<String> packages = new ArrayList<String>();
            File packagesTxt = new File(classesDir, "packages.txt");
            FileInputStream fis = new FileInputStream(packagesTxt);
            InputStreamReader isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            while (br.ready()) {
                String line = br.readLine();
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                packages.add(line);
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (packages.isEmpty()) {
                this._hashes = null;
            } else {
                int[] dirHashes = new int[packages.size()];
                int numHashes = 0;
                for (String p : packages) {
                    dirHashes[numHashes++] = p.hashCode();
                }
                this._hashes = JarDirs.sortAndTrim(numHashes, dirHashes);
            }
            break block23;
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                if (packages.isEmpty()) {
                    this._hashes = null;
                } else {
                    int[] dirHashes = new int[packages.size()];
                    int numHashes = 0;
                    for (String p : packages) {
                        dirHashes[numHashes++] = p.hashCode();
                    }
                    this._hashes = JarDirs.sortAndTrim(numHashes, dirHashes);
                }
                catch (Throwable throwable) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    if (packages.isEmpty()) {
                        this._hashes = null;
                    } else {
                        int[] dirHashes2 = new int[packages.size()];
                        int numHashes2 = 0;
                        for (String p : packages) {
                            dirHashes2[numHashes2++] = p.hashCode();
                        }
                        this._hashes = JarDirs.sortAndTrim(numHashes2, dirHashes2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean isSelectedByPackagesTxt(String relPath) {
        return this.isPotentiallySelected(relPath);
    }

    private boolean isPotentiallySelected(String relPath) {
        if (this._hashes != null && relPath != null) {
            int lastSlash = relPath.lastIndexOf(47);
            int hash = lastSlash > 0 ? relPath.substring(0, lastSlash).hashCode() : 0;
            return Arrays.binarySearch(this._hashes, hash) >= 0;
        }
        return true;
    }

    @Override
    protected boolean doContainsResource(String relPath) {
        if (this.isSelectedByPackagesTxt(relPath)) {
            return super.doContainsResource(relPath);
        }
        return false;
    }

    @Override
    protected File doGetFile(String relPath) {
        if (this.isSelectedByPackagesTxt(relPath)) {
            return super.doGetFile(relPath);
        }
        return null;
    }

    @Override
    protected URL doGetResource(String relPath) throws IOException {
        if (this.isSelectedByPackagesTxt(relPath)) {
            return super.doGetResource(relPath);
        }
        return null;
    }

    @Override
    protected RecoverableByteBuffer doGetResourceBytes(int currentMaintenanceTick, String relPath, RecoverableByteBuffer buffer) throws IOException {
        if (this.isSelectedByPackagesTxt(relPath)) {
            return super.doGetResourceBytes(currentMaintenanceTick, relPath, buffer);
        }
        return null;
    }

    @Override
    protected InputStream doGetStream(String relPath) throws IOException {
        if (this.isSelectedByPackagesTxt(relPath)) {
            return super.doGetStream(relPath);
        }
        throw new FileNotFoundException(relPath);
    }
}

