/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SearchPolicy;
import oracle.classloader.SearchSequence;
import oracle.classloader.util.ClassloadingUtilities;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.VersionNumber;
import oracle.ide.boot.IdeConfigurationPolicies;
import oracle.ide.boot.IdeConfigurationTypes;
import oracle.ide.boot.InterceptingBeforeDelegatingSearchPolicy;
import oracle.ide.boot.IsolatedExtensionsModuleOutputProcessor;

final class PCLMain {
    private static final String INSTRUMENTED_CLASSPATH_PROPERTY_NAME = "ide.extension.extra.classpath";
    private static final File ORACLE_HOME = new File(System.getProperty("oracle.home"));
    private static final String DEFERRED_UPDATE_MAIN_CLASS = "oracle.ideimpl.webupdate.DeferredUpdater";

    PCLMain() {
    }

    public static void main(String[] args) throws Exception {
        ClassLoader pcl = PCLMain.createExtensionManagerLoader();
        PCLMain.callMain(pcl, args);
    }

    private static void callMain(ClassLoader pcl, String[] args) throws Exception {
        Class<?> mainClass = Class.forName("oracle.ideimpl.Main", false, pcl);
        Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
        Thread.currentThread().setContextClassLoader(pcl);
        mainMethod.invoke(null, new Object[]{args});
    }

    private static void truncateAppClassLoaderDelegate(PolicyClassLoader pcl) {
        InterceptingBeforeDelegatingSearchPolicy interceptor = new InterceptingBeforeDelegatingSearchPolicy("interceptBootClasses", PolicyClassLoader.class.getClassLoader());
        SearchSequence sp = new SearchSequence("filteringToApp", new SearchPolicy[]{SearchPolicy.FIND_LOADED_CLASS, SearchPolicy.ASK_PARENT, SearchPolicy.CHECK_SHARED_LIBRARIES, interceptor, SearchPolicy.FIND_LOCAL});
        interceptor.addPackagesToDelegate(Arrays.asList("oracle.ide.boot", "oracle.classloader"));
        String earlyCLPackages = System.getProperty("oracle.ide.early.classload.packages", null);
        if (earlyCLPackages != null) {
            interceptor.addPackagesToDelegate(Arrays.asList(earlyCLPackages.split(",")));
        }
        try {
            Field f = PolicyClassLoader.class.getDeclaredField("searchPolicy");
            f.setAccessible(true);
            f.set(pcl, sp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ClassLoader createExtensionManagerLoader() throws IOException {
        File macroDirectory = new File(ORACLE_HOME, "ide/macros");
        File macroFile = new File(macroDirectory, "ide-boot.properties");
        Properties properties = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(macroFile);
            properties.load(reader);
        }
        catch (IOException e) {
            throw new IOException("exception loading " + macroFile, e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
        PolicyClassLoader mainLoader = ClassLoaderQuery.findLoader("main");
        PolicyClassLoader extensionLoader = new PolicyClassLoader("ide-global", new VersionNumber("11.1.1.0.0"), mainLoader, new ConfigurationOrigin(IdeConfigurationTypes.IDE_GLOBAL_LOADER, ""), IdeConfigurationPolicies.EXTENSION_LOADER_POLICY);
        PCLMain.checkForDeferredUpdates(extensionLoader, macroDirectory, properties.getProperty("ide.cfu.class.path"));
        PCLMain.addIdeLibs(extensionLoader, macroDirectory, properties.getProperty("ide.boot.class.path"));
        PCLMain.addJdkLibs(extensionLoader);
        PCLMain.addIdeNativeLibs(extensionLoader);
        ClassloadingUtilities.setSystemClassLoader("ide-global");
        if (System.getProperty("oracle.ide.prune.appclasspath") != null && Boolean.TRUE.toString().equals(System.getProperty("oracle.ide.prune.appclasspath"))) {
            PCLMain.truncateAppClassLoaderDelegate(mainLoader);
        }
        return extensionLoader;
    }

    private static List<File> getStaticPath(String paths, File macroDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        int limit = paths.length();
        int start = 0;
        while (start <= limit) {
            String path;
            int end;
            if (paths.regionMatches(start, "file:", 0, "file:".length())) {
                start += "file:".length();
            }
            if ((end = paths.indexOf(44, start)) < 0) {
                end = limit;
            }
            if ((path = paths.substring(start, end).trim()).length() > 0) {
                files.add(new File(macroDirectory, path));
            }
            start = end + 1;
        }
        return files;
    }

    private static void addCodeSource(PolicyClassLoader loader, ConfigurationOrigin origin, File entry) {
        if (PCLMain.isDebugBuild() && entry.isDirectory()) {
            PCLMain.generatePackagesTxtIfMissing(entry);
        }
        try {
            loader.addCodeSource(entry, origin);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void addJdkLibs(PolicyClassLoader loader) {
        String javaHome = System.getProperty("java.home");
        ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.JDK, javaHome);
        PCLMain.addCodeSource(loader, origin, new File(javaHome, "../lib/tools.jar"));
        PCLMain.addCodeSource(loader, origin, new File(javaHome, "../lib/dt.jar"));
    }

    private static void addIdeLibs(PolicyClassLoader loader, File macroDirectory, String bootClassPath) {
        PCLMain.addDTHotClasses(loader);
        PCLMain.addModularBuildClasses(loader);
        PCLMain.addPatchesDirectories(loader);
        PCLMain.addIdeBootClasses(loader, macroDirectory, bootClassPath);
        PCLMain.addCustomLauncherClasses(loader);
        PCLMain.addExtensionsExtraClasspath(loader, System.getProperty(INSTRUMENTED_CLASSPATH_PROPERTY_NAME));
    }

    private static void addExtensionsExtraClasspath(PolicyClassLoader loader, String extraClasspathJars) {
        if (extraClasspathJars != null) {
            File f = new File(extraClasspathJars);
            PCLMain.addCodeSource(loader, new ConfigurationOrigin(IdeConfigurationTypes.MODULAR_BUILD_OUTPUT, "emma"), f);
        }
    }

    private static void addCustomLauncherClasses(PolicyClassLoader loader) {
        String ideJarsStr = System.getProperty("initial.classpath");
        if (ideJarsStr != null) {
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.SYSTEM_PROPERTY, "initial.classpath");
            StringTokenizer st = new StringTokenizer(ideJarsStr);
            while (st.hasMoreTokens()) {
                String itemRelPath = st.nextToken();
                File file = new File(ORACLE_HOME, itemRelPath);
                if (!file.exists()) continue;
                file = FileUtils.getCanonicalFile(file);
                PCLMain.addCodeSource(loader, origin, file);
            }
        }
    }

    private static void addIdeBootClasses(PolicyClassLoader loader, File macroDirectory, String bootClassPath) {
        ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.HARDCODED_BOOT_ENTRY, "oracle.ide.boot.PCLMain.BOOT_ENTRIES");
        for (File file : PCLMain.getStaticPath(bootClassPath, macroDirectory)) {
            if (file.exists()) {
                file = FileUtils.getCanonicalFile(file);
            }
            PCLMain.addCodeSource(loader, origin, file);
        }
    }

    private static void addPatchesDirectories(PolicyClassLoader loader) {
        String patchesDirPaths = System.getProperty("ide.patches.dir");
        if (patchesDirPaths != null && patchesDirPaths.contains(",")) {
            for (String patchDirPath : patchesDirPaths.split(",")) {
                PCLMain.addPatchClasses(loader, patchDirPath);
            }
        } else {
            PCLMain.addPatchClasses(loader, patchesDirPaths);
        }
    }

    private static void addPatchClasses(PolicyClassLoader loader, String patchesDirPath) {
        File patchesDir;
        if (patchesDirPath != null && (patchesDir = new File(ORACLE_HOME, patchesDirPath)).isDirectory()) {
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.SYSTEM_PROPERTY, "ide.patches.dir");
            for (File patchJar : patchesDir.listFiles()) {
                String patchJarPath = patchJar.getPath();
                if (!patchJarPath.endsWith(".jar") && !patchJarPath.endsWith(".zip")) continue;
                PCLMain.addCodeSource(loader, origin, patchJar);
            }
        }
    }

    private static void addModularBuildClasses(PolicyClassLoader loader) {
        if (PCLMain.isDebugBuild() && !Boolean.getBoolean("ide.exclude.built.classes")) {
            Object[] moduleDirs;
            File builtDir = new File(ORACLE_HOME, "../built");
            if (!builtDir.isDirectory()) {
                builtDir = new File(ORACLE_HOME, "built");
            }
            if (builtDir.isDirectory() && (moduleDirs = builtDir.listFiles()) != null) {
                ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.MODULAR_BUILD_OUTPUT, builtDir.getPath());
                long start = System.currentTimeMillis();
                HashSet<String> included = null;
                String property = System.getProperty("ide.include.built.classes");
                if (property != null) {
                    included = new HashSet<String>(Arrays.asList(property.split(",")));
                }
                int added = 0;
                boolean useInstrumented = System.getProperty(INSTRUMENTED_CLASSPATH_PROPERTY_NAME) != null;
                Arrays.sort(moduleDirs);
                for (Object moduleDir : moduleDirs) {
                    File classesIgnoreFile1;
                    if (included != null && (!included.contains(((File)moduleDir).getName()) || !((File)moduleDir).isDirectory()) || (classesIgnoreFile1 = new File((File)moduleDir, ".ignore-built-classes")).exists()) continue;
                    File classesIgnoreFile2 = new File((File)moduleDir, "isolated.txt");
                    if (!classesIgnoreFile2.exists()) {
                        if (!PCLMain.addClassesDirectory((File)moduleDir, useInstrumented ? "classes-instrumented" : "classes", origin, loader)) continue;
                        ++added;
                        continue;
                    }
                    IsolatedExtensionsModuleOutputProcessor.readAndRegisterIsolatedExtension(classesIgnoreFile2);
                }
                if (!Boolean.getBoolean("ide.AssertTracingDisabled")) {
                    long time = System.currentTimeMillis() - start;
                    String message = String.format("Timing:%8sms] Added %d built classes %s to the classpath", "[" + time, added, added == 1 ? "directory" : "directories");
                    System.out.println(message);
                }
            }
        }
    }

    private static void addDTHotClasses(PolicyClassLoader loader) {
        String hotClasses = System.getProperty("edt.hot.classes");
        if (hotClasses != null) {
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.SYSTEM_PROPERTY, "edt.hot.classes");
            File file = new File(hotClasses);
            if (file.isDirectory()) {
                PCLMain.addCodeSource(loader, origin, file);
            }
        }
    }

    private static boolean addClassesDirectory(File moduleDir, String dir, ConfigurationOrigin origin, PolicyClassLoader loader) {
        File moduleClassesDir = new File(moduleDir, dir);
        if (moduleClassesDir.isDirectory()) {
            File[] files;
            boolean containsDirectory = false;
            for (File file : files = moduleClassesDir.listFiles()) {
                if (file == null || !file.isDirectory() || ".data".equals(file.getName())) continue;
                containsDirectory = true;
                break;
            }
            if (containsDirectory) {
                PCLMain.addCodeSource(loader, origin, moduleClassesDir);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatePackagesTxtIfMissing(File classesDir) {
        PrintWriter out = null;
        try {
            File packagesTxt = new File(classesDir, "packages.txt");
            if (!packagesTxt.exists()) {
                boolean mustTranslateToSlash = File.separatorChar != '/';
                ArrayList subdirs = new ArrayList();
                PCLMain.getAllDirs(classesDir, subdirs);
                subdirs.remove(classesDir);
                String classesDirStr = classesDir.getAbsolutePath();
                int len = classesDirStr.length() + 1;
                out = new PrintWriter(packagesTxt);
                out.println("# This packages.txt was auto-generated at runtime.");
                for (File f : subdirs) {
                    String packagePath = f.getAbsolutePath().substring(len);
                    if (mustTranslateToSlash) {
                        packagePath = packagePath.replace(File.separatorChar, '/');
                    }
                    out.println(packagePath);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void getAllDirs(File dir, ArrayList subdirs) {
        boolean hasFile = false;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                PCLMain.getAllDirs(f, subdirs);
                continue;
            }
            hasFile = true;
        }
        if (hasFile) {
            subdirs.add(dir);
        }
    }

    private static void addIdeNativeLibs(PolicyClassLoader pcl) {
        String oracleHomeStr = System.getProperty("oracle.home");
        File oracleHome = new File(oracleHomeStr);
        PCLMain.addNativeOracleLib(pcl);
        PCLMain.addOracleHomeBinNativeLibsOnWindows(pcl);
        PCLMain.addLdLibraryPathNativeLibsOnLinux(pcl);
    }

    private static void addLdLibraryPathNativeLibsOnLinux(PolicyClassLoader pcl) {
        String envLdLibraryPath;
        if ('/' == File.separatorChar && (envLdLibraryPath = System.getenv("LD_LIBRARY_PATH")) != null) {
            try {
                ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.NATIVE, envLdLibraryPath);
                pcl.addNativeCodeSource(envLdLibraryPath, origin);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addOracleHomeBinNativeLibsOnWindows(PolicyClassLoader pcl) {
        String envOracleHome;
        if ('\\' == File.separatorChar && (envOracleHome = System.getenv("ORACLE_HOME")) != null) {
            File oracleHomeBin = new File(envOracleHome, "bin");
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.NATIVE, oracleHomeBin.getPath());
            try {
                pcl.addNativeCodeSource(oracleHomeBin, origin);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addNativeOracleLib(PolicyClassLoader pcl) {
        File oracleHomeLib = new File(ORACLE_HOME, "lib");
        ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.NATIVE, oracleHomeLib.getPath());
        try {
            pcl.addNativeCodeSource(oracleHomeLib, origin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void checkForDeferredUpdates(ClassLoader parentClassLoader, File macroDirectory, String cfuInstallerPath) {
        File deferredUpdatesFile;
        String baseDir = System.getProperty("ide.user.dir");
        if (baseDir == null || baseDir.trim().length() == 0) {
            baseDir = ORACLE_HOME.getAbsolutePath();
        }
        if ((deferredUpdatesFile = new File(baseDir, "deferred-updates.xml")).exists()) {
            try {
                PCLMain.installUpdates(parentClassLoader, deferredUpdatesFile, PCLMain.getStaticPath(cfuInstallerPath, macroDirectory));
            }
            catch (IOException ioe) {
                deferredUpdatesFile.delete();
                ioe.printStackTrace();
            }
        }
    }

    private static void installUpdates(ClassLoader parentClassLoader, File script, List<File> cfuInstallerClassPath) throws IOException {
        URL[] cpEntries = new URL[cfuInstallerClassPath.size()];
        for (int i = 0; i < cpEntries.length; ++i) {
            cpEntries[i] = PCLMain.createTemporaryJarCopy(cfuInstallerClassPath.get(i)).toURL();
        }
        URLClassLoader updateLoader = new URLClassLoader(cpEntries, parentClassLoader);
        Thread.currentThread().setContextClassLoader(updateLoader);
        try {
            Class<?> duClazz = Class.forName(DEFERRED_UPDATE_MAIN_CLASS, true, updateLoader);
            Method mainMethod = duClazz.getMethod("install", null);
            mainMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error launching installer");
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTemporaryJarCopy(File jarFile) throws IOException {
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            File tempFile = File.createTempFile("oide", ".jar");
            tempFile.deleteOnExit();
            srcChannel = new FileInputStream(jarFile).getChannel();
            dstChannel = new FileOutputStream(tempFile).getChannel();
            ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
            File file = tempFile;
            return file;
        }
        finally {
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException ioe) {}
            }
            if (dstChannel != null) {
                try {
                    dstChannel.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static boolean isDebugBuild() {
        return Boolean.getBoolean("ide.debugbuild");
    }
}

