/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class IsolatedExtensionsModuleOutputProcessor {
    private static final Map<String, File> m_extensionIds2moduleOutputDirectory = new HashMap<String, File>();

    public static void readAndRegisterIsolatedExtension(File f) {
        assert (f.exists());
        File classesDirectory = new File(f.getParentFile(), "classes/");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(f));
            String extensionId = bufferedReader.readLine();
            m_extensionIds2moduleOutputDirectory.put(extensionId, classesDirectory);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean hasModularBuildDirectory(String extensionId) {
        return m_extensionIds2moduleOutputDirectory.containsKey(extensionId);
    }

    public static File getModularBuildDirectory(String extensionId) {
        return m_extensionIds2moduleOutputDirectory.get(extensionId);
    }
}

